/* WindowShade.h
   Rob Dobson 2013
   More details at http://robdobson.com/2013/10/moving-my-window-shades-control-to-mbed/
*/

#ifndef RD_WIN_SHADE
#define RD_WIN_SHADE

#include "mbed.h"

class WindowShade
{
    public:
        static const int MAX_SHADE_NAME_LEN = 20;
        static const long PULSE_ON_MILLISECS = 500;
        static const long MAX_SHADE_ON_MILLSECS = 60000;
        
        WindowShade(char* name, PinName up, PinName stop, PinName down);
        void ClearOutputs();
        void SetTimedOutput(DigitalOut* pPin, bool state, long msDuration, bool bClearExisting);
        void CheckTimeouts(int tickMs);
        void DoCommand(char* pDirn, char* pDuration);
    private:        
        char _shadeName[MAX_SHADE_NAME_LEN];
        DigitalOut* _pUpPin;
        DigitalOut* _pStopPin;
        DigitalOut* _pDownPin;
        long _msTimeout;
        int _tickCount;
        
};

#endif
