/* main.cpp
   Rob Dobson 2013
   More details at http://robdobson.com/2013/10/moving-my-window-shades-control-to-mbed/
*/

#include "mbed.h"
#include "EthernetInterface.h"
#include <stdio.h>
#include <string.h>
#include "RdWebServer.h"
#include "WindowShade.h"

#define PORT   80

Serial pc(USBTX, USBRX);

RdWebServer webServer;

EthernetInterface eth;

DigitalOut led1(LED1); //server listning status
DigitalOut led2(LED2); //socket connecting status

Ticker ledTick;

const int TICK_MS = 250;
const int MAX_WINDOW_SHADES = 5;
int numWindowShades = 0;
WindowShade* pWindowShades[MAX_WINDOW_SHADES];
char* indexHtmName = "";

void ledTickfunc()
{
    if(webServer.isListening())
    {
        led1 = !led1;
    }
    else
    {
        led1 = false;
    }
    for (int shadeIdx = 0; shadeIdx < numWindowShades; shadeIdx++)
        pWindowShades[shadeIdx]->CheckTimeouts(TICK_MS);
}

void handleCmd_blindControl(char* cmdStr, char* argStr)
{
    printf("BLINDS COMMAND %s %s\n\r", cmdStr, argStr);
    if (argStr == NULL)
        return;
    char* pch = strtok (argStr,"/");
    if (pch == NULL)
        return;
    int blindNum = pch[0] - '0';
    if (blindNum < 1 || blindNum > MAX_WINDOW_SHADES)
        return;
    int blindIdx = blindNum-1;
    char* pDirn = strtok (NULL,"/");
    if (pDirn == NULL)
        return;
    char* pDuration = strtok (NULL,"/");
    if (pDuration == NULL)
        return;
    pWindowShades[blindIdx]->DoCommand(pDirn, pDuration);
}

void setShadesConfig()
{
    printf("Rob Blinds Server - Configured for ");
    // Check for a config file on the local file system
    LocalFileSystem local("local");
    FILE* fp = fopen("office.cnf", "r");
    if (fp != NULL)
    {
        fclose(fp);
        indexHtmName = "ixoffice.htm";
        pWindowShades[0] = new WindowShade("Left", p15, p16, p17);
        pWindowShades[1] = new WindowShade("Mid-left", p18, p19, p20);
        pWindowShades[2] = new WindowShade("Mid-right", p21, p22, p23);
        pWindowShades[3] = new WindowShade("Right", p24, p25, p26);
        pWindowShades[4] = new WindowShade("Rob's", p27, p28, p29);
        numWindowShades = 5;
        printf("Office Blinds\n\r");
    }
    else
    {
        indexHtmName = "ixgames.htm";
        pWindowShades[0] = new WindowShade("Blind1", p21, p22, p23);
        pWindowShades[1] = new WindowShade("Blind2", p24, p25, p26);
        numWindowShades = 2;    
        printf("Playroom Blinds\n\r");
    }
}

int main (void)
{
    pc.baud(115200);
    
    setShadesConfig();
    
    ledTick.attach(&ledTickfunc,TICK_MS / 1000.0);

    // setup ethernet interface
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());

    webServer.addCommand("", RdWebServerCmdDef::CMD_LOCALFILE, NULL, indexHtmName, true);
    webServer.addCommand("gear-gr.png", RdWebServerCmdDef::CMD_LOCALFILE, NULL, NULL, true);
    webServer.addCommand("blind", RdWebServerCmdDef::CMD_CALLBACK, &handleCmd_blindControl);
    webServer.init(PORT, &led2);
    webServer.run();
}
