/* WindowShade.cpp
   Rob Dobson 2013
   More details at http://robdobson.com/2013/10/moving-my-window-shades-control-to-mbed/
*/

#include "WindowShade.h"

WindowShade::WindowShade(char* name, PinName up, PinName stop, PinName down)
{
    strncpy(_shadeName, name, MAX_SHADE_NAME_LEN);
    _shadeName[MAX_SHADE_NAME_LEN-1] = '\0';
    _pUpPin = new DigitalOut(up);
    _pStopPin = new DigitalOut(stop);
    _pDownPin = new DigitalOut(down);
    _msTimeout = 0;
    _tickCount = 0;
    
}

void WindowShade::ClearOutputs()
{
     // Clear any existing command
    _msTimeout = 0;
    _tickCount = 0;
    *_pUpPin = false;
    *_pStopPin = false;
    *_pDownPin = false;
}

void WindowShade::SetTimedOutput(DigitalOut* pPin, bool state, long msDuration, bool bClearExisting)
{
//            printf("Setting %s %d %ld %d\n\r", _shadeName, state, msDuration, bClearExisting);

    if (bClearExisting)
        ClearOutputs();
    *pPin = state;
    if (msDuration != 0)
    {
        _msTimeout = msDuration;
        _tickCount = 0;
    }
}

void WindowShade::CheckTimeouts(int tickMs)
{
    // Couldn't get Timer to work so doing with a tick-count
    if (_msTimeout != 0)
    {
        _tickCount++;
        if ((_tickCount-1)*tickMs > _msTimeout)
        {
            ClearOutputs();
            _msTimeout = 0;
        }
    }
}

void WindowShade::DoCommand(char* pDirn, char* pDuration)
{
//            printf("DoCommand %s %s %s\n\r", _shadeName, pDirn, pDuration);
    
    // Duration and state
    int state = false;
    int msDuration = 0;
    if (strcmp(pDuration, "on") == 0)
    {
        state = true;
        msDuration = MAX_SHADE_ON_MILLSECS;
    }
    else if (strcmp(pDuration, "off") == 0)
    {
        state = false;
        msDuration = 0;
    }
    else if (strcmp(pDuration, "pulse") == 0)
    {
        state = true;
        msDuration = PULSE_ON_MILLISECS;
    }
    
    // Direction & config
    if (strcmp(pDirn, "up") == 0)
    {
        SetTimedOutput(_pUpPin, state, msDuration, true);
    }
    else if (strcmp(pDirn, "stop") == 0)
    {
        SetTimedOutput(_pStopPin, state, msDuration, true);
    }
    else if (strcmp(pDirn, "down") == 0)
    {
        SetTimedOutput(_pDownPin, state, msDuration, true);
    }
    else if (strcmp(pDirn, "setuplimit") == 0)
    {
        SetTimedOutput(_pStopPin, state, 0, true);
        SetTimedOutput(_pDownPin, state, msDuration, false);
    }
    else if (strcmp(pDirn, "setdownlimit") == 0)
    {
        SetTimedOutput(_pStopPin, state, 0, true);
        SetTimedOutput(_pUpPin, state, msDuration, false);
    }
    else if (strcmp(pDirn, "resetmemory") == 0)
    {
        SetTimedOutput(_pStopPin, state, 0, true);
        SetTimedOutput(_pDownPin, state, 0, false);
        SetTimedOutput(_pUpPin, state, msDuration, false);
    }                            
    
}