#ifndef Onewire_h
#define Onewire_h

#include "mbed.h"

#define ONEWIRE_ADDR_BYTES 8

const int ONEWIRE_OK = 0;
const int ONEWIRE_FAIL_STUCK_LOW = 1;
const int ONEWIRE_SEARCH_ALL_DONE = 2;
const int ONEWIRE_SEARCH_INIT_FAIL = 3;
const int ONEWIRE_SEARCH_NOT_FOUND = 4;
const int ONEWIRE_SEARCH_COMP_BIT_ERR = 5;

class Onewire
{

public:    
    Onewire(PinName oneBus);
    void writeBit(int bit);
    int readBit();
    int init();
    int readByte();
    void writeByte(char data);
    unsigned char CRC(unsigned char* addr, unsigned char len);
    char* GetErrorStr(int errCode);

    // Clear the search state so that if will start from the beginning again.
    void reset_search();
    // Look for the next device.
    // Returns 
    // ONEWIRE_OK if a new address has been returned.
    // ONEWIRE_SEARCH_ALL_DONE = all devices found
    // ONEWIRE_SEARCH_INIT_FAIL = failed to init
    // ONEWIRE_SEARCH_NOT_FOUND = no devices found
    // It might be a good idea to check the CRC to make sure you didn't
    // get garbage.  The order is deterministic. You will always get
    // the same devices in the same order.
    uint8_t search(uint8_t *newAddr);    
    
private:
    DigitalInOut oneBus_;
  
    // search state
    unsigned char _search_ROM_NO[8];
    uint8_t _search_LastDiscrepancy;
    uint8_t _search_LastFamilyDiscrepancy;
    uint8_t _search_LastDeviceFlag;
};
#endif