
#ifndef __SampleChannel__H__
#define __SampleChannel__H__

const int NUM_FILTER_VALS = 10;
const int TRIGGER_WINDOW = 3;
const int NUM_RETURN_SAMPLES = 20;

class SampleChannel
{
    private:
        UUID chanUuid;
        uint16_t sampleThreshold;
        uint16_t sampleDivisor;
        uint16_t filterBuf[NUM_FILTER_VALS];
        int curFilterIdx;
        uint8_t sampleBuf[NUM_RETURN_SAMPLES];
        int curSampleIdx;
        bool isCapturing;
        void AddSample(uint16_t val);
        AnalogIn ain;
        int GetAvgOutsideTriggerWindow();
        int GetAvgOfTriggerWindow();
        uint16_t GetLowest();
        Serial* pLocalLogger;
        uint16_t sampleBaseVal;
        
    public:
        SampleChannel(PinName pin, const UUID uuid, Serial* pLogger);
        void SetThreshold(uint16_t threshold);
        void SetDivisor(uint16_t divisor);
        void Service();
        bool IsSampling();
        bool AreSamplesReady();
        void StopSampling();
        void StartSampling();
        bool CheckTrigger();
        uint8_t *GetSamples();
        int GetSamplesLen();
        UUID GetUUID() {
            return chanUuid;
        }
};

#endif