/*
TélécoBot Recepteur V2
Bagrowski 2019

pour pairer 2 robots changer l'adresse dans le .h de la bibliothèque
*/


#include "mbed.h"
#include "nRF24L01P.h"


////////////////////////////////////////                DEFINE                ////////////////////////////////////////
//longeur de la trame de la mbed1 vers la mbed2
#define LONGTRAME 8
//mode débugage (0= sans, 1= avec)
#define DEBUG 0

//emplacement des données dans la trame
#define TRAMEETAT 0
#define TRAMEBPG 1
#define TRAMEBPD 2
#define TRAMEBPH 3
#define TRAMEBPB 4
#define TRAMEBPBOOST 5
#define TRAMEBPSERVO 6
#define TRAMEFIN 7

//caractère de fin trame
#define CARACFIN 42

//période moteurs
#define PERIODMOTEUR 0.00005

//vitesse des moteurs
#define VMOTARRET 0
#define VMOT1 15
#define VMOT2 10
#define VMOTROTATION 10
#define VMOTBOOST 30
#define AVANT 1
#define ARRIERE 0


////////////////////////////////////////                Entrées               ////////////////////////////////////////
AnalogIn UBat5V (p20);
AnalogIn UBat12V (p19);
//FdC
InterruptIn FdC (p15);

////////////////////////////////////////                Sorties               ////////////////////////////////////////
DigitalOut myled1(LED1);

//Sens des 2 moteurs
DigitalOut MotGSens (p24);
DigitalOut MotDSens (p30);

//PWM des moteurs
PwmOut MotGPwm (p25);
PwmOut MotDPwm (p26);

PwmOut ServoMoteur (p21);

//Mbed 2
DigitalOut Pin1 (p17);
DigitalOut Pin2 (p18);


////////////////////////////////////////              Liaison SPI              ////////////////////////////////////////
nRF24L01P my_nrf24l01p(p5, p6, p7, p9, p8, p16);    // mosi, miso, sck, csn, ce, irq: non connecté


////////////////////////////////////////             Timer/Ticker             ////////////////////////////////////////


////////////////////////////////////////              Prototypes              ////////////////////////////////////////
//Initialisation
void Init (void);
//Réception des données de la mbed1
void Reception24 (void);
//Deplacement
void Move(void);


////////////////////////////////////////           Variables globales          ////////////////////////////////////////
//Trames de réception vers le mbed 1
char gctabTrame[LONGTRAME];
char gctabTrameR[LONGTRAME];
//Trame dans laquelle on stocke la Trame de réception lorsqu'elle est valide
char gctabUtile[LONGTRAME];
//Etat Principal
int giEtat1=0, giLTrameRecue=0, i=0;
int giBPDec=0;
int giVMotG=0, giVMotD=0, giSMotG= 0, giSMotD= 0;


////////////////////////////////////////              Liaison série            ////////////////////////////////////////
Serial pc(USBTX, USBRX); // tx, rx


////////////////////////////////////////                 Main                 ////////////////////////////////////////
int main() {
    
    Init();
    while(1) {
        Reception24();
        
        //Création d'un bus avec les valeurs entières du tableau d'état des BP
        giBPDec = 8*(gctabTrame[TRAMEBPG]-48) + 4*(gctabTrame[TRAMEBPD]-48) + 2*(gctabTrame[TRAMEBPH]-48) + 1*(gctabTrame[TRAMEBPB]-48);
        
        //gestion des états des BP
        switch(giBPDec){
            //Arrière
            case 1:
                giVMotG= VMOT1;
                giSMotG= ARRIERE;
                
                giVMotD= VMOT1;
                giSMotD= ARRIERE;
                break;
                
            //Avant
            case 2:
                giVMotG= VMOT1;
                giSMotG= AVANT;
                
                giVMotD= VMOT1;
                giSMotD= AVANT;
                break;
            //Droite
            case 4:
                giVMotG= VMOTROTATION;
                giSMotG= AVANT;
                
                giVMotD= VMOTROTATION;
                giSMotD= ARRIERE;
                break;
            //Arrière droite
            case 5:
                giVMotG= VMOTARRET;
                giSMotG= AVANT;
                
                giVMotD= VMOT2;
                giSMotD= ARRIERE;
                break;
            //Avant droite
            case 6:
                giVMotG= VMOT2;
                giSMotG= AVANT;
                
                giVMotD= VMOTARRET;
                giSMotD= AVANT;
                break;
            //Gauche
            case 8:
                giVMotG= VMOTROTATION;
                giSMotG= ARRIERE;
                
                giVMotD= VMOTROTATION;
                giSMotD= AVANT;
                break;
            //Arrière gauche
            case 9:
                giVMotG= VMOT2;
                giSMotG= ARRIERE;
                
                giVMotD= VMOTARRET;
                giSMotD= AVANT;
                break;
            //Avant gauche
            case 10:
                giVMotG= VMOTARRET;
                giSMotG= AVANT;
                
                giVMotD= VMOT2;
                giSMotD= AVANT;
                break;
            default:
                giVMotG= VMOTARRET;
                giSMotG= AVANT;
                
                giVMotD= VMOTARRET;
                giSMotD= AVANT;
        }
        
        //Arret moteur éjecteur
        if(gctabTrame[TRAMEBPBOOST] == 48 && gctabTrame[TRAMEBPSERVO] == 48)
        {
            if(DEBUG == 1) printf("\n\rArret");
            Pin1.write(0);
            Pin2.write(0);
        }
        
        //Récolte
        if(gctabTrame[TRAMEBPBOOST] == 49 && gctabTrame[TRAMEBPSERVO] == 48)
        {
            if(DEBUG == 1) printf("\n\rRecolte");
            Pin1.write(1);
            Pin2.write(0);
        }
        
        //Ejection
        if(gctabTrame[TRAMEBPBOOST] == 48 && gctabTrame[TRAMEBPSERVO] == 49)
        {
            if(DEBUG == 1) printf("\n\rEjection");
            Pin1.write(0);
            Pin2.write(1);
        }
        
        Move();
    }
}

////////////////////////////////////////                Fonctions               ////////////////////////////////////////
//Initialisation
void Init ()
{   
    //Emetteur Recepteur 2,4GHz
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setTransferSize(LONGTRAME);
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.disable();
    my_nrf24l01p.enable();
    
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    //pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n\n", my_nrf24l01p.getRxAddress() );
    
    //Moteurs
    MotGPwm.period(PERIODMOTEUR);
    MotDPwm.period(PERIODMOTEUR);
}

//Réception des données du mbed1
void Reception24 ()
{
    // If we've received anything in the nRF24L01+...
    if ( my_nrf24l01p.readable() ) {
        // ...read the data into the receive buffer
        giLTrameRecue = my_nrf24l01p.read( NRF24L01P_PIPE_P0, gctabTrame, LONGTRAME);
        myled1 = !myled1;
    }
    
    if(DEBUG == 1)
    {
        if(gctabTrame[TRAMEBPG] == 49) printf("\n\n\r Bouton Gauche");
        if(gctabTrame[TRAMEBPD] == 49) printf("\n\n\r Bouton Droit");
        if(gctabTrame[TRAMEBPH] == 49) printf("\n\n\r Bouton Haut");
        if(gctabTrame[TRAMEBPB] == 49) printf("\n\n\r Bouton Bas");
        if(gctabTrame[TRAMEBPBOOST] == 49) printf("\n\n\r Bouton Boost");
        if(gctabTrame[TRAMEBPSERVO] == 49) printf("\n\n\r Bouton Servo");
    }
}

//Deplacement
void Move()
{   
    MotGSens.write(giSMotG);
    MotGPwm.pulsewidth_us(giVMotG);
    
    MotDSens.write(giSMotD);
    MotDPwm.pulsewidth_us(giVMotD);
}
