/*
TélécoBot Emetteur V1
Bagrowski 2019

pour pairer 2 robots changer l'adresse dans le .h de la bibliothèque

Le code n'est pas optimisé, car la trame envoyé est l'état de tous les boutons 
et ils sont stockés dans une variable giBPDec à la réception, il vaudrait mieux 
créer cette variable avant l'émission et l'envoyer seule, ça racourcirait la trame, 
donc le temps d'émission et on pourrait émettre plus souvent
*/


#include "mbed.h"
#include "nRF24L01P.h"


////////////////////////////////////////                DEFINE                ////////////////////////////////////////
//longeur de la trame de la mbed1 vers la mbed2
#define LONGTRAME 8
//mode débugage (0= sans, 1= avec)
#define DEBUG 1

//emplacement des données dans la trame
#define TRAMEETAT 0
#define TRAMEBPG 1
#define TRAMEBPD 2
#define TRAMEBPH 3
#define TRAMEBPB 4
#define TRAMEBPBOOST 5
#define TRAMEBPSERVO 6
#define TRAMEFIN 7

//caractère de fin trame
#define CARACFIN 42

#define PERIODLED 100

////////////////////////////////////////                Entrées               ////////////////////////////////////////
DigitalIn BPGauche (p10);
DigitalIn BPDoite (p11);
DigitalIn BPHaut (p12);
DigitalIn BPBas (p13);
DigitalIn BPBoost (p14);
DigitalIn BPServo (p15);
AnalogIn UBat5V (p20);


////////////////////////////////////////                Sorties               ////////////////////////////////////////
PwmOut LedServo (p21);
PwmOut LedBoost (p22);
DigitalOut myled1(LED1);


////////////////////////////////////////              Liaison SPI              ////////////////////////////////////////
nRF24L01P my_nrf24l01p(p5, p6, p7, p9, p8, p16);    // mosi, miso, sck, csn, ce, irq: non connecté


////////////////////////////////////////             Timer/Ticker             ////////////////////////////////////////
//Ticker appelant la fonction d'envoi
Ticker ticEnvoi;


////////////////////////////////////////              Prototypes              ////////////////////////////////////////
//Initialisation
void Init (void);
//Envoi des données à la mbed2
void Envoi (void);
//Acquisition état Boutons Poussoirs
void Acquisition (void);
//Affectation de la valeur des BP dans la Trame
void AffectTrameBp (void);


////////////////////////////////////////           Variables globales          ////////////////////////////////////////
//Trames d'envoi vers le mbed 2
char gctabTrame[LONGTRAME];
//Boutons poussoirs
int giBpGauche, giBpDroite, giBpHaut, giBpBas, giBpBoost, giBpServo;
//Etat Principal
int giEtat1= 0;


////////////////////////////////////////              Liaison série            ////////////////////////////////////////
Serial pc(USBTX, USBRX); // tx, rx


////////////////////////////////////////                 Main                 ////////////////////////////////////////
int main() {
    int i;
    
    Init();
    
    while(1) {
        Acquisition();
        AffectTrameBp();
        
        /*
        if(giBpBoost == 1) LedBoost.write(1);
        else LedBoost.write(0);
        if(giBpServo == 1) LedServo.write(1);
        else LedServo.write(0);
        */
    }
}

////////////////////////////////////////                Fonctions               ////////////////////////////////////////
//Initialisation
void Init(void)
{
    //Mode PullUp des Boutons Poussoirs
    BPGauche.mode(PullUp);
    BPDoite.mode(PullUp);
    BPHaut.mode(PullUp);
    BPBas.mode(PullUp);
    BPBoost.mode(PullUp);
    BPServo.mode(PullUp);
    
    //Envoi
    ticEnvoi.attach(&Envoi, 0.02);
    
    //Affectation du caractère de fin dans la trame
    gctabTrame[TRAMEFIN]= CARACFIN;
    
    //Emetteur Recepteur 2,4GHz
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setTransferSize(LONGTRAME);
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.disable();
    my_nrf24l01p.enable();
    
    // Display the (default) setup of the nRF24L01+ chip
    printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    printf( "nRF24L01+ RX Address   : 0x%010llX\r\n\n", my_nrf24l01p.getRxAddress() );
    
    
    //PWM
    LedServo.period_us(PERIODLED);
    LedBoost.period_us(PERIODLED);
}

//Envoi des données à la mbed2
void Envoi ()
{   
    // Send the transmitbuffer via the nRF24L01+
    my_nrf24l01p.write(NRF24L01P_PIPE_P0, gctabTrame, LONGTRAME);
        
    //printf("\n\rEnvoi\n");
    myled1 = !myled1;
}

//Acquisition valeurs Boutons Poussoirs
void Acquisition (void)
{
    //Acquisition et stockage de la valeur des BP
    giBpGauche= !BPGauche.read();
    giBpDroite= !BPDoite.read();
    giBpHaut= !BPHaut.read();
    giBpBas= !BPBas.read();
    giBpBoost= BPBoost.read();
    giBpServo= BPServo.read();
    
    if(DEBUG == 1)
    {
        //Affichage de l'état des BP pour le débugage
        printf("\n\n\rBpGauche: %d",giBpGauche);
        printf("\n\rBpDroite: %d",giBpDroite);
        printf("\n\rBpHaut: %d",giBpHaut);
        printf("\n\rBpBas: %d",giBpBas);
        printf("\n\rgiBpBoost: %d",giBpBoost);
        printf("\n\rgiBpServo: %d",giBpServo);
    }
}

//Affectation de la valeur des BP dans la Trame
void AffectTrameBp()
{
    gctabTrame[TRAMEETAT] = 48+(char)giEtat1 ;
    
    gctabTrame[TRAMEBPG]= 48+(char)giBpGauche;
    gctabTrame[TRAMEBPD]= 48+(char)giBpDroite;
    gctabTrame[TRAMEBPH]= 48+(char)giBpHaut;
    gctabTrame[TRAMEBPB]= 48+(char)giBpBas;
    gctabTrame[TRAMEBPBOOST]= 48+(char)giBpBoost;
    gctabTrame[TRAMEBPSERVO]= 48+(char)BPServo;
}