//Cachan Programme Principal mbed 1
#include "mbed.h"
#include "Grove_LCD_RGB_Backlight.h"


////////////////////////////////////////                DEFINE                ////////////////////////////////////////
//période servomoteur
#define PERIODSERVO 0.02


//angle du servomoteur du perceur en position éteint
#define ANGLESERVOARRET 19275
//angle du servomoteur du perceur à hauteur du ballon
#define ANGLEBALLON 18000

//longeur de la trame de la mbed1 vers la mbed2
#define LONGTRAME1TO2 6



////////////////////////////////////////                Entrées               ////////////////////////////////////////


////////////////////////////////////////                Sorties               ////////////////////////////////////////
//Sens des 2 moteurs principaux
DigitalOut MotGSens (p16);
DigitalOut MotDSens (p17);

//PWM du servo de perçage, du moteur de perçage et des moteurs principaux
PwmOut servo(p23);


////////////////////////////////////////             Timer/Ticker             ////////////////////////////////////////


////////////////////////////////////////              Prototypes              ////////////////////////////////////////
void Percage (void);


////////////////////////////////////////           Variables globales          ////////////////////////////////////////
//Angle donné au servo, qui est un pulsewidth
int giAngle= ANGLESERVOARRET;


////////////////////////////////////////                 Main                 ////////////////////////////////////////
int main()
{
        servo.period(PERIODSERVO);

    while(1) {
    Percage ();
    wait(1);
    }
}


////////////////////////////////////////                Fonctions               ////////////////////////////////////////


//Déplacement pré-reglé du servo de perçage et 1/0 moteur de perçage
void Percage ()
{
    int i;
    
    //Montée du bras
    for(i=ANGLESERVOARRET; i>=ANGLEBALLON; i=i-50) {
        //printf("angle=%d\n\r", i);
        servo.pulsewidth_us(i);
        wait(0.01);
    }
    //Arret en haut
    wait(1);
    for(i=ANGLEBALLON; i<=ANGLESERVOARRET; i=i+25) {
        //printf("angle=%d\n\r", i);
        servo.pulsewidth_us(i);
        wait(0.01);
    }
}