#include "mbed.h"

#define ON         0x00
#define OFF        0x01
#define ALWAYS     0x01
#define CLEAR_7SEG 0x76

// PC <-USB-> Microcontroller:
Serial pc(USBTX, USBRX); // tx, rx

// 7segment <-SPI-> Microcontroller:
SPI seg7(p11, p12, p13);

// Slave select:
DigitalOut cs(p14);


int main()
{
    int value = 0;
    cs        = OFF;
    
    while(ALWAYS)
    {
        pc.printf("Value: ");
        pc.scanf("%d", &value);
        pc.printf("%d\r\n", value);
        
        cs = ON;
        
        // Clear and write data:
        seg7.write(CLEAR_7SEG);
        wait(0.2);   
        seg7.write(value);
        
        cs = OFF;
    }
}