#include "mbed.h"
#include "Adafruit_SSD1306.h"
 
 // an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(400000);
        start();
    };
};

I2C myI2C(p9,p10);
Adafruit_SSD1306_I2c myGUI(myI2C,D13,0x78,64,128);


 
int main()
{
 
 myGUI.begin(); 
 wait_ms(2000); // 2 s for Logo to be displayed
 

 
 myGUI.clearDisplay();
 
 fillScreen(1);
 
 wait_ms(2000);
  
 myGUI.clearDisplay();
 
 myGUI.printf("%ux%u OLED Display\r\n", myGUI.width(), myGUI.height());
 myGUI.display();
 
//this will scan the i2c bus and print deviceaddresses to terminal
  for (int i=0; i<=254; i=i+2) 
  {
    if (myI2C.write(i, NULL, 0) ==0) printf("I2C device detected at address=%2.2X\n\r", i);
  }  
 
 while(1){ }
 }
 
