/*  All modem code Aeris code and have been removed to get the ST Mems sensor board to function initially.
 *  This was done to see if anything was working at all.  Currently the sensors are read every 33 seconds.
 *  This can be changed to a higher speed to capture more interesting events.
 */ 

/* This is an example program which reads in the 3-axis acceleration, pressure, and temperature data from
 * a sensor board. It then uses the Dragonfly board to send the read data over a cellular connection to Aeris AerCloud using an MQTT client protocol.
 */

#include "mbed.h"
#include "mtsas.h"
#include "PubSubClient.h"
#include "x_cube_mems.h"

//
// PLEASE READ THIS!
//
// Example was created for the following hardware:
//   ST Sensor Board  http://developer.mbed.org/teams/ST-Americas-mbed-Team/wiki/Getting-Started-with-Nucleo-Sensors
//   MultiTech Dragonfly: 
//
// To get the sample running, you'll need to fill in the following parameters below
//   Your cellular provider's APN: _APN
//   AerCloud API Key: _AERCLOUD_API_APIKEY
//   AerCloud Account ID: _AERCLOUD_ACCOUNT_ID
//   AerCloud Container: _AERCLOUD_CONTAINER
//   AerCloud Subscription: _AERCLOUD_SUBSCRIPTION_ID[]
//
// The AerCloud container needa a Data Model with the following schema:
//    accel_X  "xxx" String
//    accel_y  "yyy" String
//    accel-Z  "zzz" String
//    "pressure" FLOAT
//    "temperature" FLOAT
//    "humidity" FLOAT
//    Magnitometer_X  "magX" String
//    Magnitometer_Y  "magY" String
//    Magnitometer_Z  "magZ" String
//    Gyro_X  "gyrX" String
//    Gyro_Y  "gyrY" String
//    Gyro_Z  "gyrZ" String
//
// To check if data has made it in the container, create a long polling subscription in AerPort
//
// http://longpoll.aercloud.aeris.com/v1/1/containers/subscriptions/<subscrption_name>/notificationChannels/longPoll?apiKey=<api_key>
//
// You should see the something that looks like this in the browser:
// {"sclContentInstances":[{"sclId":"nucleo-0001","containerId":"Nucleo_Test","contentInstance":{"id":"a40c8e60-8248-11e4-8b38-0677f0dfdf5e","contentSize":90,"creationTime":1418420922950,"content":{"contentType":"application/json","contentTypeBinary":"{\"x\":0.005615,\"y\":-0.041260,\"z\":1.015137,\"pressure\":101098.500000,\"temperature\":25.125000}"}}},
//



// const char _APN[] = "aer.aerisapn.net";                                    //  Cellular provider APN address for data services
// const char _APN[] = "aer05.aerisapn.net";

//char _AERCLOUD_API_KEY[] ="_Click_On_KEY_AerCloud_Tab";
//char _AERCLOUD_ACCOUNT_ID[] = "_Company_Number_Top_of_Page";        //  account ID.
//char _AERCLOUD_CONTAINER[] = "_From_Container_Page";                //  new container name
//char _AERCLOUD_DEVICE_ID[] = "_Random_Title";                       //  title with unique identifier, i.e. last 4 digits of IMEI
//char _AERCLOUD_SUBSCRIPTION_ID[] = "_Random_Subscription_ID";          // created at Continer Name then Subscription ID for LongPoll
//
//char _host[] = "mqtt.aercloud.aeris.com";
//int _port = 1883;


#define DATA_INTERVAL 3                                            // delay between samples, could be reduced for quicker response and more data

//void callback(char* topic, char* payload, unsigned int len)
//{
//    logInfo("topic: [%s]\r\npayload: [%s]", topic, payload);
//}
//
DigitalOut myled(PA_0);                 // D3
//Serial pc(PA_2, PA_3);        // D1-PA_2-SERIAL_TX, D0-PA_3-SERIAL_RX
volatile float TEMPERATURE_Value_C;
volatile float TEMPERATURE_Value_F;
volatile float PRESSURE_Value;
volatile AxesRaw_TypeDef ACC_Value;
//volatile float HUMIDITY_Value;
volatile AxesRaw_TypeDef MAG_Value;
//volatile AxesRaw_TypeDef GYR_Value;

int main()
{
    printf("\r\n\r\nHello!\r\n\r\n");
    MTSLog::setLogLevel(MTSLog::TRACE_LEVEL);

    // for Nucleo boards
//    MTSSerialFlowControl io(RADIO_TX, RADIO_RX, RADIO_RTS, RADIO_CTS);    // Tx, Rx, RTS, CTS
//    io.baud(115200);

//    Cellular* radio = CellularFactory::create(&io);
//    if (! radio) {
//        logFatal("failed to create Cellular object - exiting");
//        return 1;
//    }

//    radio->configureSignals(RADIO_DCD,RADIO_DTR,RESET);          // DCD:JP10-4 to D11:X4-4, DTR:JP10-10 to D7:JP10-9  (Modified Flow Control for ST Sensor Board)
//    Transport::setTransport(radio);                 // Required to control Cell Radios vs WiFi solutions

//    while (radio->setApn(_APN) != MTS_SUCCESS) {
//        logError("failed to set APN [%s]", _APN);
//        wait(2);
//    }

//    while (! radio->connect()) {
//        logError("failed to bring up PPP link");
//        wait(2);
//   }

//    printf("Signal Strength: %d\n\r", radio->getSignalStrength()); //Check the signal strength should be above 8

//    printf("data is stored at:\n\r\r");
//    printf("http://longpoll.aercloud.aeris.com/v1/%s/containers/subscriptions/%s/notificationChannels/longPoll?apiKey=%s",_AERCLOUD_ACCOUNT_ID,_AERCLOUD_SUBSCRIPTION_ID,_AERCLOUD_API_KEY);
//    printf(" \n\r \n\r");

// If you suspect a connectivity issue, uncomment the code below and if ping works.  If you are not getting a
//  valid ping, there's a connectivity problem.  First step is to verify you've got the right APN set
//
// Try pinging default server "8.8.8.8" (Google's DNS)
//    int ping_valid = 0;
//    while (ping_valid == 0) {
//        ping_valid = radio->ping();
//        printf("Ping Valid: %s\n\r", ping_valid ? "true" : "false");
//        //
//        if (ping_valid == 0) {
//            wait(3);
//            printf("wait 33");
//            wait(33);
//
//        }
//    }

//    PubSubClient mqtt(_host, _port, callback);

//    char buf[128];

    static X_CUBE_MEMS *mems_expansion_board = X_CUBE_MEMS::Instance();


    /*    while (true) {
            if (! mqtt.connect(_AERCLOUD_DEVICE_ID, _AERCLOUD_ACCOUNT_ID, _AERCLOUD_API_KEY)) {
                logError("failed to connect to AerCloud Server");
                wait(1);
                continue;
            }
    */

    for (int i = 0; i < 101 ; i++) {
    /* Get instantaneous data from half of the sensors */
    mems_expansion_board->hts221.GetTemperature((float *)&TEMPERATURE_Value_C);
    mems_expansion_board->lps25h.GetPressure((float *)&PRESSURE_Value);
    mems_expansion_board->lsm6ds0.Acc_GetAxes((AxesRaw_TypeDef *)&ACC_Value);
//        mems_expansion_board->hts221.GetHumidity((float *)&HUMIDITY_Value);
        mems_expansion_board->lis3mdl.GetAxes((AxesRaw_TypeDef *)&MAG_Value);
//        mems_expansion_board->lsm6ds0.Gyro_GetAxes((AxesRaw_TypeDef *)&GYR_Value);



        printf("Temperature:\t\t %f C\r\n", TEMPERATURE_Value_C );
        printf("Pressure:\t\t %f hPa\r\n", PRESSURE_Value);
        printf("Accelerometer (mg):\t X: %d, Y: %d, Z: %d\r\n", ACC_Value.AXIS_X, ACC_Value.AXIS_Y, ACC_Value.AXIS_Z);
//        printf("Humidity:\t\t %f%%\r\n", HUMIDITY_Value);
        printf("Magnetometer (mGauss):\t mX: %d, mY: %d, mZ: %d\r\n", MAG_Value.AXIS_X, MAG_Value.AXIS_Y, MAG_Value.AXIS_Z);
//        printf("Gyroscope (mdps):\t X: %d, Y: %d, Z: %d\r\n", GYR_Value.AXIS_X, GYR_Value.AXIS_Y, GYR_Value.AXIS_Z);
        printf("\r\n");

        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        wait(1.0); // 1 sec


//        snprintf(buf, sizeof(buf), "{\"xxx\":%d,\"yyy\":%d,\"zzz\":%d,\"pressure\":%f,\"temperature\":%f,\"humidity\":%f,\"magX\":%d,\"magY\":%d,\"magZ\":%d,\"gyrX\":%d,\"gyrY\":%d,\"gyrZ\":%d}",ACC_Value.AXIS_X, ACC_Value.AXIS_Y, ACC_Value.AXIS_Z, PRESSURE_Value, TEMPERATURE_Value_C, HUMIDITY_Value, MAG_Value.AXIS_X, MAG_Value.AXIS_Y, MAG_Value.AXIS_Z, GYR_Value.AXIS_X, GYR_Value.AXIS_Y, GYR_Value.AXIS_Z);
        /*        snprintf(buf, sizeof(buf), "{\"xxx\":%d,\"yyy\":%d,\"zzz\":%d,\"pressure\":%f,\"temperature\":%f}",ACC_Value.AXIS_X, ACC_Value.AXIS_Y, ACC_Value.AXIS_Z, PRESSURE_Value, TEMPERATURE_Value_C);
         *       logInfo("publishing: [%s]\n\r", buf);
         *       if (! mqtt.publish(_AERCLOUD_CONTAINER, buf)) {
         *           logError("failed to publish: [%s]", buf);
         *       }

         *        mqtt.loop();
         *        mqtt.disconnect();
        */
        wait(DATA_INTERVAL);

    }
}
