
#include "mbed.h"
#include "mtsas.h"
// #include "PubSubClient.h"

//Phone number to send to and receive from. Must be in the form "1xxxxxxxxxx"
string PHONE_NUMBER = "169524576179";


AnalogIn sensor(PC_2);   //A0 pin on UDK
DigitalIn button(PA_9);     // D5 pin

int main(void)
{
    wait(15);
    printf("Moisture Meter Starting ...\n\r");

    //Sets the log level to INFO, higher log levels produce more log output.
    //Possible levels: NONE, FATAL, ERROR, WARNING, INFO, DEBUG, TRACE
    MTSLog::setLogLevel(MTSLog::TRACE_LEVEL);

    Cellular::Sms txtmsg;
    txtmsg.phoneNumber = PHONE_NUMBER;

    if(PHONE_NUMBER == "CHANGE ME PLEASE") {
        while(1) {
            printf("FORGOT TO SET THE PHONE NUMBER\r\n");
            wait(1.0f);
        }
    }

    /** STMicro Nucelo F411RE
    * The supported jumper configurations of the MTSAS do not line up with
    * the pin mapping of the Nucleo F411RE. Therefore, the MTSAS serial TX
    * pin (JP8 Pin 2) must be manually jumped to Serial1 RX (Shield pin D2)
    * and the MTSAS serial RX pin (JP9 Pin 2) pin must be manually jumped to
    * Serial1 TX (Shield pin D8).
    */

    MTSSerialFlowControl* io = new MTSSerialFlowControl(D8, D2, D3, D6);

    //Sets the baud rate for communicating with the radio
    io->baud(115200);

    //Creates a radio object
    Cellular* radio = CellularFactory::create(io);

    if (! radio) {
        logFatal("Failed to initialize radio");
        return 1;
    }

    printf("ready to wait \r\n");
    wait(2.0f);
    printf("Sensor is ready to read data!!! :-) \r\n");
    float value =0.0f;
    while(1) {

        while(!button) {
            value = sensor;
            printf("Moisture level: %f \n",value);
            wait (3.0f);
        }
        printf("\r\n3\r\n");
        wait(1.0f);
        printf("2\r\n");
        wait(1.0f);
        printf("1\r\n");
        wait(1.0f);
        printf("Measuring!!!!  :-)\r\n\n");
        wait(3.0f);
        value = sensor;

        if (value > .8f) {
            txtmsg.message = "Call a life Gaurd Now! ;-)";
        } else if (value > .6f) {
            txtmsg.message = "Feeling Groovey";
        } else if (value > .4f) {
            txtmsg.message = "I'm Good";
        } else {
            txtmsg.message = "Very Dry";
        }
        printf("%s\n\r", txtmsg.message.c_str());
        printf("Sensor is: %2.2f\r\n\r\n", 100*value);


        // Send SMS message to phone
//        for (int i = 1; i < 10; i++) {
//            if(radio->sendSMS(txtmsg) == MTS_SUCCESS) {
//                logInfo("Sent SMS successfully: <%s>\n", txtmsg.message.c_str());
//               break;
//           } else {
//               logError("Failed to send SMS: <%s>\n", txtmsg.message.c_str());
//            }
    }

}
