#include "mbed.h"
#include "mtsas.h"

AnalogIn sensor(PC_2);     //A0
DigitalIn button(PA_9);    //D5

int main(void)
{

    //Sets the log level to INFO, higher log levels produce more log output.
    //Possible levels: NONE, FATAL, ERROR, WARNING, INFO, DEBUG, TRACE
    MTSLog::setLogLevel(MTSLog::TRACE_LEVEL);

    wait(5);
    printf("Moisture Meter Starting ...\n\r");

    //Modify to match your apn if you are using an HSPA radio with a SIM card
//  const char APN[] = "aer05.aerisapn.net";
//  const char APN[] = "aer.aerisapn.net";

//Phone number to send to and receive from. Must be in the form "1xxxxxxxxxx"
    string PHONE_NUMBER = "FORGOT TO SET THE PHONE NUMBER";           // Need to change the phone number to send a text message

    Cellular::Sms txtmsg;
    txtmsg.phoneNumber = PHONE_NUMBER;
    txtmsg.message = "Hello World! MTSAS is up and running!";

//Program communications between the processor and the cell radio
    MTSSerialFlowControl* io = new MTSSerialFlowControl(RADIO_TX, RADIO_RX, RADIO_RTS, RADIO_CTS);
   //Sets the baud rate for communicating with the radio
    io->baud(115200);
   //Creates a radio object
    Cellular* radio = CellularFactory::create(io);
    if (! radio) {
        logFatal("Failed to initialize radio");
        return 1;
    }
    Transport::setTransport(radio);                 // added lines to set radio apn address

    //Set radio APN
    for (int i = 0; i < 10; i++) {
        if (i >= 10) {
            logError("Failed to set APN\n");
        }
        if (radio->setApn(APN) == MTS_SUCCESS) {
            logInfo("Successfully set APN\n");
            break;
        } else {
            wait(1);
        }
    }

    if(PHONE_NUMBER == "CHANGE ME PLEASE") {
        while(1) {
            printf("FORGOT TO SET THE PHONE NUMBER\r\n");
            wait(1.0f);
        }
    }

    float value = sensor;
    wait(0.1f);

    while(1) {
        printf("\r\n Waiting for button press. \r\n");
        while(!button) {
            //Do Nothing
        }
        printf("3\r\n");
        wait(1.0f);
        printf("2\r\n");
        wait(1.0f);
        printf("1\r\n");
        wait(1.0f);
        printf("  Measuring!! \r\n");
        wait(2);
        value = sensor;
        wait (1);

        if (value > .8f) {
            txtmsg.message = "Call a life Gaurd Now! ;-)";
        } else if (value > .6f) {
            txtmsg.message = "Feeling Groovey";
        } else if (value > .4f) {
            txtmsg.message = "I'm Good";
        } else {
            txtmsg.message = "How Dry I am";
        }
        printf("%s\n\r", txtmsg.message.c_str());
        printf("Sensor is: %2.2f\r\n", value);

        /**************************************
         *  how do we want to send data?
         **************************************/

        // Send SMS message to phone
        for (int i = 1; i < 6; i++) {
            if(radio->sendSMS(txtmsg) == MTS_SUCCESS) {
                logInfo("Sent SMS successfully: <%s>\n", txtmsg.message.c_str());
                break;
            } else {
                logError("Failed to send SMS: <%s>\n", txtmsg.message.c_str());
            }
        }
    }
}


