/*************************************************************************
 * Dragonfly Example program of SMS on Freescale sensor board
 */

#include "mbed.h"
#include "mtsas.h"
#include "MbedJSONValue.h"
#include "HTTPJson.h"
#include <string>
#include "FXAS21002.h"
#include "FXOS8700.h"

// Debug serial port
static Serial debug(USBTX, USBRX);

// MTSSerialFlowControl - serial link between processor and radio
static MTSSerialFlowControl* io;

// Cellular - radio object for cellular operations (SMS, TCP, etc)
Cellular* radio;

// APN associated with SIM card
// this APN should work for the AT&T SIM that came with your Dragonfly
static const std::string apn = "";

// Phone number to send SMS messages to
// just change the x digits - the 1 needs to stay!
static const std::string phone_number = " NEED A NUMBER with a 1";

FXOS8700 accel(D14,D15);
FXOS8700 mag(D14,D15);
FXAS21002 gyro(D14,D15);

// variables for sensor data
char streamAcc[] = "acc_rms";
char streamMag[] = "mag_rms";
char streamGyr[] = "gyr_rms";

// misc variables
static int sms_interval_ms = 60000;
static int read_interval_ms = 5000;
static int print_interval_ms = 1500;
int debug_baud = 115200;

bool radio_ok = false;

/****************************************************************************************************
// function prototypes
 ****************************************************************************************************/
bool init_mtsas();

/****************************************************************************************************
// main
 ****************************************************************************************************/
int main()
{
    mts::MTSLog::setLogLevel(mts::MTSLog::TRACE_LEVEL);
    debug.baud(debug_baud);
    logInfo("starting...");

    /****************************************************************************************************
          Initialize I2C Devices ************
     ****************************************************************************************************/
    accel.accel_config();
    mag.mag_config();
    gyro.gyro_config();

    float accel_data[3];
    //float mag_data[3];
    //float gyro_data[3];

// Initialization Radio Section **********************************************************

    radio_ok = init_mtsas();
    if (! radio_ok)
        logError("MTSAS init failed");
    else
        logInfo("MTSAS is ok");

//End Radio Initialization Section **********************************************************
    float dataX = 0;
    float dataY = 0;
    float dataZ = 1;
    Timer sms_timer;
    sms_timer.start();
    Timer read_timer;
    read_timer.start();         // Timer data is set in the Variable seciton see misc variables    Timer motion_timer;
    Timer print_timer;
    print_timer.start();
    Timer motion_timer;
    motion_timer.start();

    while (true) {
        if (read_timer.read_ms() > read_interval_ms) {

            accel.acquire_accel_data_g(accel_data);
            dataX = accel_data[0];
            dataY = accel_data[1];
            dataZ = accel_data[2];

            read_timer.reset();
        }

        if (print_timer.read_ms() > print_interval_ms) {

            logDebug("SENSOR DATA");
            logDebug("DataZ  %0.3f", dataZ);
            logDebug("DataY  %0.3f", dataY);
            print_timer.reset();
        }

// SMS
        if (sms_timer.read_ms() > sms_interval_ms) {
            sms_timer.reset();
            logInfo("SMS Send Routine");
            printf("  In sms routine \r\n");
            if (radio_ok) {
                MbedJSONValue sms_json;
                string sms_str;

                sms_json["  edge Gravity: "] = dataY;
                sms_json[" level Gravity: "] = dataZ;

                sms_str = "SENSOR DATA:\n";
                sms_str += sms_json.serialize();

                logDebug("sending SMS to %s:\r\n%s", phone_number.c_str(), sms_str.c_str());
                if (dataZ<0.6f) {   //added
                Code ret = radio->sendSMS(phone_number, sms_str);
                if (ret != MTS_SUCCESS)
                    logError("sending SMS failed");
                    }     //added
            }
        }
    }
}

// init functions
bool init_mtsas()
{
    io = new MTSSerialFlowControl(RADIO_TX, RADIO_RX, RADIO_RTS, RADIO_CTS);
    if (! io)
        return false;

    io->baud(115200);
    radio = CellularFactory::create(io);
    if (! radio)
        return false;

    Code ret = radio->setApn(apn);
    if (ret != MTS_SUCCESS)
        return false;

    Transport::setTransport(radio);

    return true;
}
