#include "mbed.h"

DigitalOut TriggerPin(p17);  //Sender signal
DigitalOut EchoPin(p18);     //Motar signal
DigitalIn  Br(p15);
DigitalOut myled(LED1);

Serial pc(USBTX, USBRX);

Timer echo;   //Timer for avlesing av echosignal.

int distance; //variable for lagring og utrening av avstand.
int d;

void triggerfunc();

//Distance (in cm) = (elapsed time * sound velocity (340 m/s)) / 100 / 2 //formel for utregning av avstand, ved bruk av tiden.


int main()
{
    while(1) {
        pc.printf("Tast 1 for a starte avstandsmaling\n\r");
        pc.scanf("%d", &d);
    if(d == 1){
        pc.printf("Triggersignal sendt\n\r");
        triggerfunc();    
        myled = 1;                                  //sender ut et triggersignal.
        }
    while(1) {
        if(EchoPin == 1) { 
            pc.printf("Timer startet\n\r");                               //Starter en timer som er aktiv så lenge EchoPin er høy.
            echo.start();
        } else {
            pc.printf("Timer stoppet\n\r");
            echo.stop();
            distance = (echo.read() * 340) / 100 /2;    //340, er lydens hastighet i m/s. Deler på 100 for å få svaret i cm.
            pc.printf("Malt avstand er: %.2f\n\r", distance);
            echo.reset();   
            break; 
            }                             //we divide distance by 2 because the sensor returns the round trip time, which doubles the distance measurement.
        }
    }
}


/* Sender ut ett trigger signal på 10us */
void triggerfunc()
{
    TriggerPin = 1;
    wait(10u);
    TriggerPin = 0;
}
