#include "mbed.h"
#include "SRF05.h"

#define MAX 30
#define INTERVALL (MAX/10)

SRF05 srf(p17, p18);
DigitalOut TriggerPin(p17);  //Sender signal
DigitalOut myled(LED1);
DigitalIn EchoPin(p18);     //Mottar signal
DigitalIn  Br(p15);
BusOut bar(p21,p22,p23,p24,p25,p26,p27,p28, p29, p30);

Serial pc(USBTX, USBRX);

int valg;
int verdi[11] = {1, 3, 7, 15, 31, 63, 127, 255, 511, 1023}; //Verdier som blir satt til bar ut av hvilken avstand objectet har.

float avstand;
float distance; //variable for lagring og utrening av avstand.


Timer echo;   //Timer for avlesing av echosignal.
//Sender ut ett trigger signal på 10us

void triggerfunc()
{
    TriggerPin = 1;
    wait_us(10);
    TriggerPin = 0;
}
main()
{
    pc.printf("Tast 1 for avstandsmaaling: \n ");
    pc.printf("Tast 2 for bevegelsesmaaling: \n ");
    pc.printf("Tast 3 for hastighetsmaaling: \n ");
    pc.scanf("%d",&valg);

    int meny=valg;


    switch (meny) {
        /* Case 1 måler avstand til objektet i cm. Den blir skrivet ut på terminal og vist på baragraph. 
        float temp på er oprettet for å unngå at srf.read() blir kalt opp to ganger på samme linje. If-testen kontrollerer avstanden 
        gitt i intervallet ut av hvilken verdi i er i for-løkken. Stemmer denne if-testen blir bar satt til verdien fra arrayet verd[] 
        ved bruk av variabele i i for-løkken. */
        case 1:
            while(1) {
                printf("Distance = %.1f\n\r", srf.read());
                for(int i = 0; i < 11; i++) {
                    float temp = srf.read();                                         
                    if (temp < (MAX - INTERVALL*i) && temp > (MAX - INTERVALL*(i+1))) {
                        bar = verdi[i];
                    }
                }
                wait(0.05);
            }
        case 2:
        /* Case 2 er en bevegelses detektor, sensorer kjører først en gang for å senere lagre tiden på i en float variabel
        ved neste runde så blir tiden fra sensoren sammenlignet med float variabelen "tiden". Hvis de er ulike, blir det 
        oppdaget en bevegelse og det printes "Bevegelse" på terminal. */
            float tiden;
            while(1) {
                triggerfunc();
                while(!EchoPin);
                echo.start();
                while(EchoPin);
                echo.stop();
                if(EchoPin==0) {
                    if(tiden==!echo.read_ms()) {
                        pc.printf("Bevegelse \n");
                    }
                    tiden=echo.read_ms();
                    echo.reset();
                    wait(0.01);
                }
            }
        case 3:
        /* Case 3 er en hastighetsmåler. srf.read() blir lagret i 2 float variabler, hastighet1 og hastighet2. 
        En timer blir satt igang for å finne tiden mellom disse avstandene som blir lagret. I float fart så blir 
        hastigheten utregnet ved å finne differansen mellom hastighet1 og hastighet2. og senere dividert på tiden. 
        Dette gir hos hastigheten til objektet. */
            float hastighet1;
            float hastighet2;
            float fart;
            Timer tid1;
            Timer tid2;
            while(1) {
                tid1.start();
                hastighet1=srf.read();
                wait(0.1);
                hastighet2=srf.read();
                tid1.stop();
                fart =( hastighet1-hastighet2 )/tid1.read();
                printf("farten til objektet er : %.2f \n",fart);
                tid1.reset();
            }
    }
}
