#include "mbed.h"
#include "loggforing.h"
#include "string"


/* LocalFileSystem er en local funksjon i mbed, som tilater oss å skrive, lese og åpne en .txt fil.*/
LocalFileSystem local("local");

Serial data(USBTX, USBRX);

int brudd = 1;     //En variable som teller opp antall brudd når systemet er aktivt.

/*Array string printer status etter verdi som blir returnet fra funksjonen i filen "systempaa.cpp"
Elementene 0-7 representerer de samme elementene som i arrayet kr_status[]. Elementene 8-11, representerer begge bryterne i krets 1 til krests 4*/
string kr_verdi[12] = {"krets1 bryter1", "krets1 bryter2", "krets2 bryter1", "krets2 bryter2", "krets3 bryter1", "krets3 bryter2", "krets4 bryter1", "krets4 bryter2", "krets1 begge brytere", "krets2 begge brytere", "krets3 begge brytere", "krets4 begge brytere"};


/*
>>>>>>>>>>>>>>>>>>>>>>>>> Funksjonsprototyper <<<<<<<<<<<<<<<<<<<<<<<<<<<<

Loggfører hvilken krets og til hvilken tid det er et inbrudd.
void logg_inbrudd(int status, float timer);.

Loggfører til hvilken tid systemet blir nullstilt via servicebryter
void logg_servicebryter(float sek);

Loggfører at systemet er blitt nullstilt via bruker.
void logg_brukernullstill(float sek);

Loggfører til hvilken tid systemet blir skrudd av.
void logg_system_av(float timer);

Loggføring hvis det er tastet inn feil passord eller tid utløpt
void logg_feilpass(void);

*/

/* Funksjonen leter etter en fil som heter logg.txt på mbed modulen for å skrive videre på den. Er den ikke å finne blir det oprettet en ny fil.
Hvis det ikke skulle bli oprettet en fil, vil funksjonen skrive en error text på skjermen og avbryte logging. Funksjone får tilsendt 3 variabler som 
forteller hva funksjonen skal loggføre. Status forteller hvilket elemet i arrayet kr_verdi som skal hentes ut og skrives inn. Funksjonen loggfører antall brudd
i totalt i systemet, til hvilken tid bruddet var, og hvilken spenning det var over bryteren ved bruddet. */
void logg_inbrudd(int status, float timer, float volt)
{
    FILE *fp = fopen("/local/logg.txt", "a");                    
    if(fp == NULL) {
        data.printf("ERROR! Loggfil ikke funnet eller apnet!");  
        fclose(fp);                                              
    }
    string temp = kr_verdi[status];
    fprintf(fp, "Brudd %d i %s ved %.2f sekunder.\n", brudd, temp.c_str(), timer);
    fprintf(fp, "Spenning over %s ved brudd var %.6f V\n", temp.c_str(), volt);
    brudd++;
    fclose(fp);
}

/* Funksjonen åpner fila logg.txt, eller oppretter den hvis det ikke finnes en. Det blir loggført at systemet 
er nullstilt via servicebryter og til hvilken tid */
void logg_servicebryter(float sek)
{
    FILE *fp = fopen("/local/logg.txt", "a");
    fprintf(fp, "Alle kretser nullstilt via servicebryter ved %.2f sekunder.\n", sek);
    fclose(fp);
}

/* Loggfører at systemet blir nullstils via brukeren og til hvilken tid. */
void logg_brukernullstill(float sek)
{
    FILE *fp = fopen("/local/logg.txt", "a");
    fprintf(fp, "Alle kretser nulstilt via bruker ved %.2f sekunder.\n", sek);
    fclose(fp);    
}

/* Funksjonen logfører til hvilken tid systemet ble avsluttet. */
void logg_system_av(float timer) 
{
    FILE *fp = fopen("/local/logg.txt", "a");
    fprintf(fp, "System avlsuttet. Alarm aktiv i %.2f\n", timer);
    fclose(fp);
}

/* Hvis det er tastet inn feil passord eller at tiden er utløpt, vil dette loggføres */
void logg_feilpass()
{
    FILE *fp = fopen("/local/logg.txt", "a");
    fprintf(fp, "Alarm aktivert. \nFeil passord eller tid utlopt");
    fclose(fp);
}