
#include "mbed.h"
#include <stdio.h>
#include <errno.h>
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "TextLCD.h"

float anselect;
TextLCD lcd(D8, D9, D4, D5, D6, D7); // rs, e, d4-d7
AnalogIn av_sensor(A1);
AnalogIn av_select(A0);
 
SDBlockDevice blockDevice (D11, D12, D13, D10);  // mosi, miso, sck, cs
// File system declaration
char fsistem[]="fs";
char archivo1[] = "/fs/dato1.txt";
char archivo2[] = "/fs/dato2.txt";
char archivo3[] = "/fs/dato3.txt";
char prueba[] = "/fs/prueba.txt";

const int tmuestra = 1500;           //tamaño de la muestra(tamaño del vector);
float muestra[tmuestra];        //arreglo de la muestra en float;

FATFileSystem   fileSystem(fsistem);
int escribeSD(int n, float grab[]);

void inicio();                  //Abre o da el formato y crea los archiívos "w+"
void grabacion();              //carga datos analogicos en muestra[tmuestra];
void escriteSD(int n, float grab);//n es para seleccionar los archivos
int iterpre();                      //interpreta los botones del shild LCD

int main()
{
        while(1){
        //inicio();
        int n = iterpre();
        int e = 0;
        lcd.locate(9,1);
        lcd.printf("%d",n);
        switch(n)
        {
            
            case 0:
                //lcd.locate(0,0);
                //lcd.printf("esperando... ");
                break;
            case 1:
                //lcd.locate(0,0);
                //lcd.printf(" tomando muestra 1 ");
                //grabacion();
                //lcd.locate(0,0);
                //lcd.printf(" grabando  muestra 1 ");
                //escribeSD(1,muestra);
                //lcd.cls();
                break;
                
            case 2:
                //grabacion();
                //escribeSD(2,muestra);
                break;
            case 3:
                //grabacion();
                //escribeSD(3,muestra);
                break;
            case 4:
                //grabacion();
                //escribeSD(4,muestra);
                break;
        }
    }
}
void grabacion(){
    for (int i = 0; i < tmuestra; i++) {
        muestra[i] = av_sensor.read();
        printf("\r tomando muestra %f... \n ", muestra[i]);
        fflush(stdout);
    }
    return;
}
void inicio(){
    printf("Montanto el sistema de archivos... ");
    fflush(stdout);
    int err = fileSystem.reformat(&blockDevice);                                //formatéa si existe un error
    printf("%s\n", (err ? "Fail :(" : "OK"));
    FILE * f = fopen(archivo1, "w+");
    err = fclose(f);
    FILE * g = fopen(archivo2, "w+");
    err = fclose(g);
    FILE * h = fopen(archivo3, "w+");
    err = fclose(h);
    FILE * i = fopen(prueba, "w+");
    err = fclose(i);
    return;
}
int escribeSD(int n, float grab[]){
    printf("Montanto el sistema de archivos... ");
    fflush(stdout);
    char ubica[]= "";
    
    switch(n)
    {
        case 0:
            //ubica = prueba;
            break;
        case 1:
            strcat(archivo1,ubica);
            break;
        case 2:
            strcat(archivo2,ubica);
            break;
        case 3:
            strcat(archivo3,ubica);
            break;
        case 4:
            strcat(prueba,ubica);
            break;
    }
    int err = fileSystem.mount(&blockDevice);                                   //monta el sistema de archivo                                   
    FILE*   f = fopen(ubica, "r+");                                             //abre la ubicacion
    for (int i = 0; i < tmuestra; i++) {
        printf("\rWriting numbers (%d/%d)... ", i, tmuestra);
        fflush(stdout);
        err = fprintf(f, "%f\n", grab[i]);
        if (err < 0) {
            printf("Fail :(\n");
            error("error: %s (%d)\n", strerror(errno), -errno);
        }
    }
    printf("Seeking file... ");
    fflush(stdout);
    err = fseek(f, 0, SEEK_SET);
    printf("%s\n", (err < 0 ? "Fail :(" : "OK"));
    err = fclose(f);
    
    return 0;
}
int iterpre()
{
    
    
    anselect = av_select.read();
    float r1 = anselect;
    
    int resp = 0;
    int r = r1*100;
    lcd.locate(5,1);
    lcd.printf("___");
    lcd.locate(5,1);
    lcd.printf("%d",r);
    if((r < 9)) {
        resp =  5;
        return resp;
    }
    if((47 < r)&&(r < 49)) {
        resp =  4;
        return resp;
    }
    if((20 < r)&&(r < 24)) {
        resp =  3;
        return resp;
    }
    if((73 < r)&&(r < 76)) {
        resp =  2;
        return resp;
    }
    if((r == 100)) {
        resp =  0;
        return resp;
    }
    if((99 < r)&&(r < 101)) {
        resp =  1;
        return resp;
    }
    return resp;
}