#include "Stepper_motor.h"

Stepper_motor::Stepper_motor(PinName _en,PinName _stepPin,PinName _dirPin,PinName Inter,int _ratio,int _micorstep,int _dir,float _rec):Stepper(_en,_stepPin,_dirPin),InterruptIn(Inter)
{
    ratio = _ratio;
    microstep = _micorstep;
    dir = _dir;
    Ori_rec = _rec;
    pos_dir = 1;
    this->enable();
}

void Stepper_motor::Config(float rec_rate,float rec)
{
    if(rec < 0 && rec != -1)
    {
        rec_rate = 0 - rec_rate;
        rec = 0 - rec;
    }
    long long int frequency = rec_rate * ratio * microstep / Ori_rec;
    if(frequency < 0)
    {
        dir = 1 - pos_dir;
        frequency = 0 - frequency;
    }
    else if(frequency == 0)
    {
        this->disable();
        return;
    }
    else if(frequency > 0)
    {
        dir = pos_dir;
    }
    long long int remain = rec * ratio * microstep / Ori_rec;
    this->enable();
    this->step(dir,frequency,remain);
    
}

int Stepper_motor::getDir()
{
    return this->dir;
}
void Stepper_motor::reConfig(float _rec)
{   
    dir = 1 - dir;
    long long int frequency = 5 * ratio * microstep / Ori_rec;
    long long int remain = _rec * ratio * microstep / Ori_rec;
    this->enable();
    this->step(dir,frequency,remain);
}
void Stepper_motor::set()
{
    this -> Config(0,0);
    wait(0.01);
    this -> enable();
    this -> Config(-5,7);
}
void Stepper_motor::Init()
{
    this->Config(10,-1);
    this->fall(this,&Stepper_motor::set); 
}