#ifndef MYLCD_H
#define MYLCD_H

#include "mbed.h"

class myLCD {
    public:
        myLCD(PinName _DI, PinName _RW, PinName _EN, PinName _CS1, PinName _CS2, BusInOut *BUSLCD);
        void pulse_en();
        void lcd_on();
        void write_byte(unsigned short byte);
        short read_byte(unsigned short col, unsigned short page);
        void set_col(unsigned short col); //0-127 sets col
        void set_row(unsigned short row); //0-7 sets page
        void set_xy(unsigned short col, unsigned short page);
        void clear();
        void draw_point(unsigned short x, unsigned short y, bool color); //true prints white, xy coordinates in 0-127, 0-63
        
    private:
        BusInOut*    LCD_PORT;
        DigitalOut   DI;
        DigitalOut   RW;
        DigitalOut   EN;
        DigitalOut   CS1;
        DigitalOut   CS2;
};
#endif