#include "myLCD.h"
/**
myLCD::myLCD(PinName _DI, PinName _RW, PinName _EN, PinName _CS1, PinName _CS2, BusInOut *BUSLCD){
    DI = new DigitalOut(_DI);
    RW = new DigitalOut(_RW);
    EN = new DigitalOut(_EN);
    CS1 = new DigitalOut(_CS1);
    CS2 = new DigitalOut(_CS2);
    LCD_PORT = BUS_LCD;
    }*/
myLCD::myLCD(PinName _DI, PinName _RW, PinName _EN, PinName _CS1, PinName _CS2, BusInOut *BUSLCD):DI(_DI),RW(_RW),EN(_EN),CS1(_CS1),CS2(_CS2){
    LCD_PORT = BUSLCD;
}
    
void myLCD::pulse_en(){
    EN = 1;
    wait_us(8);
    EN = 0;
    wait_us(8);
}
    
void myLCD::lcd_on(){
    DI = 0;
    RW = 0;
    EN = 0;
    CS1 = 0;
    CS2 = 0;
    LCD_PORT->output();
    wait_us(2);
    LCD_PORT->write(0x3F);
    wait_us(2);
    pulse_en();
}
    
void myLCD::write_byte(unsigned short byte){
    DI = 1; //high -> data
    RW = 0; //low -> write
    LCD_PORT->write(byte);
    wait_us(2);
    pulse_en();
}

//returns the value into @param &byte
short myLCD::read_byte(unsigned short col, unsigned short page){
    unsigned short temp;
    set_xy(col, page); // this function reads data from current location
    LCD_PORT->input(); //set as input
    DI = 1; //high -> data
    RW = 1; //high -> read
    CS1 = (col>63);
    CS2 = !CS1;
    wait_us(1);
    EN = 1;     //latches data into output register
    wait_us(1);
    
    EN = 0;     //dummy read
    wait_us(5); //waits while lcd fetches data
    EN = 1;     //latch data from output register into data register
    wait_us(1);
    
    temp = LCD_PORT->read(); //data is saved onto byte from the caller
    EN = 0; //remove data from the bus
    wait_us(1);
    LCD_PORT->output(); //set bus as output again
    wait_us(2);
    return temp;
}

//@param col should be 0<=col<128
void myLCD::set_col(unsigned short col){
    unsigned short col_data;
    DI = 0; //low -> instruction
    RW = 0; //low -> write
    
    //0-63
    if(col < 64){
        CS1 = 0; //select chip1
        CS2 = 1; //deselect chip2
        col_data = col;
    }
    else //64-127
    {
        CS1 = 1; //deselect chip1
        CS2 = 0; //select chip2
        col_data = col - 64;
    }
    //command formatting 01CCCCC -> C: column
    col_data = (col_data | 0x40) & 0x7F;
    LCD_PORT->write(col_data);
    wait_us(2);
    pulse_en();
}

void myLCD::set_row(unsigned short row){
    unsigned short row_data;
    DI = 0; //low -> instruction
    RW = 0; //low -> write
    //command formatting 10111PPP -> P: page
    row_data = (row | 0xB8) & 0xBF; //or with 10111000, and with 10111111. last 3 bits is the page
    LCD_PORT->write(row_data);
    wait_us(2);
    pulse_en();
}

void myLCD::set_xy(unsigned short col, unsigned short page){
    set_col(col);
    set_row(page);
}

void myLCD::clear(){
    for(short n = 0; n < 8; n++){
        set_xy(0,n);
        set_xy(64,n); //at this point, cs2 is selected
        CS1 = 1; //select cs1 as well
        for(short i = 0; i < 64; i++)
            write_byte(0);
    }
}

//@param color = true, draws white. clears otherwise
void myLCD::draw_point(unsigned short x, unsigned short y, bool color){
    short data;
    short byte = read_byte(x, (y/8)); //byte has the point's 8bit data
    
    if(color){ //paint the point
        data = ~(1 << (y % 8)) & byte;
    }
    else{ //clear the point
        data = (1 << (y % 8)) | byte;
    }
    set_xy(x, y/8);
    write_byte(data);
}