#include "Tank.h"

/**
    constructor
    bool true means corresponding coordinates will be incremented every tick (false = decrement)
*/
Tank::Tank(short pixel, short x, short y, short dir){
    next = 0;
    pxl = pixel;
    this->x = x;
    this->y = y;
    this->dir = dir;
    collided = false;
}

Bullet* Tank::move(){
    Bullet* temp = 0;
    short a = 3;
    short i = rand() % 10;
    if(1 <= i && i <= 4){
        dir = i;
    }
    else if(i == 0 || ((5 <= i) && (i <= 8))){
        if(dir == 1)
            y = y - a;
        else if(dir == 2)
            x = x + a;
        if(dir == 3)
            y = y + a;
        else if(dir == 4)
            x = x - a;
    }
    else{
        temp = fire();
    }
    
    if(x < 0)
        x = 0;
    else if(x > 120)
        x = 120;
    else if(y < 0)
        y = 0;
    else if(y > 56)
        y = 56;
    
        
    return temp;
}

void Tank::changeDirection(short i){
    dir = i;
}

Tank* Tank::getNext(){
    return next;
}

void Tank::setNext(Tank* newNext)
{
    next = newNext;
}

bool Tank::willBeRemoved(){
    return collided;
}

Bullet* Tank::fire(){
    Bullet* bullet;
    if(dir == 1){
        bullet = new Bullet(2, x+3, y-2, dir);
    }
    else if(dir == 2){
        bullet = new Bullet(2, x+8, y+3, dir);
    }
    else if(dir == 3){
        bullet = new Bullet(2, x+3, y+8, dir);
    }
    else if(dir == 4){
        bullet = new Bullet(2, x-2, y+3, dir);
    }
    return bullet;
}

void Tank::getxy(short& xcor, short& ycor){
    xcor = x;
    ycor = y;
}

void Tank::checkBTcollisions(Bullet* listhead){
    Bullet* comp = listhead;
    short xcomp, ycomp;
    
    while(comp != 0){
        comp->getxy(xcomp, ycomp);
        
        if((x - 1 <= xcomp && xcomp <= x + 7) && (y - 1 <= ycomp && ycomp <= y + 7)){
            collided = true;
            comp->setCollision();
        }
        comp = comp->getNext();
    }
}

void Tank::setCollision(){
    collided = true;
}

short Tank::getDir(){
    return dir;
}