#include "Bullet.h"

/**
    constructor
    bool true means corresponding coordinates will be incremented every tick (false = decrement)
*/
Bullet::Bullet(short pixel, short x, short y, short dir){
    next = 0;
    pxl = 3;
    this->x = x;
    this->y = y;
    this->dir = dir;
    collided = false;
}

void Bullet::move(){
    short a = 4;
    if(dir == 1)
        y = y - a;
    else if(dir == 2)
        x = x + a;
    else if(dir == 3)
        y = y + a;
    else if(dir == 4)
        x = x - a;
    
    if(x < 0 || (x + pxl) > 126)
        collided = true;
    else if(y < 0 || (y + pxl) > 62)
        collided = true;
}

Bullet* Bullet::getNext(){
    return next;
}

void Bullet::setNext(Bullet* newNext)
{
    next = newNext;
}

bool Bullet::willBeRemoved(){
    return collided;
}

void Bullet::getxy(short& xcor, short& ycor){
    xcor = x;
    ycor = y;
}

void Bullet::setCollision(){
    collided = true;
}

short Bullet::getDir(){
    return dir;
}