#include "mbed.h"
#include "KS0108.h"    
#include "image.h"
#include "Game.h"

DigitalIn butUp(PTE21);
DigitalIn butRight(PTE20);
DigitalIn butDown(PTE29);
DigitalIn butLeft(PTE22);
DigitalIn butMiddle(PTE23);

KS0108 display (PTC5,PTC7, PTC0, PTC3, PTC11, PTC10, PTA1, PTA2, PTD4, PTA12, PTA4, PTA5, PTC8, PTC9);        
void draw(int type, int posX, int posY, int direction); //1.player 2.bot 3.bullet
void erase(int type, int posX, int posY, int direction);
void drawAll();
void eraseAll();
Game* game;

int main() 
{   
    srand(time(0));
    display.FullScreenBMP(face);
    wait(1);
    display.ClearScreen();  
    
    //my stuff
    game = new Game();
    
    while(1)
    {          
        drawAll();
        wait_ms(40);
        display.ClearScreen();
        //eraseAll();
        if(!butUp)
            game->getPlayer()->move(1);
        else if(!butRight)
            game->getPlayer()->move(2);
        else if(!butDown)
            game->getPlayer()->move(3);
        else if(!butLeft)
            game->getPlayer()->move(4);
        else if(!butMiddle){
            Bullet* temp = game->getPlayer()->fire();
            game->getBullets()->addBullet(2, temp->x, temp->y, temp->dir);
        }
        game->play();
    }
}

void drawAll(){
    //draw player
    draw(1, game->getPlayer()->x, game->getPlayer()->y, game->getPlayer()->dir);
    
    //draw tanks
    Tank* tcur = game->getTanks()->getHead();
        
    while(tcur != 0){
        draw(2, tcur->x, tcur->y, tcur->dir);
        tcur = tcur->getNext();
    }
        
    //draw bullets
    Bullet* bcur = game->getBullets()->getHead();
        
    while(bcur != 0){
        draw(3, bcur->x, bcur->y, bcur->dir);
        bcur = bcur->getNext();
    }
    
    //draw hearts
    unsigned short i = 57;
    for(unsigned short j = game->getPlayer()->getLife(); j > 0; i = i + 5, j--){
        draw(5, i, 0, 0);
    }
    
    if(game->death){
        delete game->bullets;
        delete game->tanks;
        game->bullets = new BulletList();
        game->tanks = new TankList();
        erase(1, game->getPlayer()->x, game->getPlayer()->y, game->getPlayer()->dir);
        draw(4, game->getPlayer()->x, game->getPlayer()->y, 1);
        wait(3);
        game->getPlayer()->x = 0;
        game->getPlayer()->y = 56;
        game->getPlayer()->dir = 2;
        game->death = false;
    }
    
    if(game->player->getLife() == 0){
        display.ClearScreen();
        display.FullScreenBMP(cat);
        while(1);
    }
}

void eraseAll(){
    //display.ClearScreen();
    //draw hearts
    unsigned short i = 57;
    for(unsigned short j = game->getPlayer()->getLife(); j > 0; i = i + 5, j--){
        erase(5, i, 0, 0);
    }
    
    //draw player
    erase(1, game->getPlayer()->x, game->getPlayer()->y, game->getPlayer()->dir);
    
    //draw tanks
    Tank* tcur = game->getTanks()->getHead();
    
    while(tcur != 0){
        erase(2, tcur->x, tcur->y, tcur->dir);
        tcur = tcur->getNext();
    }
    
    //draw bullets
    Bullet* bcur = game->getBullets()->getHead();
    
    while(bcur != 0){
        erase(3, bcur->x, bcur->y, bcur->dir);
        bcur = bcur->getNext();
    }
}

void draw(int type, int posX, int posY, int direction) //1.player 2.bot 3.bullet 4.x 5.heart
{ 
    switch(type)
    {
        case 1:
            switch(direction)
            {
                case 1:
                    display.FullRectangle(posX, posY + 2, posX + 7, posY + 7, BLACK); 
                    display.FullRectangle(posX + 3, posY, posX + 4, posY + 1, BLACK);
                    break;
                case 2:
                    display.FullRectangle(posX, posY, posX + 5, posY + 7, BLACK); 
                    display.FullRectangle(posX + 6, posY + 3, posX + 7, posY + 4, BLACK);
                    break;
                case 3:
                    display.FullRectangle(posX, posY, posX + 7, posY + 5, BLACK); 
                    display.FullRectangle(posX + 3, posY + 6, posX + 4, posY + 7, BLACK);
                    break;
                case 4:
                    display.FullRectangle(posX + 2, posY, posX + 7, posY + 7, BLACK); 
                    display.FullRectangle(posX, posY + 3, posX + 1, posY + 4, BLACK);          
                    break;
                default: break;
            }
            break;
            
        case 2:
            switch(direction)
            {
                case 1:
                    display.FullRectangle(posX, posY + 2, posX + 7, posY + 7, BLACK); 
                    display.FullRectangle(posX + 3, posY, posX + 4, posY + 1, BLACK);
                    display.FullRectangle(posX + 2, posY + 5, posX + 5, posY + 7, WHITE); 
                    break;
                case 2:
                    display.FullRectangle(posX, posY, posX + 5, posY + 7, BLACK); 
                    display.FullRectangle(posX + 6, posY + 3, posX + 7, posY + 4, BLACK);
                    display.FullRectangle(posX, posY + 2, posX + 2, posY + 5, WHITE); 
                    break;
                case 3:
                    display.FullRectangle(posX, posY, posX + 7, posY + 5, BLACK); 
                    display.FullRectangle(posX + 3, posY + 6, posX + 4, posY + 7, BLACK);
                    display.FullRectangle(posX + 2, posY, posX + 5, posY + 2, WHITE);
                    break;
                case 4:
                    display.FullRectangle(posX + 2, posY, posX + 7, posY + 7, BLACK); 
                    display.FullRectangle(posX, posY + 3, posX + 1, posY + 4, BLACK);  
                    display.FullRectangle(posX + 5, posY + 2, posX + 7, posY + 5, WHITE);        
                    break;
                default: break;
            }
            break;
            
        case 3:
            display.FullRectangle(posX, posY, posX + 1, posY + 1, BLACK); 
            break;
            
        case 4:
            display.Line(posX, posY, posX + 7, posY + 7, BLACK);
            display.Line(posX + 7, posY, posX, posY + 7, BLACK);
            break;
            
        case 5:
            //display.DrawBitmap(heart, posX, posY, BLACK);
            display.FullRectangle(posX, posY, posX + 3, posY + 3, BLACK);  
            display.FullRectangle(posX + 1, posY + 1, posX + 2, posY + 2, WHITE);
            break;
        default: break;
    }
}

void erase(int type, int posX, int posY, int direction) //1.player 2.bot 3.bullet 4.x 5.heart
{ 
    switch(type)
    {
        case 1:
            switch(direction)
            {
                case 1:
                    display.FullRectangle(posX, posY + 2, posX + 7, posY + 7, WHITE); 
                    display.FullRectangle(posX + 3, posY, posX + 4, posY + 1, WHITE);
                    break;
                case 2:
                    display.FullRectangle(posX, posY, posX + 5, posY + 7, WHITE); 
                    display.FullRectangle(posX + 6, posY + 3, posX + 7, posY + 4, WHITE);
                    break;
                case 3:
                    display.FullRectangle(posX, posY, posX + 7, posY + 5, WHITE); 
                    display.FullRectangle(posX + 3, posY + 6, posX + 4, posY + 7, WHITE);
                    break;
                case 4:
                    display.FullRectangle(posX + 2, posY, posX + 7, posY + 7, WHITE); 
                    display.FullRectangle(posX, posY + 3, posX + 1, posY + 4, WHITE);          
                    break;
                default: break;
            }
            break;
            
        case 2:
            switch(direction)
            {
                case 1:
                    display.FullRectangle(posX, posY + 2, posX + 7, posY + 7, WHITE); 
                    display.FullRectangle(posX + 3, posY, posX + 4, posY + 1, WHITE);
                    //display.FullRectangle(posX + 2, posY + 5, posX + 5, posY + 7, WHITE); 
                    break;
                case 2:
                    display.FullRectangle(posX, posY, posX + 5, posY + 7, WHITE); 
                    display.FullRectangle(posX + 6, posY + 3, posX + 7, posY + 4, WHITE);
                    //display.FullRectangle(posX, posY + 2, posX + 2, posY + 5, WHITE); 
                    break;
                case 3:
                    display.FullRectangle(posX, posY, posX + 7, posY + 5, WHITE); 
                    display.FullRectangle(posX + 3, posY + 6, posX + 4, posY + 7, WHITE);
                    //display.FullRectangle(posX + 2, posY, posX + 5, posY + 2, WHITE);
                    break;
                case 4:
                    display.FullRectangle(posX + 2, posY, posX + 7, posY + 7, WHITE); 
                    display.FullRectangle(posX, posY + 3, posX + 1, posY + 4, WHITE);  
                    //display.FullRectangle(posX + 5, posY + 2, posX + 7, posY + 5, WHITE);        
                    break;
                default: break;
            }
            break;
            
        case 3:
            display.FullRectangle(posX, posY, posX + 1, posY + 1, WHITE); 
            break;
            
        case 4:
            display.Line(posX, posY, posX + 7, posY + 7, WHITE);
            display.Line(posX + 7, posY, posX, posY + 7, WHITE);
            break;
            
        case 5:
            //display.DrawBitmap(heart, posX, posY, BLACK);
            display.FullRectangle(posX, posY, posX + 3, posY + 3, WHITE);  
            //display.FullRectangle(posX + 1, posY + 1, posX + 2, posY + 2, WHITE);
            break;
        default: break;
    }
}