#include "TankList.h"

TankList::TankList(){
    tankCount = 0;
    head = 0;
}

TankList::~TankList(){
    if (head != 0)
    {
        Tank* prev = head;
        Tank* cur = head;
        while (cur->getNext() != 0)
        {
            cur = cur->getNext();
            delete prev;
            prev = cur;
        }
        delete cur;
    }
}

void TankList::addTank(short pixel, short x, short y, short dir){
    //add to beginning of the list
    if (head != 0)
    {
        Tank* newTank = new Tank(pixel, x, y, dir);
        newTank->setNext(head);
        head = newTank;
        tankCount++;
    }
    // add as the head if the head is empty
    else
    {
        head = new Tank(pixel, x, y, dir);
        tankCount++;
    }
}

void TankList::removeCollisions(){
    Tank* cur = head->getNext();
    Tank* prev = head;
    Tank* temp;
    
    if(head != 0){
        //check excluding head
        while(cur != 0){
            if(cur->willBeRemoved()){
                temp = cur->getNext();
                delete cur;
                cur = 0;
                cur = temp;
                prev->setNext(cur);
            }
            else{
                prev = cur;
                cur = cur->getNext();
            }
        }
        //check head
        if(head->willBeRemoved()){
            temp = head->getNext();
            delete head;
            head = 0;
            head = temp;
        }
    }
}

void TankList::moveAll(BulletList* blist){
    Tank* cur = head;
    Bullet* fired;
    
    while(cur != 0){
        fired = cur->move();
        if(fired != 0)
            blist->addBullet(2, fired->x, fired->y, fired->dir);
        
        cur = cur->getNext();
    }
}

void TankList::checkallBTcollisions(Bullet* listhead){
    Tank* cur = head;
    
    while(cur != 0){
        cur->checkBTcollisions(listhead);
        cur = cur->getNext();
    }
}

Tank* TankList::getHead(){
    return head;
}