#include "Player.h"

/**
    constructor
    bool true means corresponding coordinates will be incremented every tick (false = decrement)
*/
Player::Player(short pixel, short x, short y, short dir){
    pxl = pixel;
    this->x = x;
    this->y = y;
    this->dir = dir;
    collided = false;
    life = 3;
}

void Player::move(short i){
    short a = 3;
    if(i == dir){   
        if(dir == 1)
            y = y - a;
        else if(dir == 2)
            x = x + a;
        else if(dir == 3)
            y = y + a;
        else if(dir == 4)
            x = x - a;
    }
    else
        dir = i;
    
    if(x < 0)
        x = 0;
    else if((x + pxl) > 127)
        x = 120;
    else if(y < 0)
        y = 0;
    else if((y + pxl) > 63)
        y = 56;
}

bool Player::willBeRemoved(){
    return collided;
}

Bullet* Player::fire(){
    Bullet* bullet;
    if(dir == 1){
        bullet = new Bullet(2, x+3, y-2, dir);
    }
    else if(dir == 2){
        bullet = new Bullet(2, x+8, y+3, dir);
    }
    else if(dir == 3){
        bullet = new Bullet(2, x+3, y+8, dir);
    }
    else if(dir == 4){
        bullet = new Bullet(2, x-2, y+3, dir);
    }
    return bullet;
}

void Player::getxy(short& xcor, short& ycor){
    xcor = x;
    ycor = y;
}

bool Player::checkCollisions(Bullet* bulletHead, Tank* tankHead){
    Bullet* bcomp = bulletHead;
    short xcomp, ycomp;
    
    while(bcomp != 0){
        bcomp->getxy(xcomp, ycomp);
        
        if((x - 1 <= xcomp && xcomp <= x + 7) && (y - 1 <= ycomp && ycomp <= y + 7)){
            collided = true;
            bcomp->setCollision();
        }
        bcomp = bcomp->getNext();
    }
    Tank* tcomp = tankHead;
    
    while(tcomp != 0){
        tcomp->getxy(xcomp, ycomp);
        
        if((x - 7 <= xcomp && xcomp <= x + 7) && (y - 7 <= ycomp && ycomp <= y + 7)){
            collided = true;
            tcomp->setCollision();
        }
        tcomp = tcomp->getNext();
    }
    
    if(collided){
        life--;
        collided = false;
        return true;
    }
    return false;
}

short Player::getLife(){
    return life;
}

short Player::getDir(){
    return dir;
}