#include "BulletList.h"

BulletList::BulletList(){
    bulletCount = 0;
    head = 0;
}

BulletList::~BulletList(){
    if (head != 0)
    {
        Bullet* prev = head;
        Bullet* cur = head;
        while (cur->getNext() != 0)
        {
            cur = cur->getNext();
            delete prev;
            prev = cur;
        }
        delete cur;
    }
}

void BulletList::addBullet(short pixel, short x, short y, short dir){
    //add to beginning of the list
    if (head != 0)
    {
        Bullet* newBullet = new Bullet(pixel, x, y, dir);
        newBullet->setNext(head);
        head = newBullet;
        bulletCount++;
    }
    // add as the head if the head is empty
    else
    {
        head = new Bullet(pixel, x, y, dir);
        bulletCount++;
    }
}

void BulletList::removeCollisions(){
    Bullet* cur = head->getNext();
    Bullet* prev = head;
    Bullet* temp;
    
    if(head != 0){
        //check excluding head
        while(cur != 0){
            if(cur->willBeRemoved()){
                temp = cur->getNext();
                delete cur;
                cur = 0;
                cur = temp;
                prev->setNext(cur);
            }
            else{
                prev = cur;
                cur = cur->getNext();
            }
        }
        //check head
        if(head->willBeRemoved()){
            temp = head->getNext();
            delete head;
            head = 0;
            head = temp;
        }
    }
}

void BulletList::moveAll(){
    Bullet* cur = head;
    
    while(cur != 0){
        cur->move();
        cur = cur->getNext();
    }
}

void BulletList::checkBBCollisions(){
    Bullet* cur = head;
    Bullet* comp;
    short xcur, ycur, xcomp, ycomp;
    
    while(cur != 0){
        cur->getxy(xcur, ycur);
        comp = cur->getNext();
        while(comp != 0){
            comp->getxy(xcomp, ycomp);
        
            if((xcur - 2 <= xcomp && xcomp <= xcur + 2) && (ycur - 2 <= ycomp && ycomp <= ycur + 2)){
                cur->setCollision();
                comp->setCollision();
            }
            comp = comp->getNext();
        }
        cur = cur->getNext();
    }
}

Bullet* BulletList::getHead(){
    return head;
}