#include "Game.h"

Game::Game(){
    player = new Player(7, 0, 56, 2);
    bullets = new BulletList();
    tanks = new TankList();
    death = false;
}

void Game::spawnEnemies(){
    short i = 3 - (rand() % 4);
    short x, y;
    player->getxy(x, y);
    switch(i){
        case 0:
            if(!(x < 60 && y < 28) && i == 0){
                if(checkForSpawnCollision(0, 0))
                    tanks->addTank(7, 0, 0, 1 + (rand() % 4));
            }   
            break;
        case 1:
            if(!(x >= 60 && y < 28) && i == 1){
                if(checkForSpawnCollision(120, 0))
                    tanks->addTank(8, 120, 0, 1 + (rand() % 4));
            }
            break;
        case 2:
            if(!(x < 60 && y >= 28) && i == 2){
                if(checkForSpawnCollision(0, 56))
                    tanks->addTank(8, 0, 56, 1 + (rand() % 4));
            }
            break;
        case 3:
            if(!(x >= 60 && y >= 28) && i == 3){
                if(checkForSpawnCollision(120, 56))
                    tanks->addTank(8, 120, 56, 1 + (rand() % 4));
            }
            break;
    }
    
}
//@param x,y are top left coordinates of the spawn location
//@return true if spawnable
bool Game::checkForSpawnCollision(short x, short y){
    Tank* cur = tanks->getHead();
    bool spawn = true;
    short xcur, ycur;
    
    while(cur != 0){
        cur->getxy(xcur, ycur);
        
        if((x - 7 <= xcur && xcur <= x + 7) && (y - 7 <= ycur && ycur <= y + 7)){
            spawn = false;
        }
        cur = cur->getNext();
    }
    return spawn;
}

Player* Game::getPlayer(){
    return player;
}

BulletList* Game::getBullets(){
    return bullets;
}

TankList* Game::getTanks(){
    return tanks;
}

void Game::play(){
    tanks->moveAll(bullets);
    bullets->moveAll();
    bullets->checkBBCollisions();
    tanks->checkallBTcollisions(bullets->getHead());
    if(player->checkCollisions(bullets->getHead(), tanks->getHead())){
        death = true;
    }
    else{
    bullets->removeCollisions();
    tanks->removeCollisions();
    spawnEnemies();
    }
}