#include "../Target.h"

#include "PinNames.h"

#include <stdlib.h>

static PinName pin_map[4][16] = {
        {PA_0, PA_1, PA_2, PA_3, PA_4, PA_5, PA_6, PA_7, PA_8, PA_9, PA_10, PA_11, PA_12, PA_13, PA_14, PA_15},
        {PB_0, PB_1, PB_2, PB_3, PB_4, PB_5, PB_6, PB_7, PB_8, PB_9, PB_10, PB_11, PB_12, PB_13, PB_14, PB_15},
        {PC_0, PC_1, PC_2, PC_3, PC_4, PC_5, PC_6, PC_7, PC_8, PC_9, PC_10, PC_11, PC_12, PC_13, PC_14, PC_15},
        {PD_0, PD_1, PD_2, NC, NC, NC, NC, NC, NC, NC, NC, NC, NC, NC, NC, NC}
    };

// STM Nucleo pins are in the form of <PORT>.<PIN> where PORT = [A-D]
// and PIN = [1-15]. Port D only has 3 pins.
PinName pin_name_from_string(std::string str) {
    if (str.size() < 3)
        return NC;
    unsigned port = str[0];
    port -= 'A';
    if (port > 3)
        return NC;
    if (str[1] != '.')
        return NC;
    unsigned long pin = strtoul(str.data() + 2, NULL, 10);
    if (pin > 15)
        return NC;
    return pin_map[port][pin];
}
