#include "Pin.h"

#include "utils.h"
#include "Targets/Target.h"

Pin::Pin(){
    this->inverting= false;
}

// Make a new pin object from a string
Pin* Pin::from_string(std::string value){
    // Find the end of the pin name.
    std::string::size_type e = value.find_first_of("!o^V-@\n\r\t ");
    name = pin_name_from_string(value.substr(0, e));
    if (name == NC)
    	return this;
    	
    gpio_init(&pin, name, PIN_INPUT);
    
    // The current position in the string
    const char* cn = value.c_str() + e;

    for (;*cn;cn++) {
        switch(*cn) {
            case '!':
                this->inverting = true;
                break;
            case 'o':
                as_open_drain();
                break;
            case '^':
                pull_up();
                break;
            case 'v':
                pull_down();
                break;
            case '-':
                pull_none();
                break;
            case '@':
                as_repeater();
                break;
            default:
                // skip any whitespace following the pin index
                if (!is_whitespace(*cn))
                    return this;
        }
    }

    // from_string failed. TODO: some sort of error
    inverting = false;
    return this;
}

// Configure this pin as OD
Pin* Pin::as_open_drain(){
    if (!connected()) return this;
	gpio_mode(&pin, OpenDrain);
    pull_none(); // no pull up by default
    return this;
}


// Configure this pin as a repeater
Pin* Pin::as_repeater(){
    if (!connected()) return this;
    // ?
    return this;
}

// Configure this pin as no pullup or pulldown
Pin* Pin::pull_none(){
    if (!connected()) return this;
	gpio_mode(&pin, PullNone);
	return this;
}

// Configure this pin as a pullup
Pin* Pin::pull_up(){
    if (!connected()) return this;
	gpio_mode(&pin, PullUp);
    return this;
}

// Configure this pin as a pulldown
Pin* Pin::pull_down(){
    if (!connected()) return this;
	gpio_mode(&pin, PullDown);
    return this;
}
