#ifndef PIN_H
#define PIN_H

#include "mbed.h"

#include <stdlib.h>
#include <stdio.h>
#include <string>

class Pin {
    public:
        Pin();

        Pin* from_string(std::string value);

        inline bool connected(){
            return name != NC;
        }

        inline Pin* as_output(){
            gpio_dir(&pin, PIN_OUTPUT);
            return this;
        }

        inline Pin* as_input(){
            gpio_dir(&pin, PIN_INPUT);
            return this;
        }

        Pin* as_open_drain(void);

        Pin* as_repeater(void);

        Pin* pull_up(void);

        Pin* pull_down(void);

        Pin* pull_none(void);

        inline bool get(){
            return this->inverting ^ gpio_read(&pin);
        }

        inline void set(bool value)
        {
            gpio_write(&pin, value ^ this->inverting);
        }

        PinName name;
        bool inverting;
        gpio_t pin;
};




#endif
