/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K22P121M120SF7RM, Rev. 1, March 24, 2014
**     Version:             rev. 2.5, 2014-05-06
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-07-23)
**         Initial version.
**     - rev. 1.1 (2013-09-17)
**         RM rev. 0.4 update.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-20)
**         Update according to reference manual rev. 0.6,
**     - rev. 2.3 (2014-01-13)
**         Update according to reference manual rev. 0.61,
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK22F51212.h
**     - rev. 2.5 (2014-05-06)
**         Update according to reference manual rev. 1.0,
**         Update of system and startup files.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_SIM_REGISTERS_H__
#define __HW_SIM_REGISTERS_H__

#include "MK22F51212.h"
#include "fsl_bitaccess.h"

/*
 * MK22F51212 SIM
 *
 * System Integration Module
 *
 * Registers defined in this header file:
 * - HW_SIM_SOPT1 - System Options Register 1
 * - HW_SIM_SOPT1CFG - SOPT1 Configuration Register
 * - HW_SIM_SOPT2 - System Options Register 2
 * - HW_SIM_SOPT4 - System Options Register 4
 * - HW_SIM_SOPT5 - System Options Register 5
 * - HW_SIM_SOPT7 - System Options Register 7
 * - HW_SIM_SOPT8 - System Options Register 8
 * - HW_SIM_SDID - System Device Identification Register
 * - HW_SIM_SCGC4 - System Clock Gating Control Register 4
 * - HW_SIM_SCGC5 - System Clock Gating Control Register 5
 * - HW_SIM_SCGC6 - System Clock Gating Control Register 6
 * - HW_SIM_SCGC7 - System Clock Gating Control Register 7
 * - HW_SIM_CLKDIV1 - System Clock Divider Register 1
 * - HW_SIM_CLKDIV2 - System Clock Divider Register 2
 * - HW_SIM_FCFG1 - Flash Configuration Register 1
 * - HW_SIM_FCFG2 - Flash Configuration Register 2
 * - HW_SIM_UIDH - Unique Identification Register High
 * - HW_SIM_UIDMH - Unique Identification Register Mid-High
 * - HW_SIM_UIDML - Unique Identification Register Mid Low
 * - HW_SIM_UIDL - Unique Identification Register Low
 *
 * - hw_sim_t - Struct containing all module registers.
 */

#define HW_SIM_INSTANCE_COUNT (1U) /*!< Number of instances of the SIM module. */

/*******************************************************************************
 * HW_SIM_SOPT1 - System Options Register 1
 ******************************************************************************/

/*!
 * @brief HW_SIM_SOPT1 - System Options Register 1 (RW)
 *
 * Reset value: 0x80000000U
 *
 * The SOPT1 register is only reset on POR or LVD.
 */
typedef union _hw_sim_sopt1
{
    uint32_t U;
    struct _hw_sim_sopt1_bitfields
    {
        uint32_t RESERVED0 : 12;       /*!< [11:0]  */
        uint32_t RAMSIZE : 4;          /*!< [15:12] RAM size */
        uint32_t OSC32KOUT : 2;        /*!< [17:16] 32K Oscillator Clock Output */
        uint32_t OSC32KSEL : 2;        /*!< [19:18] 32K oscillator clock select */
        uint32_t RESERVED1 : 9;        /*!< [28:20]  */
        uint32_t USBVSTBY : 1;         /*!< [29] USB voltage regulator in standby
                                        * mode during VLPR and VLPW modes */
        uint32_t USBSSTBY : 1;         /*!< [30] USB voltage regulator in standby
                                        * mode during Stop, VLPS, LLS and VLLS modes. */
        uint32_t USBREGEN : 1;         /*!< [31] USB voltage regulator enable */
    } B;
} hw_sim_sopt1_t;

/*!
 * @name Constants and macros for entire SIM_SOPT1 register
 */
/*@{*/
#define HW_SIM_SOPT1_ADDR(x)     ((x) + 0x0U)

#define HW_SIM_SOPT1(x)          (*(__IO hw_sim_sopt1_t *) HW_SIM_SOPT1_ADDR(x))
#define HW_SIM_SOPT1_RD(x)       (HW_SIM_SOPT1(x).U)
#define HW_SIM_SOPT1_WR(x, v)    (HW_SIM_SOPT1(x).U = (v))
#define HW_SIM_SOPT1_SET(x, v)   (HW_SIM_SOPT1_WR(x, HW_SIM_SOPT1_RD(x) |  (v)))
#define HW_SIM_SOPT1_CLR(x, v)   (HW_SIM_SOPT1_WR(x, HW_SIM_SOPT1_RD(x) & ~(v)))
#define HW_SIM_SOPT1_TOG(x, v)   (HW_SIM_SOPT1_WR(x, HW_SIM_SOPT1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT1 bitfields
 */

/*!
 * @name Register SIM_SOPT1, field RAMSIZE[15:12] (RO)
 *
 * This field specifies the amount of system RAM available on the device.
 *
 * Values:
 * - 0001 - 8 KB
 * - 0011 - 16 KB
 * - 0100 - 24 KB
 * - 0101 - 32 KB
 * - 0110 - 48 KB
 * - 0111 - 64 KB
 * - 1000 - 96 KB
 * - 1001 - 128 KB
 * - 1011 - 256 KB
 */
/*@{*/
#define BP_SIM_SOPT1_RAMSIZE (12U)         /*!< Bit position for SIM_SOPT1_RAMSIZE. */
#define BM_SIM_SOPT1_RAMSIZE (0x0000F000U) /*!< Bit mask for SIM_SOPT1_RAMSIZE. */
#define BS_SIM_SOPT1_RAMSIZE (4U)          /*!< Bit field size in bits for SIM_SOPT1_RAMSIZE. */

/*! @brief Read current value of the SIM_SOPT1_RAMSIZE field. */
#define BR_SIM_SOPT1_RAMSIZE(x) (HW_SIM_SOPT1(x).B.RAMSIZE)
/*@}*/

/*!
 * @name Register SIM_SOPT1, field OSC32KOUT[17:16] (RW)
 *
 * Outputs the ERCLK32K on the selected pin in all modes of operation (including
 * LLS/VLLS and System Reset), overriding the existing pin mux configuration for
 * that pin. This field is reset only on POR/LVD.
 *
 * Values:
 * - 00 - ERCLK32K is not output.
 * - 01 - ERCLK32K is output on PTE0.
 * - 10 - ERCLK32K is output on PTE26.
 * - 11 - Reserved.
 */
/*@{*/
#define BP_SIM_SOPT1_OSC32KOUT (16U)       /*!< Bit position for SIM_SOPT1_OSC32KOUT. */
#define BM_SIM_SOPT1_OSC32KOUT (0x00030000U) /*!< Bit mask for SIM_SOPT1_OSC32KOUT. */
#define BS_SIM_SOPT1_OSC32KOUT (2U)        /*!< Bit field size in bits for SIM_SOPT1_OSC32KOUT. */

/*! @brief Read current value of the SIM_SOPT1_OSC32KOUT field. */
#define BR_SIM_SOPT1_OSC32KOUT(x) (HW_SIM_SOPT1(x).B.OSC32KOUT)

/*! @brief Format value for bitfield SIM_SOPT1_OSC32KOUT. */
#define BF_SIM_SOPT1_OSC32KOUT(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT1_OSC32KOUT) & BM_SIM_SOPT1_OSC32KOUT)

/*! @brief Set the OSC32KOUT field to a new value. */
#define BW_SIM_SOPT1_OSC32KOUT(x, v) (HW_SIM_SOPT1_WR(x, (HW_SIM_SOPT1_RD(x) & ~BM_SIM_SOPT1_OSC32KOUT) | BF_SIM_SOPT1_OSC32KOUT(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT1, field OSC32KSEL[19:18] (RW)
 *
 * Selects the 32 kHz clock source (ERCLK32K) for LPTMR. This field is reset
 * only on POR/LVD.
 *
 * Values:
 * - 00 - System oscillator (OSC32KCLK)
 * - 01 - Reserved
 * - 10 - RTC 32.768kHz oscillator
 * - 11 - LPO 1 kHz
 */
/*@{*/
#define BP_SIM_SOPT1_OSC32KSEL (18U)       /*!< Bit position for SIM_SOPT1_OSC32KSEL. */
#define BM_SIM_SOPT1_OSC32KSEL (0x000C0000U) /*!< Bit mask for SIM_SOPT1_OSC32KSEL. */
#define BS_SIM_SOPT1_OSC32KSEL (2U)        /*!< Bit field size in bits for SIM_SOPT1_OSC32KSEL. */

/*! @brief Read current value of the SIM_SOPT1_OSC32KSEL field. */
#define BR_SIM_SOPT1_OSC32KSEL(x) (HW_SIM_SOPT1(x).B.OSC32KSEL)

/*! @brief Format value for bitfield SIM_SOPT1_OSC32KSEL. */
#define BF_SIM_SOPT1_OSC32KSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT1_OSC32KSEL) & BM_SIM_SOPT1_OSC32KSEL)

/*! @brief Set the OSC32KSEL field to a new value. */
#define BW_SIM_SOPT1_OSC32KSEL(x, v) (HW_SIM_SOPT1_WR(x, (HW_SIM_SOPT1_RD(x) & ~BM_SIM_SOPT1_OSC32KSEL) | BF_SIM_SOPT1_OSC32KSEL(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT1, field USBVSTBY[29] (RW)
 *
 * Controls whether the USB voltage regulator is placed in standby mode during
 * VLPR and VLPW modes.
 *
 * Values:
 * - 0 - USB voltage regulator not in standby during VLPR and VLPW modes.
 * - 1 - USB voltage regulator in standby during VLPR and VLPW modes.
 */
/*@{*/
#define BP_SIM_SOPT1_USBVSTBY (29U)        /*!< Bit position for SIM_SOPT1_USBVSTBY. */
#define BM_SIM_SOPT1_USBVSTBY (0x20000000U) /*!< Bit mask for SIM_SOPT1_USBVSTBY. */
#define BS_SIM_SOPT1_USBVSTBY (1U)         /*!< Bit field size in bits for SIM_SOPT1_USBVSTBY. */

/*! @brief Read current value of the SIM_SOPT1_USBVSTBY field. */
#define BR_SIM_SOPT1_USBVSTBY(x) (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR(x), BP_SIM_SOPT1_USBVSTBY))

/*! @brief Format value for bitfield SIM_SOPT1_USBVSTBY. */
#define BF_SIM_SOPT1_USBVSTBY(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT1_USBVSTBY) & BM_SIM_SOPT1_USBVSTBY)

/*! @brief Set the USBVSTBY field to a new value. */
#define BW_SIM_SOPT1_USBVSTBY(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR(x), BP_SIM_SOPT1_USBVSTBY) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT1, field USBSSTBY[30] (RW)
 *
 * Controls whether the USB voltage regulator is placed in standby mode during
 * Stop, VLPS, LLS and VLLS modes.
 *
 * Values:
 * - 0 - USB voltage regulator not in standby during Stop, VLPS, LLS and VLLS
 *     modes.
 * - 1 - USB voltage regulator in standby during Stop, VLPS, LLS and VLLS modes.
 */
/*@{*/
#define BP_SIM_SOPT1_USBSSTBY (30U)        /*!< Bit position for SIM_SOPT1_USBSSTBY. */
#define BM_SIM_SOPT1_USBSSTBY (0x40000000U) /*!< Bit mask for SIM_SOPT1_USBSSTBY. */
#define BS_SIM_SOPT1_USBSSTBY (1U)         /*!< Bit field size in bits for SIM_SOPT1_USBSSTBY. */

/*! @brief Read current value of the SIM_SOPT1_USBSSTBY field. */
#define BR_SIM_SOPT1_USBSSTBY(x) (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR(x), BP_SIM_SOPT1_USBSSTBY))

/*! @brief Format value for bitfield SIM_SOPT1_USBSSTBY. */
#define BF_SIM_SOPT1_USBSSTBY(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT1_USBSSTBY) & BM_SIM_SOPT1_USBSSTBY)

/*! @brief Set the USBSSTBY field to a new value. */
#define BW_SIM_SOPT1_USBSSTBY(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR(x), BP_SIM_SOPT1_USBSSTBY) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT1, field USBREGEN[31] (RW)
 *
 * Controls whether the USB voltage regulator is enabled.
 *
 * Values:
 * - 0 - USB voltage regulator is disabled.
 * - 1 - USB voltage regulator is enabled.
 */
/*@{*/
#define BP_SIM_SOPT1_USBREGEN (31U)        /*!< Bit position for SIM_SOPT1_USBREGEN. */
#define BM_SIM_SOPT1_USBREGEN (0x80000000U) /*!< Bit mask for SIM_SOPT1_USBREGEN. */
#define BS_SIM_SOPT1_USBREGEN (1U)         /*!< Bit field size in bits for SIM_SOPT1_USBREGEN. */

/*! @brief Read current value of the SIM_SOPT1_USBREGEN field. */
#define BR_SIM_SOPT1_USBREGEN(x) (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR(x), BP_SIM_SOPT1_USBREGEN))

/*! @brief Format value for bitfield SIM_SOPT1_USBREGEN. */
#define BF_SIM_SOPT1_USBREGEN(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT1_USBREGEN) & BM_SIM_SOPT1_USBREGEN)

/*! @brief Set the USBREGEN field to a new value. */
#define BW_SIM_SOPT1_USBREGEN(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR(x), BP_SIM_SOPT1_USBREGEN) = (v))
/*@}*/

/*******************************************************************************
 * HW_SIM_SOPT1CFG - SOPT1 Configuration Register
 ******************************************************************************/

/*!
 * @brief HW_SIM_SOPT1CFG - SOPT1 Configuration Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The SOPT1CFG register is reset on System Reset not VLLS.
 */
typedef union _hw_sim_sopt1cfg
{
    uint32_t U;
    struct _hw_sim_sopt1cfg_bitfields
    {
        uint32_t RESERVED0 : 24;       /*!< [23:0]  */
        uint32_t URWE : 1;             /*!< [24] USB voltage regulator enable write
                                        * enable */
        uint32_t UVSWE : 1;            /*!< [25] USB voltage regulator VLP standby write
                                        * enable */
        uint32_t USSWE : 1;            /*!< [26] USB voltage regulator stop standby
                                        * write enable */
        uint32_t RESERVED1 : 5;        /*!< [31:27]  */
    } B;
} hw_sim_sopt1cfg_t;

/*!
 * @name Constants and macros for entire SIM_SOPT1CFG register
 */
/*@{*/
#define HW_SIM_SOPT1CFG_ADDR(x)  ((x) + 0x4U)

#define HW_SIM_SOPT1CFG(x)       (*(__IO hw_sim_sopt1cfg_t *) HW_SIM_SOPT1CFG_ADDR(x))
#define HW_SIM_SOPT1CFG_RD(x)    (HW_SIM_SOPT1CFG(x).U)
#define HW_SIM_SOPT1CFG_WR(x, v) (HW_SIM_SOPT1CFG(x).U = (v))
#define HW_SIM_SOPT1CFG_SET(x, v) (HW_SIM_SOPT1CFG_WR(x, HW_SIM_SOPT1CFG_RD(x) |  (v)))
#define HW_SIM_SOPT1CFG_CLR(x, v) (HW_SIM_SOPT1CFG_WR(x, HW_SIM_SOPT1CFG_RD(x) & ~(v)))
#define HW_SIM_SOPT1CFG_TOG(x, v) (HW_SIM_SOPT1CFG_WR(x, HW_SIM_SOPT1CFG_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT1CFG bitfields
 */

/*!
 * @name Register SIM_SOPT1CFG, field URWE[24] (RW)
 *
 * Writing one to the URWE bit allows the SOPT1 USBREGEN bit to be written. This
 * register bit clears after a write to USBREGEN.
 *
 * Values:
 * - 0 - SOPT1 USBREGEN cannot be written.
 * - 1 - SOPT1 USBREGEN can be written.
 */
/*@{*/
#define BP_SIM_SOPT1CFG_URWE (24U)         /*!< Bit position for SIM_SOPT1CFG_URWE. */
#define BM_SIM_SOPT1CFG_URWE (0x01000000U) /*!< Bit mask for SIM_SOPT1CFG_URWE. */
#define BS_SIM_SOPT1CFG_URWE (1U)          /*!< Bit field size in bits for SIM_SOPT1CFG_URWE. */

/*! @brief Read current value of the SIM_SOPT1CFG_URWE field. */
#define BR_SIM_SOPT1CFG_URWE(x) (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR(x), BP_SIM_SOPT1CFG_URWE))

/*! @brief Format value for bitfield SIM_SOPT1CFG_URWE. */
#define BF_SIM_SOPT1CFG_URWE(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT1CFG_URWE) & BM_SIM_SOPT1CFG_URWE)

/*! @brief Set the URWE field to a new value. */
#define BW_SIM_SOPT1CFG_URWE(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR(x), BP_SIM_SOPT1CFG_URWE) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT1CFG, field UVSWE[25] (RW)
 *
 * Writing one to the UVSWE bit allows the SOPT1 USBVSTBY bit to be written.
 * This register bit clears after a write to USBVSTBY.
 *
 * Values:
 * - 0 - SOPT1 USBVSTBY cannot be written.
 * - 1 - SOPT1 USBVSTBY can be written.
 */
/*@{*/
#define BP_SIM_SOPT1CFG_UVSWE (25U)        /*!< Bit position for SIM_SOPT1CFG_UVSWE. */
#define BM_SIM_SOPT1CFG_UVSWE (0x02000000U) /*!< Bit mask for SIM_SOPT1CFG_UVSWE. */
#define BS_SIM_SOPT1CFG_UVSWE (1U)         /*!< Bit field size in bits for SIM_SOPT1CFG_UVSWE. */

/*! @brief Read current value of the SIM_SOPT1CFG_UVSWE field. */
#define BR_SIM_SOPT1CFG_UVSWE(x) (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR(x), BP_SIM_SOPT1CFG_UVSWE))

/*! @brief Format value for bitfield SIM_SOPT1CFG_UVSWE. */
#define BF_SIM_SOPT1CFG_UVSWE(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT1CFG_UVSWE) & BM_SIM_SOPT1CFG_UVSWE)

/*! @brief Set the UVSWE field to a new value. */
#define BW_SIM_SOPT1CFG_UVSWE(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR(x), BP_SIM_SOPT1CFG_UVSWE) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT1CFG, field USSWE[26] (RW)
 *
 * Writing one to the USSWE bit allows the SOPT1 USBSSTBY bit to be written.
 * This register bit clears after a write to USBSSTBY.
 *
 * Values:
 * - 0 - SOPT1 USBSSTBY cannot be written.
 * - 1 - SOPT1 USBSSTBY can be written.
 */
/*@{*/
#define BP_SIM_SOPT1CFG_USSWE (26U)        /*!< Bit position for SIM_SOPT1CFG_USSWE. */
#define BM_SIM_SOPT1CFG_USSWE (0x04000000U) /*!< Bit mask for SIM_SOPT1CFG_USSWE. */
#define BS_SIM_SOPT1CFG_USSWE (1U)         /*!< Bit field size in bits for SIM_SOPT1CFG_USSWE. */

/*! @brief Read current value of the SIM_SOPT1CFG_USSWE field. */
#define BR_SIM_SOPT1CFG_USSWE(x) (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR(x), BP_SIM_SOPT1CFG_USSWE))

/*! @brief Format value for bitfield SIM_SOPT1CFG_USSWE. */
#define BF_SIM_SOPT1CFG_USSWE(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT1CFG_USSWE) & BM_SIM_SOPT1CFG_USSWE)

/*! @brief Set the USSWE field to a new value. */
#define BW_SIM_SOPT1CFG_USSWE(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR(x), BP_SIM_SOPT1CFG_USSWE) = (v))
/*@}*/

/*******************************************************************************
 * HW_SIM_SOPT2 - System Options Register 2
 ******************************************************************************/

/*!
 * @brief HW_SIM_SOPT2 - System Options Register 2 (RW)
 *
 * Reset value: 0x00001000U
 *
 * SOPT2 contains the controls for selecting many of the module clock source
 * options on this device. See the Clock Distribution chapter for more information
 * including clocking diagrams and definitions of device clocks.
 */
typedef union _hw_sim_sopt2
{
    uint32_t U;
    struct _hw_sim_sopt2_bitfields
    {
        uint32_t RESERVED0 : 4;        /*!< [3:0]  */
        uint32_t RTCCLKOUTSEL : 1;     /*!< [4] RTC clock out select */
        uint32_t CLKOUTSEL : 3;        /*!< [7:5] CLKOUT select */
        uint32_t FBSL : 2;             /*!< [9:8] FlexBus security level */
        uint32_t RESERVED1 : 2;        /*!< [11:10]  */
        uint32_t TRACECLKSEL : 1;      /*!< [12] Debug trace clock select */
        uint32_t RESERVED2 : 3;        /*!< [15:13]  */
        uint32_t PLLFLLSEL : 2;        /*!< [17:16] PLL/FLL clock select */
        uint32_t USBSRC : 1;           /*!< [18] USB clock source select */
        uint32_t RESERVED3 : 7;        /*!< [25:19]  */
        uint32_t LPUARTSRC : 2;        /*!< [27:26] LPUART clock source select */
        uint32_t RESERVED4 : 4;        /*!< [31:28]  */
    } B;
} hw_sim_sopt2_t;

/*!
 * @name Constants and macros for entire SIM_SOPT2 register
 */
/*@{*/
#define HW_SIM_SOPT2_ADDR(x)     ((x) + 0x1004U)

#define HW_SIM_SOPT2(x)          (*(__IO hw_sim_sopt2_t *) HW_SIM_SOPT2_ADDR(x))
#define HW_SIM_SOPT2_RD(x)       (HW_SIM_SOPT2(x).U)
#define HW_SIM_SOPT2_WR(x, v)    (HW_SIM_SOPT2(x).U = (v))
#define HW_SIM_SOPT2_SET(x, v)   (HW_SIM_SOPT2_WR(x, HW_SIM_SOPT2_RD(x) |  (v)))
#define HW_SIM_SOPT2_CLR(x, v)   (HW_SIM_SOPT2_WR(x, HW_SIM_SOPT2_RD(x) & ~(v)))
#define HW_SIM_SOPT2_TOG(x, v)   (HW_SIM_SOPT2_WR(x, HW_SIM_SOPT2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT2 bitfields
 */

/*!
 * @name Register SIM_SOPT2, field RTCCLKOUTSEL[4] (RW)
 *
 * Selects either the RTC 1 Hz clock or the 32.768kHz clock to be output on the
 * RTC_CLKOUT pin.
 *
 * Values:
 * - 0 - RTC 1 Hz clock is output on the RTC_CLKOUT pin.
 * - 1 - RTC 32.768kHz clock is output on the RTC_CLKOUT pin.
 */
/*@{*/
#define BP_SIM_SOPT2_RTCCLKOUTSEL (4U)     /*!< Bit position for SIM_SOPT2_RTCCLKOUTSEL. */
#define BM_SIM_SOPT2_RTCCLKOUTSEL (0x00000010U) /*!< Bit mask for SIM_SOPT2_RTCCLKOUTSEL. */
#define BS_SIM_SOPT2_RTCCLKOUTSEL (1U)     /*!< Bit field size in bits for SIM_SOPT2_RTCCLKOUTSEL. */

/*! @brief Read current value of the SIM_SOPT2_RTCCLKOUTSEL field. */
#define BR_SIM_SOPT2_RTCCLKOUTSEL(x) (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR(x), BP_SIM_SOPT2_RTCCLKOUTSEL))

/*! @brief Format value for bitfield SIM_SOPT2_RTCCLKOUTSEL. */
#define BF_SIM_SOPT2_RTCCLKOUTSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT2_RTCCLKOUTSEL) & BM_SIM_SOPT2_RTCCLKOUTSEL)

/*! @brief Set the RTCCLKOUTSEL field to a new value. */
#define BW_SIM_SOPT2_RTCCLKOUTSEL(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR(x), BP_SIM_SOPT2_RTCCLKOUTSEL) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field CLKOUTSEL[7:5] (RW)
 *
 * Selects the clock to output on the CLKOUT pin.
 *
 * Values:
 * - 000 - FlexBus CLKOUT
 * - 001 - Reserved
 * - 010 - Flash clock
 * - 011 - LPO clock (1 kHz)
 * - 100 - MCGIRCLK
 * - 101 - RTC 32.768kHz clock
 * - 110 - OSCERCLK0
 * - 111 - IRC 48 MHz clock
 */
/*@{*/
#define BP_SIM_SOPT2_CLKOUTSEL (5U)        /*!< Bit position for SIM_SOPT2_CLKOUTSEL. */
#define BM_SIM_SOPT2_CLKOUTSEL (0x000000E0U) /*!< Bit mask for SIM_SOPT2_CLKOUTSEL. */
#define BS_SIM_SOPT2_CLKOUTSEL (3U)        /*!< Bit field size in bits for SIM_SOPT2_CLKOUTSEL. */

/*! @brief Read current value of the SIM_SOPT2_CLKOUTSEL field. */
#define BR_SIM_SOPT2_CLKOUTSEL(x) (HW_SIM_SOPT2(x).B.CLKOUTSEL)

/*! @brief Format value for bitfield SIM_SOPT2_CLKOUTSEL. */
#define BF_SIM_SOPT2_CLKOUTSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT2_CLKOUTSEL) & BM_SIM_SOPT2_CLKOUTSEL)

/*! @brief Set the CLKOUTSEL field to a new value. */
#define BW_SIM_SOPT2_CLKOUTSEL(x, v) (HW_SIM_SOPT2_WR(x, (HW_SIM_SOPT2_RD(x) & ~BM_SIM_SOPT2_CLKOUTSEL) | BF_SIM_SOPT2_CLKOUTSEL(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field FBSL[9:8] (RW)
 *
 * If flash security is enabled, then this field affects what CPU operations can
 * access off-chip via the FlexBus interface. This field has no effect if flash
 * security is not enabled.
 *
 * Values:
 * - 00 - All off-chip accesses (instruction and data) via the FlexBus are
 *     disallowed.
 * - 01 - All off-chip accesses (instruction and data) via the FlexBus are
 *     disallowed.
 * - 10 - Off-chip instruction accesses are disallowed. Data accesses are
 *     allowed.
 * - 11 - Off-chip instruction accesses and data accesses are allowed.
 */
/*@{*/
#define BP_SIM_SOPT2_FBSL    (8U)          /*!< Bit position for SIM_SOPT2_FBSL. */
#define BM_SIM_SOPT2_FBSL    (0x00000300U) /*!< Bit mask for SIM_SOPT2_FBSL. */
#define BS_SIM_SOPT2_FBSL    (2U)          /*!< Bit field size in bits for SIM_SOPT2_FBSL. */

/*! @brief Read current value of the SIM_SOPT2_FBSL field. */
#define BR_SIM_SOPT2_FBSL(x) (HW_SIM_SOPT2(x).B.FBSL)

/*! @brief Format value for bitfield SIM_SOPT2_FBSL. */
#define BF_SIM_SOPT2_FBSL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT2_FBSL) & BM_SIM_SOPT2_FBSL)

/*! @brief Set the FBSL field to a new value. */
#define BW_SIM_SOPT2_FBSL(x, v) (HW_SIM_SOPT2_WR(x, (HW_SIM_SOPT2_RD(x) & ~BM_SIM_SOPT2_FBSL) | BF_SIM_SOPT2_FBSL(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field TRACECLKSEL[12] (RW)
 *
 * Selects the core/system clock or MCG output clock (MCGOUTCLK) as the trace
 * clock source.
 *
 * Values:
 * - 0 - MCGOUTCLK
 * - 1 - Core/system clock
 */
/*@{*/
#define BP_SIM_SOPT2_TRACECLKSEL (12U)     /*!< Bit position for SIM_SOPT2_TRACECLKSEL. */
#define BM_SIM_SOPT2_TRACECLKSEL (0x00001000U) /*!< Bit mask for SIM_SOPT2_TRACECLKSEL. */
#define BS_SIM_SOPT2_TRACECLKSEL (1U)      /*!< Bit field size in bits for SIM_SOPT2_TRACECLKSEL. */

/*! @brief Read current value of the SIM_SOPT2_TRACECLKSEL field. */
#define BR_SIM_SOPT2_TRACECLKSEL(x) (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR(x), BP_SIM_SOPT2_TRACECLKSEL))

/*! @brief Format value for bitfield SIM_SOPT2_TRACECLKSEL. */
#define BF_SIM_SOPT2_TRACECLKSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT2_TRACECLKSEL) & BM_SIM_SOPT2_TRACECLKSEL)

/*! @brief Set the TRACECLKSEL field to a new value. */
#define BW_SIM_SOPT2_TRACECLKSEL(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR(x), BP_SIM_SOPT2_TRACECLKSEL) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field PLLFLLSEL[17:16] (RW)
 *
 * Selects the high frequency clock for various peripheral clocking options.
 *
 * Values:
 * - 00 - MCGFLLCLK clock
 * - 01 - MCGPLLCLK clock
 * - 10 - Reserved
 * - 11 - IRC48 MHz clock
 */
/*@{*/
#define BP_SIM_SOPT2_PLLFLLSEL (16U)       /*!< Bit position for SIM_SOPT2_PLLFLLSEL. */
#define BM_SIM_SOPT2_PLLFLLSEL (0x00030000U) /*!< Bit mask for SIM_SOPT2_PLLFLLSEL. */
#define BS_SIM_SOPT2_PLLFLLSEL (2U)        /*!< Bit field size in bits for SIM_SOPT2_PLLFLLSEL. */

/*! @brief Read current value of the SIM_SOPT2_PLLFLLSEL field. */
#define BR_SIM_SOPT2_PLLFLLSEL(x) (HW_SIM_SOPT2(x).B.PLLFLLSEL)

/*! @brief Format value for bitfield SIM_SOPT2_PLLFLLSEL. */
#define BF_SIM_SOPT2_PLLFLLSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT2_PLLFLLSEL) & BM_SIM_SOPT2_PLLFLLSEL)

/*! @brief Set the PLLFLLSEL field to a new value. */
#define BW_SIM_SOPT2_PLLFLLSEL(x, v) (HW_SIM_SOPT2_WR(x, (HW_SIM_SOPT2_RD(x) & ~BM_SIM_SOPT2_PLLFLLSEL) | BF_SIM_SOPT2_PLLFLLSEL(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field USBSRC[18] (RW)
 *
 * Selects the clock source for the USB 48 MHz clock.
 *
 * Values:
 * - 0 - External bypass clock (USB_CLKIN).
 * - 1 - MCGFLLCLK , or MCGPLLCLK , or IRC48M clock as selected by
 *     SOPT2[PLLFLLSEL], and then divided by the USB fractional divider as configured by
 *     SIM_CLKDIV2[USBFRAC, USBDIV].
 */
/*@{*/
#define BP_SIM_SOPT2_USBSRC  (18U)         /*!< Bit position for SIM_SOPT2_USBSRC. */
#define BM_SIM_SOPT2_USBSRC  (0x00040000U) /*!< Bit mask for SIM_SOPT2_USBSRC. */
#define BS_SIM_SOPT2_USBSRC  (1U)          /*!< Bit field size in bits for SIM_SOPT2_USBSRC. */

/*! @brief Read current value of the SIM_SOPT2_USBSRC field. */
#define BR_SIM_SOPT2_USBSRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR(x), BP_SIM_SOPT2_USBSRC))

/*! @brief Format value for bitfield SIM_SOPT2_USBSRC. */
#define BF_SIM_SOPT2_USBSRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT2_USBSRC) & BM_SIM_SOPT2_USBSRC)

/*! @brief Set the USBSRC field to a new value. */
#define BW_SIM_SOPT2_USBSRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR(x), BP_SIM_SOPT2_USBSRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT2, field LPUARTSRC[27:26] (RW)
 *
 * Selects the clock source for the LPUART transmit and receive clock.
 *
 * Values:
 * - 00 - Clock disabled
 * - 01 - MCGFLLCLK , or MCGPLLCLK , or IRC48M clock as selected by
 *     SOPT2[PLLFLLSEL].
 * - 10 - OSCERCLK clock
 * - 11 - MCGIRCLK clock
 */
/*@{*/
#define BP_SIM_SOPT2_LPUARTSRC (26U)       /*!< Bit position for SIM_SOPT2_LPUARTSRC. */
#define BM_SIM_SOPT2_LPUARTSRC (0x0C000000U) /*!< Bit mask for SIM_SOPT2_LPUARTSRC. */
#define BS_SIM_SOPT2_LPUARTSRC (2U)        /*!< Bit field size in bits for SIM_SOPT2_LPUARTSRC. */

/*! @brief Read current value of the SIM_SOPT2_LPUARTSRC field. */
#define BR_SIM_SOPT2_LPUARTSRC(x) (HW_SIM_SOPT2(x).B.LPUARTSRC)

/*! @brief Format value for bitfield SIM_SOPT2_LPUARTSRC. */
#define BF_SIM_SOPT2_LPUARTSRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT2_LPUARTSRC) & BM_SIM_SOPT2_LPUARTSRC)

/*! @brief Set the LPUARTSRC field to a new value. */
#define BW_SIM_SOPT2_LPUARTSRC(x, v) (HW_SIM_SOPT2_WR(x, (HW_SIM_SOPT2_RD(x) & ~BM_SIM_SOPT2_LPUARTSRC) | BF_SIM_SOPT2_LPUARTSRC(v)))
/*@}*/

/*******************************************************************************
 * HW_SIM_SOPT4 - System Options Register 4
 ******************************************************************************/

/*!
 * @brief HW_SIM_SOPT4 - System Options Register 4 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_sopt4
{
    uint32_t U;
    struct _hw_sim_sopt4_bitfields
    {
        uint32_t FTM0FLT0 : 1;         /*!< [0] FTM0 Fault 0 Select */
        uint32_t FTM0FLT1 : 1;         /*!< [1] FTM0 Fault 1 Select */
        uint32_t RESERVED0 : 2;        /*!< [3:2]  */
        uint32_t FTM1FLT0 : 1;         /*!< [4] FTM1 Fault 0 Select */
        uint32_t RESERVED1 : 3;        /*!< [7:5]  */
        uint32_t FTM2FLT0 : 1;         /*!< [8] FTM2 Fault 0 Select */
        uint32_t RESERVED2 : 3;        /*!< [11:9]  */
        uint32_t FTM3FLT0 : 1;         /*!< [12] FTM3 Fault 0 Select */
        uint32_t RESERVED3 : 5;        /*!< [17:13]  */
        uint32_t FTM1CH0SRC : 2;       /*!< [19:18] FTM1 channel 0 input capture
                                        * source select */
        uint32_t FTM2CH0SRC : 2;       /*!< [21:20] FTM2 channel 0 input capture
                                        * source select */
        uint32_t FTM2CH1SRC : 1;       /*!< [22] FTM2 channel 1 input capture
                                        * source select */
        uint32_t RESERVED4 : 1;        /*!< [23]  */
        uint32_t FTM0CLKSEL : 1;       /*!< [24] FlexTimer 0 External Clock Pin
                                        * Select */
        uint32_t FTM1CLKSEL : 1;       /*!< [25] FTM1 External Clock Pin Select */
        uint32_t FTM2CLKSEL : 1;       /*!< [26] FlexTimer 2 External Clock Pin
                                        * Select */
        uint32_t FTM3CLKSEL : 1;       /*!< [27] FlexTimer 3 External Clock Pin
                                        * Select */
        uint32_t FTM0TRG0SRC : 1;      /*!< [28] FlexTimer 0 Hardware Trigger 0
                                        * Source Select */
        uint32_t FTM0TRG1SRC : 1;      /*!< [29] FlexTimer 0 Hardware Trigger 1
                                        * Source Select */
        uint32_t FTM3TRG0SRC : 1;      /*!< [30] FlexTimer 3 Hardware Trigger 0
                                        * Source Select */
        uint32_t FTM3TRG1SRC : 1;      /*!< [31] FlexTimer 3 Hardware Trigger 1
                                        * Source Select */
    } B;
} hw_sim_sopt4_t;

/*!
 * @name Constants and macros for entire SIM_SOPT4 register
 */
/*@{*/
#define HW_SIM_SOPT4_ADDR(x)     ((x) + 0x100CU)

#define HW_SIM_SOPT4(x)          (*(__IO hw_sim_sopt4_t *) HW_SIM_SOPT4_ADDR(x))
#define HW_SIM_SOPT4_RD(x)       (HW_SIM_SOPT4(x).U)
#define HW_SIM_SOPT4_WR(x, v)    (HW_SIM_SOPT4(x).U = (v))
#define HW_SIM_SOPT4_SET(x, v)   (HW_SIM_SOPT4_WR(x, HW_SIM_SOPT4_RD(x) |  (v)))
#define HW_SIM_SOPT4_CLR(x, v)   (HW_SIM_SOPT4_WR(x, HW_SIM_SOPT4_RD(x) & ~(v)))
#define HW_SIM_SOPT4_TOG(x, v)   (HW_SIM_SOPT4_WR(x, HW_SIM_SOPT4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT4 bitfields
 */

/*!
 * @name Register SIM_SOPT4, field FTM0FLT0[0] (RW)
 *
 * Selects the source of FTM0 fault 0. The pin source for fault 0 must be
 * configured for the FTM module fault function through the appropriate pin control
 * register in the port control module.
 *
 * Values:
 * - 0 - FTM0_FLT0 pin
 * - 1 - CMP0 out
 */
/*@{*/
#define BP_SIM_SOPT4_FTM0FLT0 (0U)         /*!< Bit position for SIM_SOPT4_FTM0FLT0. */
#define BM_SIM_SOPT4_FTM0FLT0 (0x00000001U) /*!< Bit mask for SIM_SOPT4_FTM0FLT0. */
#define BS_SIM_SOPT4_FTM0FLT0 (1U)         /*!< Bit field size in bits for SIM_SOPT4_FTM0FLT0. */

/*! @brief Read current value of the SIM_SOPT4_FTM0FLT0 field. */
#define BR_SIM_SOPT4_FTM0FLT0(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM0FLT0))

/*! @brief Format value for bitfield SIM_SOPT4_FTM0FLT0. */
#define BF_SIM_SOPT4_FTM0FLT0(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM0FLT0) & BM_SIM_SOPT4_FTM0FLT0)

/*! @brief Set the FTM0FLT0 field to a new value. */
#define BW_SIM_SOPT4_FTM0FLT0(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM0FLT0) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM0FLT1[1] (RW)
 *
 * Selects the source of FTM0 fault 1. The pin source for fault 1 must be
 * configured for the FTM module fault function through the appropriate pin control
 * register in the port control module.
 *
 * Values:
 * - 0 - FTM0_FLT1 pin
 * - 1 - CMP1 out
 */
/*@{*/
#define BP_SIM_SOPT4_FTM0FLT1 (1U)         /*!< Bit position for SIM_SOPT4_FTM0FLT1. */
#define BM_SIM_SOPT4_FTM0FLT1 (0x00000002U) /*!< Bit mask for SIM_SOPT4_FTM0FLT1. */
#define BS_SIM_SOPT4_FTM0FLT1 (1U)         /*!< Bit field size in bits for SIM_SOPT4_FTM0FLT1. */

/*! @brief Read current value of the SIM_SOPT4_FTM0FLT1 field. */
#define BR_SIM_SOPT4_FTM0FLT1(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM0FLT1))

/*! @brief Format value for bitfield SIM_SOPT4_FTM0FLT1. */
#define BF_SIM_SOPT4_FTM0FLT1(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM0FLT1) & BM_SIM_SOPT4_FTM0FLT1)

/*! @brief Set the FTM0FLT1 field to a new value. */
#define BW_SIM_SOPT4_FTM0FLT1(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM0FLT1) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM1FLT0[4] (RW)
 *
 * Selects the source of FTM1 fault 0. The pin source for fault 0 must be
 * configured for the FTM module fault function through the appropriate pin control
 * register in the port control module.
 *
 * Values:
 * - 0 - FTM1_FLT0 pin
 * - 1 - CMP0 out
 */
/*@{*/
#define BP_SIM_SOPT4_FTM1FLT0 (4U)         /*!< Bit position for SIM_SOPT4_FTM1FLT0. */
#define BM_SIM_SOPT4_FTM1FLT0 (0x00000010U) /*!< Bit mask for SIM_SOPT4_FTM1FLT0. */
#define BS_SIM_SOPT4_FTM1FLT0 (1U)         /*!< Bit field size in bits for SIM_SOPT4_FTM1FLT0. */

/*! @brief Read current value of the SIM_SOPT4_FTM1FLT0 field. */
#define BR_SIM_SOPT4_FTM1FLT0(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM1FLT0))

/*! @brief Format value for bitfield SIM_SOPT4_FTM1FLT0. */
#define BF_SIM_SOPT4_FTM1FLT0(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM1FLT0) & BM_SIM_SOPT4_FTM1FLT0)

/*! @brief Set the FTM1FLT0 field to a new value. */
#define BW_SIM_SOPT4_FTM1FLT0(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM1FLT0) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM2FLT0[8] (RW)
 *
 * Selects the source of FTM2 fault 0. The pin source for fault 0 must be
 * configured for the FTM module fault function through the appropriate PORTx pin
 * control register.
 *
 * Values:
 * - 0 - FTM2_FLT0 pin
 * - 1 - CMP0 out
 */
/*@{*/
#define BP_SIM_SOPT4_FTM2FLT0 (8U)         /*!< Bit position for SIM_SOPT4_FTM2FLT0. */
#define BM_SIM_SOPT4_FTM2FLT0 (0x00000100U) /*!< Bit mask for SIM_SOPT4_FTM2FLT0. */
#define BS_SIM_SOPT4_FTM2FLT0 (1U)         /*!< Bit field size in bits for SIM_SOPT4_FTM2FLT0. */

/*! @brief Read current value of the SIM_SOPT4_FTM2FLT0 field. */
#define BR_SIM_SOPT4_FTM2FLT0(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM2FLT0))

/*! @brief Format value for bitfield SIM_SOPT4_FTM2FLT0. */
#define BF_SIM_SOPT4_FTM2FLT0(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM2FLT0) & BM_SIM_SOPT4_FTM2FLT0)

/*! @brief Set the FTM2FLT0 field to a new value. */
#define BW_SIM_SOPT4_FTM2FLT0(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM2FLT0) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM3FLT0[12] (RW)
 *
 * Selects the source of FTM3 fault 0. The pin source for fault 0 must be
 * configured for the FTM module fault function through the appropriate PORTx pin
 * control register.
 *
 * Values:
 * - 0 - FTM3_FLT0 pin
 * - 1 - CMP0 out
 */
/*@{*/
#define BP_SIM_SOPT4_FTM3FLT0 (12U)        /*!< Bit position for SIM_SOPT4_FTM3FLT0. */
#define BM_SIM_SOPT4_FTM3FLT0 (0x00001000U) /*!< Bit mask for SIM_SOPT4_FTM3FLT0. */
#define BS_SIM_SOPT4_FTM3FLT0 (1U)         /*!< Bit field size in bits for SIM_SOPT4_FTM3FLT0. */

/*! @brief Read current value of the SIM_SOPT4_FTM3FLT0 field. */
#define BR_SIM_SOPT4_FTM3FLT0(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM3FLT0))

/*! @brief Format value for bitfield SIM_SOPT4_FTM3FLT0. */
#define BF_SIM_SOPT4_FTM3FLT0(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM3FLT0) & BM_SIM_SOPT4_FTM3FLT0)

/*! @brief Set the FTM3FLT0 field to a new value. */
#define BW_SIM_SOPT4_FTM3FLT0(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM3FLT0) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM1CH0SRC[19:18] (RW)
 *
 * Selects the source for FTM1 channel 0 input capture. When the FTM is not in
 * input capture mode, clear this field.
 *
 * Values:
 * - 00 - FTM1_CH0 signal
 * - 01 - CMP0 output
 * - 10 - CMP1 output
 * - 11 - USB start of frame pulse
 */
/*@{*/
#define BP_SIM_SOPT4_FTM1CH0SRC (18U)      /*!< Bit position for SIM_SOPT4_FTM1CH0SRC. */
#define BM_SIM_SOPT4_FTM1CH0SRC (0x000C0000U) /*!< Bit mask for SIM_SOPT4_FTM1CH0SRC. */
#define BS_SIM_SOPT4_FTM1CH0SRC (2U)       /*!< Bit field size in bits for SIM_SOPT4_FTM1CH0SRC. */

/*! @brief Read current value of the SIM_SOPT4_FTM1CH0SRC field. */
#define BR_SIM_SOPT4_FTM1CH0SRC(x) (HW_SIM_SOPT4(x).B.FTM1CH0SRC)

/*! @brief Format value for bitfield SIM_SOPT4_FTM1CH0SRC. */
#define BF_SIM_SOPT4_FTM1CH0SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM1CH0SRC) & BM_SIM_SOPT4_FTM1CH0SRC)

/*! @brief Set the FTM1CH0SRC field to a new value. */
#define BW_SIM_SOPT4_FTM1CH0SRC(x, v) (HW_SIM_SOPT4_WR(x, (HW_SIM_SOPT4_RD(x) & ~BM_SIM_SOPT4_FTM1CH0SRC) | BF_SIM_SOPT4_FTM1CH0SRC(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM2CH0SRC[21:20] (RW)
 *
 * Selects the source for FTM2 channel 0 input capture. When the FTM is not in
 * input capture mode, clear this field.
 *
 * Values:
 * - 00 - FTM2_CH0 signal
 * - 01 - CMP0 output
 * - 10 - CMP1 output
 * - 11 - Reserved
 */
/*@{*/
#define BP_SIM_SOPT4_FTM2CH0SRC (20U)      /*!< Bit position for SIM_SOPT4_FTM2CH0SRC. */
#define BM_SIM_SOPT4_FTM2CH0SRC (0x00300000U) /*!< Bit mask for SIM_SOPT4_FTM2CH0SRC. */
#define BS_SIM_SOPT4_FTM2CH0SRC (2U)       /*!< Bit field size in bits for SIM_SOPT4_FTM2CH0SRC. */

/*! @brief Read current value of the SIM_SOPT4_FTM2CH0SRC field. */
#define BR_SIM_SOPT4_FTM2CH0SRC(x) (HW_SIM_SOPT4(x).B.FTM2CH0SRC)

/*! @brief Format value for bitfield SIM_SOPT4_FTM2CH0SRC. */
#define BF_SIM_SOPT4_FTM2CH0SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM2CH0SRC) & BM_SIM_SOPT4_FTM2CH0SRC)

/*! @brief Set the FTM2CH0SRC field to a new value. */
#define BW_SIM_SOPT4_FTM2CH0SRC(x, v) (HW_SIM_SOPT4_WR(x, (HW_SIM_SOPT4_RD(x) & ~BM_SIM_SOPT4_FTM2CH0SRC) | BF_SIM_SOPT4_FTM2CH0SRC(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM2CH1SRC[22] (RW)
 *
 * Values:
 * - 0 - FTM2_CH1 signal
 * - 1 - Exclusive OR of FTM2_CH1, FTM2_CH0 and FTM1_CH1.
 */
/*@{*/
#define BP_SIM_SOPT4_FTM2CH1SRC (22U)      /*!< Bit position for SIM_SOPT4_FTM2CH1SRC. */
#define BM_SIM_SOPT4_FTM2CH1SRC (0x00400000U) /*!< Bit mask for SIM_SOPT4_FTM2CH1SRC. */
#define BS_SIM_SOPT4_FTM2CH1SRC (1U)       /*!< Bit field size in bits for SIM_SOPT4_FTM2CH1SRC. */

/*! @brief Read current value of the SIM_SOPT4_FTM2CH1SRC field. */
#define BR_SIM_SOPT4_FTM2CH1SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM2CH1SRC))

/*! @brief Format value for bitfield SIM_SOPT4_FTM2CH1SRC. */
#define BF_SIM_SOPT4_FTM2CH1SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM2CH1SRC) & BM_SIM_SOPT4_FTM2CH1SRC)

/*! @brief Set the FTM2CH1SRC field to a new value. */
#define BW_SIM_SOPT4_FTM2CH1SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM2CH1SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM0CLKSEL[24] (RW)
 *
 * Selects the external pin used to drive the clock to the FTM0 module. The
 * selected pin must also be configured for the FTM external clock function through
 * the appropriate pin control register in the port control module.
 *
 * Values:
 * - 0 - FTM_CLK0 pin
 * - 1 - FTM_CLK1 pin
 */
/*@{*/
#define BP_SIM_SOPT4_FTM0CLKSEL (24U)      /*!< Bit position for SIM_SOPT4_FTM0CLKSEL. */
#define BM_SIM_SOPT4_FTM0CLKSEL (0x01000000U) /*!< Bit mask for SIM_SOPT4_FTM0CLKSEL. */
#define BS_SIM_SOPT4_FTM0CLKSEL (1U)       /*!< Bit field size in bits for SIM_SOPT4_FTM0CLKSEL. */

/*! @brief Read current value of the SIM_SOPT4_FTM0CLKSEL field. */
#define BR_SIM_SOPT4_FTM0CLKSEL(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM0CLKSEL))

/*! @brief Format value for bitfield SIM_SOPT4_FTM0CLKSEL. */
#define BF_SIM_SOPT4_FTM0CLKSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM0CLKSEL) & BM_SIM_SOPT4_FTM0CLKSEL)

/*! @brief Set the FTM0CLKSEL field to a new value. */
#define BW_SIM_SOPT4_FTM0CLKSEL(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM0CLKSEL) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM1CLKSEL[25] (RW)
 *
 * Selects the external pin used to drive the clock to the FTM1 module. The
 * selected pin must also be configured for the FTM external clock function through
 * the appropriate pin control register in the port control module.
 *
 * Values:
 * - 0 - FTM_CLK0 pin
 * - 1 - FTM_CLK1 pin
 */
/*@{*/
#define BP_SIM_SOPT4_FTM1CLKSEL (25U)      /*!< Bit position for SIM_SOPT4_FTM1CLKSEL. */
#define BM_SIM_SOPT4_FTM1CLKSEL (0x02000000U) /*!< Bit mask for SIM_SOPT4_FTM1CLKSEL. */
#define BS_SIM_SOPT4_FTM1CLKSEL (1U)       /*!< Bit field size in bits for SIM_SOPT4_FTM1CLKSEL. */

/*! @brief Read current value of the SIM_SOPT4_FTM1CLKSEL field. */
#define BR_SIM_SOPT4_FTM1CLKSEL(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM1CLKSEL))

/*! @brief Format value for bitfield SIM_SOPT4_FTM1CLKSEL. */
#define BF_SIM_SOPT4_FTM1CLKSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM1CLKSEL) & BM_SIM_SOPT4_FTM1CLKSEL)

/*! @brief Set the FTM1CLKSEL field to a new value. */
#define BW_SIM_SOPT4_FTM1CLKSEL(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM1CLKSEL) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM2CLKSEL[26] (RW)
 *
 * Selects the external pin used to drive the clock to the FTM2 module. The
 * selected pin must also be configured for the FTM2 module external clock function
 * through the appropriate pin control register in the port control module.
 *
 * Values:
 * - 0 - FTM2 external clock driven by FTM_CLK0 pin.
 * - 1 - FTM2 external clock driven by FTM_CLK1 pin.
 */
/*@{*/
#define BP_SIM_SOPT4_FTM2CLKSEL (26U)      /*!< Bit position for SIM_SOPT4_FTM2CLKSEL. */
#define BM_SIM_SOPT4_FTM2CLKSEL (0x04000000U) /*!< Bit mask for SIM_SOPT4_FTM2CLKSEL. */
#define BS_SIM_SOPT4_FTM2CLKSEL (1U)       /*!< Bit field size in bits for SIM_SOPT4_FTM2CLKSEL. */

/*! @brief Read current value of the SIM_SOPT4_FTM2CLKSEL field. */
#define BR_SIM_SOPT4_FTM2CLKSEL(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM2CLKSEL))

/*! @brief Format value for bitfield SIM_SOPT4_FTM2CLKSEL. */
#define BF_SIM_SOPT4_FTM2CLKSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM2CLKSEL) & BM_SIM_SOPT4_FTM2CLKSEL)

/*! @brief Set the FTM2CLKSEL field to a new value. */
#define BW_SIM_SOPT4_FTM2CLKSEL(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM2CLKSEL) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM3CLKSEL[27] (RW)
 *
 * Selects the external pin used to drive the clock to the FTM3 module. The
 * selected pin must also be configured for the FTM3 module external clock function
 * through the appropriate pin control register in the port control module.
 *
 * Values:
 * - 0 - FTM3 external clock driven by FTM_CLK0 pin.
 * - 1 - FTM3 external clock driven by FTM_CLK1 pin.
 */
/*@{*/
#define BP_SIM_SOPT4_FTM3CLKSEL (27U)      /*!< Bit position for SIM_SOPT4_FTM3CLKSEL. */
#define BM_SIM_SOPT4_FTM3CLKSEL (0x08000000U) /*!< Bit mask for SIM_SOPT4_FTM3CLKSEL. */
#define BS_SIM_SOPT4_FTM3CLKSEL (1U)       /*!< Bit field size in bits for SIM_SOPT4_FTM3CLKSEL. */

/*! @brief Read current value of the SIM_SOPT4_FTM3CLKSEL field. */
#define BR_SIM_SOPT4_FTM3CLKSEL(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM3CLKSEL))

/*! @brief Format value for bitfield SIM_SOPT4_FTM3CLKSEL. */
#define BF_SIM_SOPT4_FTM3CLKSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM3CLKSEL) & BM_SIM_SOPT4_FTM3CLKSEL)

/*! @brief Set the FTM3CLKSEL field to a new value. */
#define BW_SIM_SOPT4_FTM3CLKSEL(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM3CLKSEL) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM0TRG0SRC[28] (RW)
 *
 * Selects the source of FTM0 hardware trigger 0.
 *
 * Values:
 * - 0 - HSCMP0 output drives FTM0 hardware trigger 0
 * - 1 - FTM1 channel match drives FTM0 hardware trigger 0
 */
/*@{*/
#define BP_SIM_SOPT4_FTM0TRG0SRC (28U)     /*!< Bit position for SIM_SOPT4_FTM0TRG0SRC. */
#define BM_SIM_SOPT4_FTM0TRG0SRC (0x10000000U) /*!< Bit mask for SIM_SOPT4_FTM0TRG0SRC. */
#define BS_SIM_SOPT4_FTM0TRG0SRC (1U)      /*!< Bit field size in bits for SIM_SOPT4_FTM0TRG0SRC. */

/*! @brief Read current value of the SIM_SOPT4_FTM0TRG0SRC field. */
#define BR_SIM_SOPT4_FTM0TRG0SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM0TRG0SRC))

/*! @brief Format value for bitfield SIM_SOPT4_FTM0TRG0SRC. */
#define BF_SIM_SOPT4_FTM0TRG0SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM0TRG0SRC) & BM_SIM_SOPT4_FTM0TRG0SRC)

/*! @brief Set the FTM0TRG0SRC field to a new value. */
#define BW_SIM_SOPT4_FTM0TRG0SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM0TRG0SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM0TRG1SRC[29] (RW)
 *
 * Selects the source of FTM0 hardware trigger 1.
 *
 * Values:
 * - 0 - PDB output trigger 1 drives FTM0 hardware trigger 1
 * - 1 - FTM2 channel match drives FTM0 hardware trigger 1
 */
/*@{*/
#define BP_SIM_SOPT4_FTM0TRG1SRC (29U)     /*!< Bit position for SIM_SOPT4_FTM0TRG1SRC. */
#define BM_SIM_SOPT4_FTM0TRG1SRC (0x20000000U) /*!< Bit mask for SIM_SOPT4_FTM0TRG1SRC. */
#define BS_SIM_SOPT4_FTM0TRG1SRC (1U)      /*!< Bit field size in bits for SIM_SOPT4_FTM0TRG1SRC. */

/*! @brief Read current value of the SIM_SOPT4_FTM0TRG1SRC field. */
#define BR_SIM_SOPT4_FTM0TRG1SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM0TRG1SRC))

/*! @brief Format value for bitfield SIM_SOPT4_FTM0TRG1SRC. */
#define BF_SIM_SOPT4_FTM0TRG1SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM0TRG1SRC) & BM_SIM_SOPT4_FTM0TRG1SRC)

/*! @brief Set the FTM0TRG1SRC field to a new value. */
#define BW_SIM_SOPT4_FTM0TRG1SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM0TRG1SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM3TRG0SRC[30] (RW)
 *
 * Selects the source of FTM3 hardware trigger 0.
 *
 * Values:
 * - 0 - Reserved
 * - 1 - FTM1 channel match drives FTM3 hardware trigger 0
 */
/*@{*/
#define BP_SIM_SOPT4_FTM3TRG0SRC (30U)     /*!< Bit position for SIM_SOPT4_FTM3TRG0SRC. */
#define BM_SIM_SOPT4_FTM3TRG0SRC (0x40000000U) /*!< Bit mask for SIM_SOPT4_FTM3TRG0SRC. */
#define BS_SIM_SOPT4_FTM3TRG0SRC (1U)      /*!< Bit field size in bits for SIM_SOPT4_FTM3TRG0SRC. */

/*! @brief Read current value of the SIM_SOPT4_FTM3TRG0SRC field. */
#define BR_SIM_SOPT4_FTM3TRG0SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM3TRG0SRC))

/*! @brief Format value for bitfield SIM_SOPT4_FTM3TRG0SRC. */
#define BF_SIM_SOPT4_FTM3TRG0SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM3TRG0SRC) & BM_SIM_SOPT4_FTM3TRG0SRC)

/*! @brief Set the FTM3TRG0SRC field to a new value. */
#define BW_SIM_SOPT4_FTM3TRG0SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM3TRG0SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT4, field FTM3TRG1SRC[31] (RW)
 *
 * Selects the source of FTM3 hardware trigger 1.
 *
 * Values:
 * - 0 - Reserved
 * - 1 - FTM2 channel match drives FTM3 hardware trigger 1
 */
/*@{*/
#define BP_SIM_SOPT4_FTM3TRG1SRC (31U)     /*!< Bit position for SIM_SOPT4_FTM3TRG1SRC. */
#define BM_SIM_SOPT4_FTM3TRG1SRC (0x80000000U) /*!< Bit mask for SIM_SOPT4_FTM3TRG1SRC. */
#define BS_SIM_SOPT4_FTM3TRG1SRC (1U)      /*!< Bit field size in bits for SIM_SOPT4_FTM3TRG1SRC. */

/*! @brief Read current value of the SIM_SOPT4_FTM3TRG1SRC field. */
#define BR_SIM_SOPT4_FTM3TRG1SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM3TRG1SRC))

/*! @brief Format value for bitfield SIM_SOPT4_FTM3TRG1SRC. */
#define BF_SIM_SOPT4_FTM3TRG1SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT4_FTM3TRG1SRC) & BM_SIM_SOPT4_FTM3TRG1SRC)

/*! @brief Set the FTM3TRG1SRC field to a new value. */
#define BW_SIM_SOPT4_FTM3TRG1SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR(x), BP_SIM_SOPT4_FTM3TRG1SRC) = (v))
/*@}*/

/*******************************************************************************
 * HW_SIM_SOPT5 - System Options Register 5
 ******************************************************************************/

/*!
 * @brief HW_SIM_SOPT5 - System Options Register 5 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_sopt5
{
    uint32_t U;
    struct _hw_sim_sopt5_bitfields
    {
        uint32_t UART0TXSRC : 2;       /*!< [1:0] UART 0 transmit data source
                                        * select */
        uint32_t UART0RXSRC : 2;       /*!< [3:2] UART 0 receive data source select
                                        * */
        uint32_t UART1TXSRC : 2;       /*!< [5:4] UART 1 transmit data source
                                        * select */
        uint32_t UART1RXSRC : 2;       /*!< [7:6] UART 1 receive data source select
                                        * */
        uint32_t RESERVED0 : 10;       /*!< [17:8]  */
        uint32_t LPUART0RXSRC : 2;     /*!< [19:18] LPUART0 receive data source
                                        * select */
        uint32_t RESERVED1 : 12;       /*!< [31:20]  */
    } B;
} hw_sim_sopt5_t;

/*!
 * @name Constants and macros for entire SIM_SOPT5 register
 */
/*@{*/
#define HW_SIM_SOPT5_ADDR(x)     ((x) + 0x1010U)

#define HW_SIM_SOPT5(x)          (*(__IO hw_sim_sopt5_t *) HW_SIM_SOPT5_ADDR(x))
#define HW_SIM_SOPT5_RD(x)       (HW_SIM_SOPT5(x).U)
#define HW_SIM_SOPT5_WR(x, v)    (HW_SIM_SOPT5(x).U = (v))
#define HW_SIM_SOPT5_SET(x, v)   (HW_SIM_SOPT5_WR(x, HW_SIM_SOPT5_RD(x) |  (v)))
#define HW_SIM_SOPT5_CLR(x, v)   (HW_SIM_SOPT5_WR(x, HW_SIM_SOPT5_RD(x) & ~(v)))
#define HW_SIM_SOPT5_TOG(x, v)   (HW_SIM_SOPT5_WR(x, HW_SIM_SOPT5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT5 bitfields
 */

/*!
 * @name Register SIM_SOPT5, field UART0TXSRC[1:0] (RW)
 *
 * Selects the source for the UART 0 transmit data.
 *
 * Values:
 * - 00 - UART0_TX pin
 * - 01 - UART0_TX pin modulated with FTM1 channel 0 output
 * - 10 - UART0_TX pin modulated with FTM2 channel 0 output
 * - 11 - Reserved
 */
/*@{*/
#define BP_SIM_SOPT5_UART0TXSRC (0U)       /*!< Bit position for SIM_SOPT5_UART0TXSRC. */
#define BM_SIM_SOPT5_UART0TXSRC (0x00000003U) /*!< Bit mask for SIM_SOPT5_UART0TXSRC. */
#define BS_SIM_SOPT5_UART0TXSRC (2U)       /*!< Bit field size in bits for SIM_SOPT5_UART0TXSRC. */

/*! @brief Read current value of the SIM_SOPT5_UART0TXSRC field. */
#define BR_SIM_SOPT5_UART0TXSRC(x) (HW_SIM_SOPT5(x).B.UART0TXSRC)

/*! @brief Format value for bitfield SIM_SOPT5_UART0TXSRC. */
#define BF_SIM_SOPT5_UART0TXSRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT5_UART0TXSRC) & BM_SIM_SOPT5_UART0TXSRC)

/*! @brief Set the UART0TXSRC field to a new value. */
#define BW_SIM_SOPT5_UART0TXSRC(x, v) (HW_SIM_SOPT5_WR(x, (HW_SIM_SOPT5_RD(x) & ~BM_SIM_SOPT5_UART0TXSRC) | BF_SIM_SOPT5_UART0TXSRC(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT5, field UART0RXSRC[3:2] (RW)
 *
 * Selects the source for the UART 0 receive data.
 *
 * Values:
 * - 00 - UART0_RX pin
 * - 01 - CMP0
 * - 10 - CMP1
 * - 11 - Reserved
 */
/*@{*/
#define BP_SIM_SOPT5_UART0RXSRC (2U)       /*!< Bit position for SIM_SOPT5_UART0RXSRC. */
#define BM_SIM_SOPT5_UART0RXSRC (0x0000000CU) /*!< Bit mask for SIM_SOPT5_UART0RXSRC. */
#define BS_SIM_SOPT5_UART0RXSRC (2U)       /*!< Bit field size in bits for SIM_SOPT5_UART0RXSRC. */

/*! @brief Read current value of the SIM_SOPT5_UART0RXSRC field. */
#define BR_SIM_SOPT5_UART0RXSRC(x) (HW_SIM_SOPT5(x).B.UART0RXSRC)

/*! @brief Format value for bitfield SIM_SOPT5_UART0RXSRC. */
#define BF_SIM_SOPT5_UART0RXSRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT5_UART0RXSRC) & BM_SIM_SOPT5_UART0RXSRC)

/*! @brief Set the UART0RXSRC field to a new value. */
#define BW_SIM_SOPT5_UART0RXSRC(x, v) (HW_SIM_SOPT5_WR(x, (HW_SIM_SOPT5_RD(x) & ~BM_SIM_SOPT5_UART0RXSRC) | BF_SIM_SOPT5_UART0RXSRC(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT5, field UART1TXSRC[5:4] (RW)
 *
 * Selects the source for the UART 1 transmit data.
 *
 * Values:
 * - 00 - UART1_TX pin
 * - 01 - UART1_TX pin modulated with FTM1 channel 0 output
 * - 10 - UART1_TX pin modulated with FTM2 channel 0 output
 * - 11 - Reserved
 */
/*@{*/
#define BP_SIM_SOPT5_UART1TXSRC (4U)       /*!< Bit position for SIM_SOPT5_UART1TXSRC. */
#define BM_SIM_SOPT5_UART1TXSRC (0x00000030U) /*!< Bit mask for SIM_SOPT5_UART1TXSRC. */
#define BS_SIM_SOPT5_UART1TXSRC (2U)       /*!< Bit field size in bits for SIM_SOPT5_UART1TXSRC. */

/*! @brief Read current value of the SIM_SOPT5_UART1TXSRC field. */
#define BR_SIM_SOPT5_UART1TXSRC(x) (HW_SIM_SOPT5(x).B.UART1TXSRC)

/*! @brief Format value for bitfield SIM_SOPT5_UART1TXSRC. */
#define BF_SIM_SOPT5_UART1TXSRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT5_UART1TXSRC) & BM_SIM_SOPT5_UART1TXSRC)

/*! @brief Set the UART1TXSRC field to a new value. */
#define BW_SIM_SOPT5_UART1TXSRC(x, v) (HW_SIM_SOPT5_WR(x, (HW_SIM_SOPT5_RD(x) & ~BM_SIM_SOPT5_UART1TXSRC) | BF_SIM_SOPT5_UART1TXSRC(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT5, field UART1RXSRC[7:6] (RW)
 *
 * Selects the source for the UART 1 receive data.
 *
 * Values:
 * - 00 - UART1_RX pin
 * - 01 - CMP0
 * - 10 - CMP1
 * - 11 - Reserved
 */
/*@{*/
#define BP_SIM_SOPT5_UART1RXSRC (6U)       /*!< Bit position for SIM_SOPT5_UART1RXSRC. */
#define BM_SIM_SOPT5_UART1RXSRC (0x000000C0U) /*!< Bit mask for SIM_SOPT5_UART1RXSRC. */
#define BS_SIM_SOPT5_UART1RXSRC (2U)       /*!< Bit field size in bits for SIM_SOPT5_UART1RXSRC. */

/*! @brief Read current value of the SIM_SOPT5_UART1RXSRC field. */
#define BR_SIM_SOPT5_UART1RXSRC(x) (HW_SIM_SOPT5(x).B.UART1RXSRC)

/*! @brief Format value for bitfield SIM_SOPT5_UART1RXSRC. */
#define BF_SIM_SOPT5_UART1RXSRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT5_UART1RXSRC) & BM_SIM_SOPT5_UART1RXSRC)

/*! @brief Set the UART1RXSRC field to a new value. */
#define BW_SIM_SOPT5_UART1RXSRC(x, v) (HW_SIM_SOPT5_WR(x, (HW_SIM_SOPT5_RD(x) & ~BM_SIM_SOPT5_UART1RXSRC) | BF_SIM_SOPT5_UART1RXSRC(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT5, field LPUART0RXSRC[19:18] (RW)
 *
 * Selects the source for the LPUART0 receive data.
 *
 * Values:
 * - 00 - LPUART0_RX pin
 * - 01 - CMP0 output
 * - 10 - CMP1 output
 * - 11 - Reserved
 */
/*@{*/
#define BP_SIM_SOPT5_LPUART0RXSRC (18U)    /*!< Bit position for SIM_SOPT5_LPUART0RXSRC. */
#define BM_SIM_SOPT5_LPUART0RXSRC (0x000C0000U) /*!< Bit mask for SIM_SOPT5_LPUART0RXSRC. */
#define BS_SIM_SOPT5_LPUART0RXSRC (2U)     /*!< Bit field size in bits for SIM_SOPT5_LPUART0RXSRC. */

/*! @brief Read current value of the SIM_SOPT5_LPUART0RXSRC field. */
#define BR_SIM_SOPT5_LPUART0RXSRC(x) (HW_SIM_SOPT5(x).B.LPUART0RXSRC)

/*! @brief Format value for bitfield SIM_SOPT5_LPUART0RXSRC. */
#define BF_SIM_SOPT5_LPUART0RXSRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT5_LPUART0RXSRC) & BM_SIM_SOPT5_LPUART0RXSRC)

/*! @brief Set the LPUART0RXSRC field to a new value. */
#define BW_SIM_SOPT5_LPUART0RXSRC(x, v) (HW_SIM_SOPT5_WR(x, (HW_SIM_SOPT5_RD(x) & ~BM_SIM_SOPT5_LPUART0RXSRC) | BF_SIM_SOPT5_LPUART0RXSRC(v)))
/*@}*/

/*******************************************************************************
 * HW_SIM_SOPT7 - System Options Register 7
 ******************************************************************************/

/*!
 * @brief HW_SIM_SOPT7 - System Options Register 7 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_sopt7
{
    uint32_t U;
    struct _hw_sim_sopt7_bitfields
    {
        uint32_t ADC0TRGSEL : 4;       /*!< [3:0] ADC0 trigger select */
        uint32_t ADC0PRETRGSEL : 1;    /*!< [4] ADC0 pretrigger select */
        uint32_t RESERVED0 : 2;        /*!< [6:5]  */
        uint32_t ADC0ALTTRGEN : 1;     /*!< [7] ADC0 alternate trigger enable */
        uint32_t ADC1TRGSEL : 4;       /*!< [11:8] ADC1 trigger select */
        uint32_t ADC1PRETRGSEL : 1;    /*!< [12] ADC1 pre-trigger select */
        uint32_t RESERVED1 : 2;        /*!< [14:13]  */
        uint32_t ADC1ALTTRGEN : 1;     /*!< [15] ADC1 alternate trigger enable */
        uint32_t RESERVED2 : 16;       /*!< [31:16]  */
    } B;
} hw_sim_sopt7_t;

/*!
 * @name Constants and macros for entire SIM_SOPT7 register
 */
/*@{*/
#define HW_SIM_SOPT7_ADDR(x)     ((x) + 0x1018U)

#define HW_SIM_SOPT7(x)          (*(__IO hw_sim_sopt7_t *) HW_SIM_SOPT7_ADDR(x))
#define HW_SIM_SOPT7_RD(x)       (HW_SIM_SOPT7(x).U)
#define HW_SIM_SOPT7_WR(x, v)    (HW_SIM_SOPT7(x).U = (v))
#define HW_SIM_SOPT7_SET(x, v)   (HW_SIM_SOPT7_WR(x, HW_SIM_SOPT7_RD(x) |  (v)))
#define HW_SIM_SOPT7_CLR(x, v)   (HW_SIM_SOPT7_WR(x, HW_SIM_SOPT7_RD(x) & ~(v)))
#define HW_SIM_SOPT7_TOG(x, v)   (HW_SIM_SOPT7_WR(x, HW_SIM_SOPT7_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT7 bitfields
 */

/*!
 * @name Register SIM_SOPT7, field ADC0TRGSEL[3:0] (RW)
 *
 * Selects the ADC0 trigger source when alternative triggers are functional in
 * stop and VLPS modes. .
 *
 * Values:
 * - 0000 - PDB external trigger pin input (PDB0_EXTRG)
 * - 0001 - High speed comparator 0 output
 * - 0010 - High speed comparator 1 output
 * - 0011 - Reserved
 * - 0100 - PIT trigger 0
 * - 0101 - PIT trigger 1
 * - 0110 - PIT trigger 2
 * - 0111 - PIT trigger 3
 * - 1000 - FTM0 trigger
 * - 1001 - FTM1 trigger
 * - 1010 - FTM2 trigger
 * - 1011 - FTM3 trigger
 * - 1100 - RTC alarm
 * - 1101 - RTC seconds
 * - 1110 - Low-power timer (LPTMR) trigger
 * - 1111 - Reserved
 */
/*@{*/
#define BP_SIM_SOPT7_ADC0TRGSEL (0U)       /*!< Bit position for SIM_SOPT7_ADC0TRGSEL. */
#define BM_SIM_SOPT7_ADC0TRGSEL (0x0000000FU) /*!< Bit mask for SIM_SOPT7_ADC0TRGSEL. */
#define BS_SIM_SOPT7_ADC0TRGSEL (4U)       /*!< Bit field size in bits for SIM_SOPT7_ADC0TRGSEL. */

/*! @brief Read current value of the SIM_SOPT7_ADC0TRGSEL field. */
#define BR_SIM_SOPT7_ADC0TRGSEL(x) (HW_SIM_SOPT7(x).B.ADC0TRGSEL)

/*! @brief Format value for bitfield SIM_SOPT7_ADC0TRGSEL. */
#define BF_SIM_SOPT7_ADC0TRGSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT7_ADC0TRGSEL) & BM_SIM_SOPT7_ADC0TRGSEL)

/*! @brief Set the ADC0TRGSEL field to a new value. */
#define BW_SIM_SOPT7_ADC0TRGSEL(x, v) (HW_SIM_SOPT7_WR(x, (HW_SIM_SOPT7_RD(x) & ~BM_SIM_SOPT7_ADC0TRGSEL) | BF_SIM_SOPT7_ADC0TRGSEL(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT7, field ADC0PRETRGSEL[4] (RW)
 *
 * Selects the ADC0 pre-trigger source when alternative triggers are enabled
 * through ADC0ALTTRGEN.
 *
 * Values:
 * - 0 - Pre-trigger A
 * - 1 - Pre-trigger B
 */
/*@{*/
#define BP_SIM_SOPT7_ADC0PRETRGSEL (4U)    /*!< Bit position for SIM_SOPT7_ADC0PRETRGSEL. */
#define BM_SIM_SOPT7_ADC0PRETRGSEL (0x00000010U) /*!< Bit mask for SIM_SOPT7_ADC0PRETRGSEL. */
#define BS_SIM_SOPT7_ADC0PRETRGSEL (1U)    /*!< Bit field size in bits for SIM_SOPT7_ADC0PRETRGSEL. */

/*! @brief Read current value of the SIM_SOPT7_ADC0PRETRGSEL field. */
#define BR_SIM_SOPT7_ADC0PRETRGSEL(x) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR(x), BP_SIM_SOPT7_ADC0PRETRGSEL))

/*! @brief Format value for bitfield SIM_SOPT7_ADC0PRETRGSEL. */
#define BF_SIM_SOPT7_ADC0PRETRGSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT7_ADC0PRETRGSEL) & BM_SIM_SOPT7_ADC0PRETRGSEL)

/*! @brief Set the ADC0PRETRGSEL field to a new value. */
#define BW_SIM_SOPT7_ADC0PRETRGSEL(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR(x), BP_SIM_SOPT7_ADC0PRETRGSEL) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT7, field ADC0ALTTRGEN[7] (RW)
 *
 * Enable alternative conversion triggers for ADC0.
 *
 * Values:
 * - 0 - PDB trigger selected for ADC0.
 * - 1 - Alternate trigger selected for ADC0.
 */
/*@{*/
#define BP_SIM_SOPT7_ADC0ALTTRGEN (7U)     /*!< Bit position for SIM_SOPT7_ADC0ALTTRGEN. */
#define BM_SIM_SOPT7_ADC0ALTTRGEN (0x00000080U) /*!< Bit mask for SIM_SOPT7_ADC0ALTTRGEN. */
#define BS_SIM_SOPT7_ADC0ALTTRGEN (1U)     /*!< Bit field size in bits for SIM_SOPT7_ADC0ALTTRGEN. */

/*! @brief Read current value of the SIM_SOPT7_ADC0ALTTRGEN field. */
#define BR_SIM_SOPT7_ADC0ALTTRGEN(x) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR(x), BP_SIM_SOPT7_ADC0ALTTRGEN))

/*! @brief Format value for bitfield SIM_SOPT7_ADC0ALTTRGEN. */
#define BF_SIM_SOPT7_ADC0ALTTRGEN(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT7_ADC0ALTTRGEN) & BM_SIM_SOPT7_ADC0ALTTRGEN)

/*! @brief Set the ADC0ALTTRGEN field to a new value. */
#define BW_SIM_SOPT7_ADC0ALTTRGEN(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR(x), BP_SIM_SOPT7_ADC0ALTTRGEN) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT7, field ADC1TRGSEL[11:8] (RW)
 *
 * Selects the ADC1 trigger source when alternative triggers are functional in
 * stop and VLPS modes.
 *
 * Values:
 * - 0000 - PDB external trigger pin input (PDB0_EXTRG)
 * - 0001 - High speed comparator 0 output
 * - 0010 - High speed comparator 1 output
 * - 0011 - Reserved
 * - 0100 - PIT trigger 0
 * - 0101 - PIT trigger 1
 * - 0110 - PIT trigger 2
 * - 0111 - PIT trigger 3
 * - 1000 - FTM0 trigger
 * - 1001 - FTM1 trigger
 * - 1010 - FTM2 trigger
 * - 1011 - FTM3 trigger
 * - 1100 - RTC alarm
 * - 1101 - RTC seconds
 * - 1110 - Low-power timer (LPTMR) trigger
 * - 1111 - Reserved
 */
/*@{*/
#define BP_SIM_SOPT7_ADC1TRGSEL (8U)       /*!< Bit position for SIM_SOPT7_ADC1TRGSEL. */
#define BM_SIM_SOPT7_ADC1TRGSEL (0x00000F00U) /*!< Bit mask for SIM_SOPT7_ADC1TRGSEL. */
#define BS_SIM_SOPT7_ADC1TRGSEL (4U)       /*!< Bit field size in bits for SIM_SOPT7_ADC1TRGSEL. */

/*! @brief Read current value of the SIM_SOPT7_ADC1TRGSEL field. */
#define BR_SIM_SOPT7_ADC1TRGSEL(x) (HW_SIM_SOPT7(x).B.ADC1TRGSEL)

/*! @brief Format value for bitfield SIM_SOPT7_ADC1TRGSEL. */
#define BF_SIM_SOPT7_ADC1TRGSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT7_ADC1TRGSEL) & BM_SIM_SOPT7_ADC1TRGSEL)

/*! @brief Set the ADC1TRGSEL field to a new value. */
#define BW_SIM_SOPT7_ADC1TRGSEL(x, v) (HW_SIM_SOPT7_WR(x, (HW_SIM_SOPT7_RD(x) & ~BM_SIM_SOPT7_ADC1TRGSEL) | BF_SIM_SOPT7_ADC1TRGSEL(v)))
/*@}*/

/*!
 * @name Register SIM_SOPT7, field ADC1PRETRGSEL[12] (RW)
 *
 * Selects the ADC1 pre-trigger source when alternative triggers are enabled
 * through ADC1ALTTRGEN.
 *
 * Values:
 * - 0 - Pre-trigger A selected for ADC1.
 * - 1 - Pre-trigger B selected for ADC1.
 */
/*@{*/
#define BP_SIM_SOPT7_ADC1PRETRGSEL (12U)   /*!< Bit position for SIM_SOPT7_ADC1PRETRGSEL. */
#define BM_SIM_SOPT7_ADC1PRETRGSEL (0x00001000U) /*!< Bit mask for SIM_SOPT7_ADC1PRETRGSEL. */
#define BS_SIM_SOPT7_ADC1PRETRGSEL (1U)    /*!< Bit field size in bits for SIM_SOPT7_ADC1PRETRGSEL. */

/*! @brief Read current value of the SIM_SOPT7_ADC1PRETRGSEL field. */
#define BR_SIM_SOPT7_ADC1PRETRGSEL(x) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR(x), BP_SIM_SOPT7_ADC1PRETRGSEL))

/*! @brief Format value for bitfield SIM_SOPT7_ADC1PRETRGSEL. */
#define BF_SIM_SOPT7_ADC1PRETRGSEL(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT7_ADC1PRETRGSEL) & BM_SIM_SOPT7_ADC1PRETRGSEL)

/*! @brief Set the ADC1PRETRGSEL field to a new value. */
#define BW_SIM_SOPT7_ADC1PRETRGSEL(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR(x), BP_SIM_SOPT7_ADC1PRETRGSEL) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT7, field ADC1ALTTRGEN[15] (RW)
 *
 * Enable alternative conversion triggers for ADC1.
 *
 * Values:
 * - 0 - PDB trigger selected for ADC1
 * - 1 - Alternate trigger selected for ADC1 as defined by ADC1TRGSEL.
 */
/*@{*/
#define BP_SIM_SOPT7_ADC1ALTTRGEN (15U)    /*!< Bit position for SIM_SOPT7_ADC1ALTTRGEN. */
#define BM_SIM_SOPT7_ADC1ALTTRGEN (0x00008000U) /*!< Bit mask for SIM_SOPT7_ADC1ALTTRGEN. */
#define BS_SIM_SOPT7_ADC1ALTTRGEN (1U)     /*!< Bit field size in bits for SIM_SOPT7_ADC1ALTTRGEN. */

/*! @brief Read current value of the SIM_SOPT7_ADC1ALTTRGEN field. */
#define BR_SIM_SOPT7_ADC1ALTTRGEN(x) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR(x), BP_SIM_SOPT7_ADC1ALTTRGEN))

/*! @brief Format value for bitfield SIM_SOPT7_ADC1ALTTRGEN. */
#define BF_SIM_SOPT7_ADC1ALTTRGEN(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT7_ADC1ALTTRGEN) & BM_SIM_SOPT7_ADC1ALTTRGEN)

/*! @brief Set the ADC1ALTTRGEN field to a new value. */
#define BW_SIM_SOPT7_ADC1ALTTRGEN(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR(x), BP_SIM_SOPT7_ADC1ALTTRGEN) = (v))
/*@}*/

/*******************************************************************************
 * HW_SIM_SOPT8 - System Options Register 8
 ******************************************************************************/

/*!
 * @brief HW_SIM_SOPT8 - System Options Register 8 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_sopt8
{
    uint32_t U;
    struct _hw_sim_sopt8_bitfields
    {
        uint32_t FTM0SYNCBIT : 1;      /*!< [0] FTM0 Hardware Trigger 0 Software
                                        * Synchronization */
        uint32_t FTM1SYNCBIT : 1;      /*!< [1] FTM1 Hardware Trigger 0 Software
                                        * Synchronization */
        uint32_t FTM2SYNCBIT : 1;      /*!< [2] FTM2 Hardware Trigger 0 Software
                                        * Synchronization */
        uint32_t FTM3SYNCBIT : 1;      /*!< [3] FTM3 Hardware Trigger 0 Software
                                        * Synchronization */
        uint32_t RESERVED0 : 12;       /*!< [15:4]  */
        uint32_t FTM0OCH0SRC : 1;      /*!< [16] FTM0 channel 0 output source */
        uint32_t FTM0OCH1SRC : 1;      /*!< [17] FTM0 channel 1 output source */
        uint32_t FTM0OCH2SRC : 1;      /*!< [18] FTM0 channel 2 output source */
        uint32_t FTM0OCH3SRC : 1;      /*!< [19] FTM0 channel 3 output source */
        uint32_t FTM0OCH4SRC : 1;      /*!< [20] FTM0 channel 4 output source */
        uint32_t FTM0OCH5SRC : 1;      /*!< [21] FTM0 channel 5 output source */
        uint32_t FTM0OCH6SRC : 1;      /*!< [22] FTM0 channel 6 output source */
        uint32_t FTM0OCH7SRC : 1;      /*!< [23] FTM0 channel 7 output source */
        uint32_t FTM3OCH0SRC : 1;      /*!< [24] FTM3 channel 0 output source */
        uint32_t FTM3OCH1SRC : 1;      /*!< [25] FTM3 channel 1 output source */
        uint32_t FTM3OCH2SRC : 1;      /*!< [26] FTM3 channel 2 output source */
        uint32_t FTM3OCH3SRC : 1;      /*!< [27] FTM3 channel 3 output source */
        uint32_t FTM3OCH4SRC : 1;      /*!< [28] FTM3 channel 4 output source */
        uint32_t FTM3OCH5SRC : 1;      /*!< [29] FTM3 channel 5 output source */
        uint32_t FTM3OCH6SRC : 1;      /*!< [30] FTM3 channel 6 output source */
        uint32_t FTM3OCH7SRC : 1;      /*!< [31] FTM3 channel 7 output source */
    } B;
} hw_sim_sopt8_t;

/*!
 * @name Constants and macros for entire SIM_SOPT8 register
 */
/*@{*/
#define HW_SIM_SOPT8_ADDR(x)     ((x) + 0x101CU)

#define HW_SIM_SOPT8(x)          (*(__IO hw_sim_sopt8_t *) HW_SIM_SOPT8_ADDR(x))
#define HW_SIM_SOPT8_RD(x)       (HW_SIM_SOPT8(x).U)
#define HW_SIM_SOPT8_WR(x, v)    (HW_SIM_SOPT8(x).U = (v))
#define HW_SIM_SOPT8_SET(x, v)   (HW_SIM_SOPT8_WR(x, HW_SIM_SOPT8_RD(x) |  (v)))
#define HW_SIM_SOPT8_CLR(x, v)   (HW_SIM_SOPT8_WR(x, HW_SIM_SOPT8_RD(x) & ~(v)))
#define HW_SIM_SOPT8_TOG(x, v)   (HW_SIM_SOPT8_WR(x, HW_SIM_SOPT8_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_SOPT8 bitfields
 */

/*!
 * @name Register SIM_SOPT8, field FTM0SYNCBIT[0] (RW)
 *
 * Values:
 * - 0 - No effect
 * - 1 - Write 1 to assert the TRIG0 input to FTM0, software must clear this bit
 *     to allow other trigger sources to assert.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM0SYNCBIT (0U)      /*!< Bit position for SIM_SOPT8_FTM0SYNCBIT. */
#define BM_SIM_SOPT8_FTM0SYNCBIT (0x00000001U) /*!< Bit mask for SIM_SOPT8_FTM0SYNCBIT. */
#define BS_SIM_SOPT8_FTM0SYNCBIT (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM0SYNCBIT. */

/*! @brief Read current value of the SIM_SOPT8_FTM0SYNCBIT field. */
#define BR_SIM_SOPT8_FTM0SYNCBIT(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0SYNCBIT))

/*! @brief Format value for bitfield SIM_SOPT8_FTM0SYNCBIT. */
#define BF_SIM_SOPT8_FTM0SYNCBIT(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM0SYNCBIT) & BM_SIM_SOPT8_FTM0SYNCBIT)

/*! @brief Set the FTM0SYNCBIT field to a new value. */
#define BW_SIM_SOPT8_FTM0SYNCBIT(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0SYNCBIT) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM1SYNCBIT[1] (RW)
 *
 * Values:
 * - 0 - No effect.
 * - 1 - Write 1 to assert the TRIG0 input to FTM1, software must clear this bit
 *     to allow other trigger sources to assert.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM1SYNCBIT (1U)      /*!< Bit position for SIM_SOPT8_FTM1SYNCBIT. */
#define BM_SIM_SOPT8_FTM1SYNCBIT (0x00000002U) /*!< Bit mask for SIM_SOPT8_FTM1SYNCBIT. */
#define BS_SIM_SOPT8_FTM1SYNCBIT (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM1SYNCBIT. */

/*! @brief Read current value of the SIM_SOPT8_FTM1SYNCBIT field. */
#define BR_SIM_SOPT8_FTM1SYNCBIT(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM1SYNCBIT))

/*! @brief Format value for bitfield SIM_SOPT8_FTM1SYNCBIT. */
#define BF_SIM_SOPT8_FTM1SYNCBIT(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM1SYNCBIT) & BM_SIM_SOPT8_FTM1SYNCBIT)

/*! @brief Set the FTM1SYNCBIT field to a new value. */
#define BW_SIM_SOPT8_FTM1SYNCBIT(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM1SYNCBIT) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM2SYNCBIT[2] (RW)
 *
 * Values:
 * - 0 - No effect.
 * - 1 - Write 1 to assert the TRIG0 input to FTM2, software must clear this bit
 *     to allow other trigger sources to assert.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM2SYNCBIT (2U)      /*!< Bit position for SIM_SOPT8_FTM2SYNCBIT. */
#define BM_SIM_SOPT8_FTM2SYNCBIT (0x00000004U) /*!< Bit mask for SIM_SOPT8_FTM2SYNCBIT. */
#define BS_SIM_SOPT8_FTM2SYNCBIT (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM2SYNCBIT. */

/*! @brief Read current value of the SIM_SOPT8_FTM2SYNCBIT field. */
#define BR_SIM_SOPT8_FTM2SYNCBIT(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM2SYNCBIT))

/*! @brief Format value for bitfield SIM_SOPT8_FTM2SYNCBIT. */
#define BF_SIM_SOPT8_FTM2SYNCBIT(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM2SYNCBIT) & BM_SIM_SOPT8_FTM2SYNCBIT)

/*! @brief Set the FTM2SYNCBIT field to a new value. */
#define BW_SIM_SOPT8_FTM2SYNCBIT(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM2SYNCBIT) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM3SYNCBIT[3] (RW)
 *
 * Values:
 * - 0 - No effect.
 * - 1 - Write 1 to assert the TRIG0 input to FTM3, software must clear this bit
 *     to allow other trigger sources to assert.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM3SYNCBIT (3U)      /*!< Bit position for SIM_SOPT8_FTM3SYNCBIT. */
#define BM_SIM_SOPT8_FTM3SYNCBIT (0x00000008U) /*!< Bit mask for SIM_SOPT8_FTM3SYNCBIT. */
#define BS_SIM_SOPT8_FTM3SYNCBIT (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM3SYNCBIT. */

/*! @brief Read current value of the SIM_SOPT8_FTM3SYNCBIT field. */
#define BR_SIM_SOPT8_FTM3SYNCBIT(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3SYNCBIT))

/*! @brief Format value for bitfield SIM_SOPT8_FTM3SYNCBIT. */
#define BF_SIM_SOPT8_FTM3SYNCBIT(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM3SYNCBIT) & BM_SIM_SOPT8_FTM3SYNCBIT)

/*! @brief Set the FTM3SYNCBIT field to a new value. */
#define BW_SIM_SOPT8_FTM3SYNCBIT(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3SYNCBIT) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM0OCH0SRC[16] (RW)
 *
 * Values:
 * - 0 - FTM0_CH0 pin is output of FTM0 channel 0 output
 * - 1 - FTM0_CH0 pin is output of FTM0 channel 0 output, modulated by FTM1
 *     channel 1 output
 */
/*@{*/
#define BP_SIM_SOPT8_FTM0OCH0SRC (16U)     /*!< Bit position for SIM_SOPT8_FTM0OCH0SRC. */
#define BM_SIM_SOPT8_FTM0OCH0SRC (0x00010000U) /*!< Bit mask for SIM_SOPT8_FTM0OCH0SRC. */
#define BS_SIM_SOPT8_FTM0OCH0SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM0OCH0SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM0OCH0SRC field. */
#define BR_SIM_SOPT8_FTM0OCH0SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH0SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM0OCH0SRC. */
#define BF_SIM_SOPT8_FTM0OCH0SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM0OCH0SRC) & BM_SIM_SOPT8_FTM0OCH0SRC)

/*! @brief Set the FTM0OCH0SRC field to a new value. */
#define BW_SIM_SOPT8_FTM0OCH0SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH0SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM0OCH1SRC[17] (RW)
 *
 * Values:
 * - 0 - FTM0_CH1 pin is output of FTM0 channel 1 output
 * - 1 - FTM0_CH1 pin is output of FTM0 channel 1 output, modulated by FTM1
 *     channel 1 output
 */
/*@{*/
#define BP_SIM_SOPT8_FTM0OCH1SRC (17U)     /*!< Bit position for SIM_SOPT8_FTM0OCH1SRC. */
#define BM_SIM_SOPT8_FTM0OCH1SRC (0x00020000U) /*!< Bit mask for SIM_SOPT8_FTM0OCH1SRC. */
#define BS_SIM_SOPT8_FTM0OCH1SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM0OCH1SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM0OCH1SRC field. */
#define BR_SIM_SOPT8_FTM0OCH1SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH1SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM0OCH1SRC. */
#define BF_SIM_SOPT8_FTM0OCH1SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM0OCH1SRC) & BM_SIM_SOPT8_FTM0OCH1SRC)

/*! @brief Set the FTM0OCH1SRC field to a new value. */
#define BW_SIM_SOPT8_FTM0OCH1SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH1SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM0OCH2SRC[18] (RW)
 *
 * Values:
 * - 0 - FTM0_CH2 pin is output of FTM0 channel 2 output
 * - 1 - FTM0_CH2 pin is output of FTM0 channel 2 output, modulated by FTM1
 *     channel 1 output
 */
/*@{*/
#define BP_SIM_SOPT8_FTM0OCH2SRC (18U)     /*!< Bit position for SIM_SOPT8_FTM0OCH2SRC. */
#define BM_SIM_SOPT8_FTM0OCH2SRC (0x00040000U) /*!< Bit mask for SIM_SOPT8_FTM0OCH2SRC. */
#define BS_SIM_SOPT8_FTM0OCH2SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM0OCH2SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM0OCH2SRC field. */
#define BR_SIM_SOPT8_FTM0OCH2SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH2SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM0OCH2SRC. */
#define BF_SIM_SOPT8_FTM0OCH2SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM0OCH2SRC) & BM_SIM_SOPT8_FTM0OCH2SRC)

/*! @brief Set the FTM0OCH2SRC field to a new value. */
#define BW_SIM_SOPT8_FTM0OCH2SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH2SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM0OCH3SRC[19] (RW)
 *
 * Values:
 * - 0 - FTM0_CH3 pin is output of FTM0 channel 3 output
 * - 1 - FTM0_CH3 pin is output of FTM0 channel 3 output, modulated by FTM1
 *     channel 1 output
 */
/*@{*/
#define BP_SIM_SOPT8_FTM0OCH3SRC (19U)     /*!< Bit position for SIM_SOPT8_FTM0OCH3SRC. */
#define BM_SIM_SOPT8_FTM0OCH3SRC (0x00080000U) /*!< Bit mask for SIM_SOPT8_FTM0OCH3SRC. */
#define BS_SIM_SOPT8_FTM0OCH3SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM0OCH3SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM0OCH3SRC field. */
#define BR_SIM_SOPT8_FTM0OCH3SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH3SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM0OCH3SRC. */
#define BF_SIM_SOPT8_FTM0OCH3SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM0OCH3SRC) & BM_SIM_SOPT8_FTM0OCH3SRC)

/*! @brief Set the FTM0OCH3SRC field to a new value. */
#define BW_SIM_SOPT8_FTM0OCH3SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH3SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM0OCH4SRC[20] (RW)
 *
 * Values:
 * - 0 - FTM0_CH4 pin is output of FTM0 channel 4 output
 * - 1 - FTM0_CH4 pin is output of FTM0 channel 4 output, modulated by FTM1
 *     channel 1 output
 */
/*@{*/
#define BP_SIM_SOPT8_FTM0OCH4SRC (20U)     /*!< Bit position for SIM_SOPT8_FTM0OCH4SRC. */
#define BM_SIM_SOPT8_FTM0OCH4SRC (0x00100000U) /*!< Bit mask for SIM_SOPT8_FTM0OCH4SRC. */
#define BS_SIM_SOPT8_FTM0OCH4SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM0OCH4SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM0OCH4SRC field. */
#define BR_SIM_SOPT8_FTM0OCH4SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH4SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM0OCH4SRC. */
#define BF_SIM_SOPT8_FTM0OCH4SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM0OCH4SRC) & BM_SIM_SOPT8_FTM0OCH4SRC)

/*! @brief Set the FTM0OCH4SRC field to a new value. */
#define BW_SIM_SOPT8_FTM0OCH4SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH4SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM0OCH5SRC[21] (RW)
 *
 * Values:
 * - 0 - FTM0_CH5 pin is output of FTM0 channel 5 output
 * - 1 - FTM0_CH5 pin is output of FTM0 channel 5 output, modulated by FTM1
 *     channel 1 output
 */
/*@{*/
#define BP_SIM_SOPT8_FTM0OCH5SRC (21U)     /*!< Bit position for SIM_SOPT8_FTM0OCH5SRC. */
#define BM_SIM_SOPT8_FTM0OCH5SRC (0x00200000U) /*!< Bit mask for SIM_SOPT8_FTM0OCH5SRC. */
#define BS_SIM_SOPT8_FTM0OCH5SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM0OCH5SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM0OCH5SRC field. */
#define BR_SIM_SOPT8_FTM0OCH5SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH5SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM0OCH5SRC. */
#define BF_SIM_SOPT8_FTM0OCH5SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM0OCH5SRC) & BM_SIM_SOPT8_FTM0OCH5SRC)

/*! @brief Set the FTM0OCH5SRC field to a new value. */
#define BW_SIM_SOPT8_FTM0OCH5SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH5SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM0OCH6SRC[22] (RW)
 *
 * Values:
 * - 0 - FTM0_CH6 pin is output of FTM0 channel 6 output
 * - 1 - FTM0_CH6 pin is output of FTM0 channel 6 output, modulated by FTM1
 *     channel 1 output
 */
/*@{*/
#define BP_SIM_SOPT8_FTM0OCH6SRC (22U)     /*!< Bit position for SIM_SOPT8_FTM0OCH6SRC. */
#define BM_SIM_SOPT8_FTM0OCH6SRC (0x00400000U) /*!< Bit mask for SIM_SOPT8_FTM0OCH6SRC. */
#define BS_SIM_SOPT8_FTM0OCH6SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM0OCH6SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM0OCH6SRC field. */
#define BR_SIM_SOPT8_FTM0OCH6SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH6SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM0OCH6SRC. */
#define BF_SIM_SOPT8_FTM0OCH6SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM0OCH6SRC) & BM_SIM_SOPT8_FTM0OCH6SRC)

/*! @brief Set the FTM0OCH6SRC field to a new value. */
#define BW_SIM_SOPT8_FTM0OCH6SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH6SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM0OCH7SRC[23] (RW)
 *
 * Values:
 * - 0 - FTM0_CH7 pin is output of FTM0 channel 7 output
 * - 1 - FTM0_CH7 pin is output of FTM0 channel 7 output, modulated by FTM1
 *     channel 1 output
 */
/*@{*/
#define BP_SIM_SOPT8_FTM0OCH7SRC (23U)     /*!< Bit position for SIM_SOPT8_FTM0OCH7SRC. */
#define BM_SIM_SOPT8_FTM0OCH7SRC (0x00800000U) /*!< Bit mask for SIM_SOPT8_FTM0OCH7SRC. */
#define BS_SIM_SOPT8_FTM0OCH7SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM0OCH7SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM0OCH7SRC field. */
#define BR_SIM_SOPT8_FTM0OCH7SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH7SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM0OCH7SRC. */
#define BF_SIM_SOPT8_FTM0OCH7SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM0OCH7SRC) & BM_SIM_SOPT8_FTM0OCH7SRC)

/*! @brief Set the FTM0OCH7SRC field to a new value. */
#define BW_SIM_SOPT8_FTM0OCH7SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM0OCH7SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM3OCH0SRC[24] (RW)
 *
 * Values:
 * - 0 - FTM3_CH0 pin is output of FTM3 channel 0 output
 * - 1 - FTM3_CH0 pin is output of FTM3 channel 0 output modulated by FTM2
 *     channel 1 output.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM3OCH0SRC (24U)     /*!< Bit position for SIM_SOPT8_FTM3OCH0SRC. */
#define BM_SIM_SOPT8_FTM3OCH0SRC (0x01000000U) /*!< Bit mask for SIM_SOPT8_FTM3OCH0SRC. */
#define BS_SIM_SOPT8_FTM3OCH0SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM3OCH0SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM3OCH0SRC field. */
#define BR_SIM_SOPT8_FTM3OCH0SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH0SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM3OCH0SRC. */
#define BF_SIM_SOPT8_FTM3OCH0SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM3OCH0SRC) & BM_SIM_SOPT8_FTM3OCH0SRC)

/*! @brief Set the FTM3OCH0SRC field to a new value. */
#define BW_SIM_SOPT8_FTM3OCH0SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH0SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM3OCH1SRC[25] (RW)
 *
 * Values:
 * - 0 - FTM3_CH1 pin is output of FTM3 channel 1 output
 * - 1 - FTM3_CH1 pin is output of FTM3 channel 1 output modulated by FTM2
 *     channel 1 output.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM3OCH1SRC (25U)     /*!< Bit position for SIM_SOPT8_FTM3OCH1SRC. */
#define BM_SIM_SOPT8_FTM3OCH1SRC (0x02000000U) /*!< Bit mask for SIM_SOPT8_FTM3OCH1SRC. */
#define BS_SIM_SOPT8_FTM3OCH1SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM3OCH1SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM3OCH1SRC field. */
#define BR_SIM_SOPT8_FTM3OCH1SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH1SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM3OCH1SRC. */
#define BF_SIM_SOPT8_FTM3OCH1SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM3OCH1SRC) & BM_SIM_SOPT8_FTM3OCH1SRC)

/*! @brief Set the FTM3OCH1SRC field to a new value. */
#define BW_SIM_SOPT8_FTM3OCH1SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH1SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM3OCH2SRC[26] (RW)
 *
 * Values:
 * - 0 - FTM3_CH2 pin is output of FTM3 channel 2 output
 * - 1 - FTM3_CH2 pin is output of FTM3 channel 2 output modulated by FTM2
 *     channel 1 output.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM3OCH2SRC (26U)     /*!< Bit position for SIM_SOPT8_FTM3OCH2SRC. */
#define BM_SIM_SOPT8_FTM3OCH2SRC (0x04000000U) /*!< Bit mask for SIM_SOPT8_FTM3OCH2SRC. */
#define BS_SIM_SOPT8_FTM3OCH2SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM3OCH2SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM3OCH2SRC field. */
#define BR_SIM_SOPT8_FTM3OCH2SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH2SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM3OCH2SRC. */
#define BF_SIM_SOPT8_FTM3OCH2SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM3OCH2SRC) & BM_SIM_SOPT8_FTM3OCH2SRC)

/*! @brief Set the FTM3OCH2SRC field to a new value. */
#define BW_SIM_SOPT8_FTM3OCH2SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH2SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM3OCH3SRC[27] (RW)
 *
 * Values:
 * - 0 - FTM3_CH3 pin is output of FTM3 channel 3 output
 * - 1 - FTM3_CH3 pin is output of FTM3 channel 3 output modulated by FTM2
 *     channel 1 output.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM3OCH3SRC (27U)     /*!< Bit position for SIM_SOPT8_FTM3OCH3SRC. */
#define BM_SIM_SOPT8_FTM3OCH3SRC (0x08000000U) /*!< Bit mask for SIM_SOPT8_FTM3OCH3SRC. */
#define BS_SIM_SOPT8_FTM3OCH3SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM3OCH3SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM3OCH3SRC field. */
#define BR_SIM_SOPT8_FTM3OCH3SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH3SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM3OCH3SRC. */
#define BF_SIM_SOPT8_FTM3OCH3SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM3OCH3SRC) & BM_SIM_SOPT8_FTM3OCH3SRC)

/*! @brief Set the FTM3OCH3SRC field to a new value. */
#define BW_SIM_SOPT8_FTM3OCH3SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH3SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM3OCH4SRC[28] (RW)
 *
 * Values:
 * - 0 - FTM3_CH4 pin is output of FTM3 channel 4 output
 * - 1 - FTM3_CH4 pin is output of FTM3 channel 4 output modulated by FTM2
 *     channel 1 output.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM3OCH4SRC (28U)     /*!< Bit position for SIM_SOPT8_FTM3OCH4SRC. */
#define BM_SIM_SOPT8_FTM3OCH4SRC (0x10000000U) /*!< Bit mask for SIM_SOPT8_FTM3OCH4SRC. */
#define BS_SIM_SOPT8_FTM3OCH4SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM3OCH4SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM3OCH4SRC field. */
#define BR_SIM_SOPT8_FTM3OCH4SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH4SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM3OCH4SRC. */
#define BF_SIM_SOPT8_FTM3OCH4SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM3OCH4SRC) & BM_SIM_SOPT8_FTM3OCH4SRC)

/*! @brief Set the FTM3OCH4SRC field to a new value. */
#define BW_SIM_SOPT8_FTM3OCH4SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH4SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM3OCH5SRC[29] (RW)
 *
 * Values:
 * - 0 - FTM3_CH5 pin is output of FTM3 channel 5 output
 * - 1 - FTM3_CH5 pin is output of FTM3 channel 5 output modulated by FTM2
 *     channel 1 output.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM3OCH5SRC (29U)     /*!< Bit position for SIM_SOPT8_FTM3OCH5SRC. */
#define BM_SIM_SOPT8_FTM3OCH5SRC (0x20000000U) /*!< Bit mask for SIM_SOPT8_FTM3OCH5SRC. */
#define BS_SIM_SOPT8_FTM3OCH5SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM3OCH5SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM3OCH5SRC field. */
#define BR_SIM_SOPT8_FTM3OCH5SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH5SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM3OCH5SRC. */
#define BF_SIM_SOPT8_FTM3OCH5SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM3OCH5SRC) & BM_SIM_SOPT8_FTM3OCH5SRC)

/*! @brief Set the FTM3OCH5SRC field to a new value. */
#define BW_SIM_SOPT8_FTM3OCH5SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH5SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM3OCH6SRC[30] (RW)
 *
 * Values:
 * - 0 - FTM3_CH6 pin is output of FTM3 channel 6 output
 * - 1 - FTM3_CH6 pin is output of FTM3 channel 6 output modulated by FTM2
 *     channel 1 output.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM3OCH6SRC (30U)     /*!< Bit position for SIM_SOPT8_FTM3OCH6SRC. */
#define BM_SIM_SOPT8_FTM3OCH6SRC (0x40000000U) /*!< Bit mask for SIM_SOPT8_FTM3OCH6SRC. */
#define BS_SIM_SOPT8_FTM3OCH6SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM3OCH6SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM3OCH6SRC field. */
#define BR_SIM_SOPT8_FTM3OCH6SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH6SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM3OCH6SRC. */
#define BF_SIM_SOPT8_FTM3OCH6SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM3OCH6SRC) & BM_SIM_SOPT8_FTM3OCH6SRC)

/*! @brief Set the FTM3OCH6SRC field to a new value. */
#define BW_SIM_SOPT8_FTM3OCH6SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH6SRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SOPT8, field FTM3OCH7SRC[31] (RW)
 *
 * Values:
 * - 0 - FTM3_CH7 pin is output of FTM3 channel 7 output
 * - 1 - FTM3_CH7 pin is output of FTM3 channel 7 output modulated by FTM2
 *     channel 1 output.
 */
/*@{*/
#define BP_SIM_SOPT8_FTM3OCH7SRC (31U)     /*!< Bit position for SIM_SOPT8_FTM3OCH7SRC. */
#define BM_SIM_SOPT8_FTM3OCH7SRC (0x80000000U) /*!< Bit mask for SIM_SOPT8_FTM3OCH7SRC. */
#define BS_SIM_SOPT8_FTM3OCH7SRC (1U)      /*!< Bit field size in bits for SIM_SOPT8_FTM3OCH7SRC. */

/*! @brief Read current value of the SIM_SOPT8_FTM3OCH7SRC field. */
#define BR_SIM_SOPT8_FTM3OCH7SRC(x) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH7SRC))

/*! @brief Format value for bitfield SIM_SOPT8_FTM3OCH7SRC. */
#define BF_SIM_SOPT8_FTM3OCH7SRC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SOPT8_FTM3OCH7SRC) & BM_SIM_SOPT8_FTM3OCH7SRC)

/*! @brief Set the FTM3OCH7SRC field to a new value. */
#define BW_SIM_SOPT8_FTM3OCH7SRC(x, v) (BITBAND_ACCESS32(HW_SIM_SOPT8_ADDR(x), BP_SIM_SOPT8_FTM3OCH7SRC) = (v))
/*@}*/

/*******************************************************************************
 * HW_SIM_SDID - System Device Identification Register
 ******************************************************************************/

/*!
 * @brief HW_SIM_SDID - System Device Identification Register (RO)
 *
 * Reset value: 0x00000E80U
 */
typedef union _hw_sim_sdid
{
    uint32_t U;
    struct _hw_sim_sdid_bitfields
    {
        uint32_t PINID : 4;            /*!< [3:0] Pincount identification */
        uint32_t FAMID : 3;            /*!< [6:4] Kinetis family identification */
        uint32_t DIEID : 5;            /*!< [11:7] Device Die ID */
        uint32_t REVID : 4;            /*!< [15:12] Device revision number */
        uint32_t RESERVED0 : 4;        /*!< [19:16]  */
        uint32_t SERIESID : 4;         /*!< [23:20] Kinetis Series ID */
        uint32_t SUBFAMID : 4;         /*!< [27:24] Kinetis Sub-Family ID */
        uint32_t FAMILYID : 4;         /*!< [31:28] Kinetis Family ID */
    } B;
} hw_sim_sdid_t;

/*!
 * @name Constants and macros for entire SIM_SDID register
 */
/*@{*/
#define HW_SIM_SDID_ADDR(x)      ((x) + 0x1024U)

#define HW_SIM_SDID(x)           (*(__I hw_sim_sdid_t *) HW_SIM_SDID_ADDR(x))
#define HW_SIM_SDID_RD(x)        (HW_SIM_SDID(x).U)
/*@}*/

/*
 * Constants & macros for individual SIM_SDID bitfields
 */

/*!
 * @name Register SIM_SDID, field PINID[3:0] (RO)
 *
 * Specifies the pincount of the device.
 *
 * Values:
 * - 0000 - Reserved
 * - 0001 - Reserved
 * - 0010 - 32-pin
 * - 0011 - Reserved
 * - 0100 - 48-pin
 * - 0101 - 64-pin
 * - 0110 - 80-pin
 * - 0111 - 81-pin or 121-pin
 * - 1000 - 100-pin
 * - 1001 - 121-pin
 * - 1010 - 144-pin
 * - 1011 - Custom pinout (WLCSP)
 * - 1100 - 169-pin
 * - 1101 - Reserved
 * - 1110 - 256-pin
 * - 1111 - Reserved
 */
/*@{*/
#define BP_SIM_SDID_PINID    (0U)          /*!< Bit position for SIM_SDID_PINID. */
#define BM_SIM_SDID_PINID    (0x0000000FU) /*!< Bit mask for SIM_SDID_PINID. */
#define BS_SIM_SDID_PINID    (4U)          /*!< Bit field size in bits for SIM_SDID_PINID. */

/*! @brief Read current value of the SIM_SDID_PINID field. */
#define BR_SIM_SDID_PINID(x) (HW_SIM_SDID(x).B.PINID)
/*@}*/

/*!
 * @name Register SIM_SDID, field FAMID[6:4] (RO)
 *
 * This field is maintained for compatibility only, but has been superceded by
 * the SERIESID, FAMILYID and SUBFAMID fields in this register.
 *
 * Values:
 * - 000 - K1x Family (without tamper)
 * - 001 - K2x Family (without tamper)
 * - 010 - K3x Family or K1x/K6x Family (with tamper)
 * - 011 - K4x Family or K2x Family (with tamper)
 * - 100 - K6x Family (without tamper)
 * - 101 - K7x Family
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_SIM_SDID_FAMID    (4U)          /*!< Bit position for SIM_SDID_FAMID. */
#define BM_SIM_SDID_FAMID    (0x00000070U) /*!< Bit mask for SIM_SDID_FAMID. */
#define BS_SIM_SDID_FAMID    (3U)          /*!< Bit field size in bits for SIM_SDID_FAMID. */

/*! @brief Read current value of the SIM_SDID_FAMID field. */
#define BR_SIM_SDID_FAMID(x) (HW_SIM_SDID(x).B.FAMID)
/*@}*/

/*!
 * @name Register SIM_SDID, field DIEID[11:7] (RO)
 *
 * Specifies the silicon feature set identication number for the device.
 */
/*@{*/
#define BP_SIM_SDID_DIEID    (7U)          /*!< Bit position for SIM_SDID_DIEID. */
#define BM_SIM_SDID_DIEID    (0x00000F80U) /*!< Bit mask for SIM_SDID_DIEID. */
#define BS_SIM_SDID_DIEID    (5U)          /*!< Bit field size in bits for SIM_SDID_DIEID. */

/*! @brief Read current value of the SIM_SDID_DIEID field. */
#define BR_SIM_SDID_DIEID(x) (HW_SIM_SDID(x).B.DIEID)
/*@}*/

/*!
 * @name Register SIM_SDID, field REVID[15:12] (RO)
 *
 * Specifies the silicon implementation number for the device.
 */
/*@{*/
#define BP_SIM_SDID_REVID    (12U)         /*!< Bit position for SIM_SDID_REVID. */
#define BM_SIM_SDID_REVID    (0x0000F000U) /*!< Bit mask for SIM_SDID_REVID. */
#define BS_SIM_SDID_REVID    (4U)          /*!< Bit field size in bits for SIM_SDID_REVID. */

/*! @brief Read current value of the SIM_SDID_REVID field. */
#define BR_SIM_SDID_REVID(x) (HW_SIM_SDID(x).B.REVID)
/*@}*/

/*!
 * @name Register SIM_SDID, field SERIESID[23:20] (RO)
 *
 * Specifies the Kinetis series of the device.
 *
 * Values:
 * - 0000 - Kinetis K series
 * - 0001 - Kinetis L series
 * - 0101 - Kinetis W series
 * - 0110 - Kinetis V series
 */
/*@{*/
#define BP_SIM_SDID_SERIESID (20U)         /*!< Bit position for SIM_SDID_SERIESID. */
#define BM_SIM_SDID_SERIESID (0x00F00000U) /*!< Bit mask for SIM_SDID_SERIESID. */
#define BS_SIM_SDID_SERIESID (4U)          /*!< Bit field size in bits for SIM_SDID_SERIESID. */

/*! @brief Read current value of the SIM_SDID_SERIESID field. */
#define BR_SIM_SDID_SERIESID(x) (HW_SIM_SDID(x).B.SERIESID)
/*@}*/

/*!
 * @name Register SIM_SDID, field SUBFAMID[27:24] (RO)
 *
 * Specifies the Kinetis sub-family of the device.
 *
 * Values:
 * - 0000 - Kx0 Subfamily
 * - 0001 - Kx1 Subfamily (tamper detect)
 * - 0010 - Kx2 Subfamily
 * - 0011 - Kx3 Subfamily (tamper detect)
 * - 0100 - Kx4 Subfamily
 * - 0101 - Kx5 Subfamily (tamper detect)
 * - 0110 - Kx6 Subfamily
 */
/*@{*/
#define BP_SIM_SDID_SUBFAMID (24U)         /*!< Bit position for SIM_SDID_SUBFAMID. */
#define BM_SIM_SDID_SUBFAMID (0x0F000000U) /*!< Bit mask for SIM_SDID_SUBFAMID. */
#define BS_SIM_SDID_SUBFAMID (4U)          /*!< Bit field size in bits for SIM_SDID_SUBFAMID. */

/*! @brief Read current value of the SIM_SDID_SUBFAMID field. */
#define BR_SIM_SDID_SUBFAMID(x) (HW_SIM_SDID(x).B.SUBFAMID)
/*@}*/

/*!
 * @name Register SIM_SDID, field FAMILYID[31:28] (RO)
 *
 * Specifies the Kinetis family of the device.
 *
 * Values:
 * - 0001 - K1x Family
 * - 0010 - K2x Family
 * - 0011 - K3x Family
 * - 0100 - K4x Family
 * - 0110 - K6x Family
 * - 0111 - K7x Family
 */
/*@{*/
#define BP_SIM_SDID_FAMILYID (28U)         /*!< Bit position for SIM_SDID_FAMILYID. */
#define BM_SIM_SDID_FAMILYID (0xF0000000U) /*!< Bit mask for SIM_SDID_FAMILYID. */
#define BS_SIM_SDID_FAMILYID (4U)          /*!< Bit field size in bits for SIM_SDID_FAMILYID. */

/*! @brief Read current value of the SIM_SDID_FAMILYID field. */
#define BR_SIM_SDID_FAMILYID(x) (HW_SIM_SDID(x).B.FAMILYID)
/*@}*/

/*******************************************************************************
 * HW_SIM_SCGC4 - System Clock Gating Control Register 4
 ******************************************************************************/

/*!
 * @brief HW_SIM_SCGC4 - System Clock Gating Control Register 4 (RW)
 *
 * Reset value: 0xF0100030U
 */
typedef union _hw_sim_scgc4
{
    uint32_t U;
    struct _hw_sim_scgc4_bitfields
    {
        uint32_t RESERVED0 : 1;        /*!< [0]  */
        uint32_t EWMb : 1;             /*!< [1] EWM Clock Gate Control */
        uint32_t RESERVED1 : 4;        /*!< [5:2]  */
        uint32_t I2C0b : 1;            /*!< [6] I2C0 Clock Gate Control */
        uint32_t I2C1b : 1;            /*!< [7] I2C1 Clock Gate Control */
        uint32_t RESERVED2 : 2;        /*!< [9:8]  */
        uint32_t UART0b : 1;           /*!< [10] UART0 Clock Gate Control */
        uint32_t UART1b : 1;           /*!< [11] UART1 Clock Gate Control */
        uint32_t UART2b : 1;           /*!< [12] UART2 Clock Gate Control */
        uint32_t RESERVED3 : 5;        /*!< [17:13]  */
        uint32_t USBOTG : 1;           /*!< [18] USB Clock Gate Control */
        uint32_t CMP : 1;              /*!< [19] Comparator Clock Gate Control */
        uint32_t VREFb : 1;            /*!< [20] VREF Clock Gate Control */
        uint32_t RESERVED4 : 11;       /*!< [31:21]  */
    } B;
} hw_sim_scgc4_t;

/*!
 * @name Constants and macros for entire SIM_SCGC4 register
 */
/*@{*/
#define HW_SIM_SCGC4_ADDR(x)     ((x) + 0x1034U)

#define HW_SIM_SCGC4(x)          (*(__IO hw_sim_scgc4_t *) HW_SIM_SCGC4_ADDR(x))
#define HW_SIM_SCGC4_RD(x)       (HW_SIM_SCGC4(x).U)
#define HW_SIM_SCGC4_WR(x, v)    (HW_SIM_SCGC4(x).U = (v))
#define HW_SIM_SCGC4_SET(x, v)   (HW_SIM_SCGC4_WR(x, HW_SIM_SCGC4_RD(x) |  (v)))
#define HW_SIM_SCGC4_CLR(x, v)   (HW_SIM_SCGC4_WR(x, HW_SIM_SCGC4_RD(x) & ~(v)))
#define HW_SIM_SCGC4_TOG(x, v)   (HW_SIM_SCGC4_WR(x, HW_SIM_SCGC4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_SCGC4 bitfields
 */

/*!
 * @name Register SIM_SCGC4, field EWM[1] (RW)
 *
 * This bit controls the clock gate to the EWM module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC4_EWM     (1U)          /*!< Bit position for SIM_SCGC4_EWM. */
#define BM_SIM_SCGC4_EWM     (0x00000002U) /*!< Bit mask for SIM_SCGC4_EWM. */
#define BS_SIM_SCGC4_EWM     (1U)          /*!< Bit field size in bits for SIM_SCGC4_EWM. */

/*! @brief Read current value of the SIM_SCGC4_EWM field. */
#define BR_SIM_SCGC4_EWM(x)  (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_EWM))

/*! @brief Format value for bitfield SIM_SCGC4_EWM. */
#define BF_SIM_SCGC4_EWM(v)  ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC4_EWM) & BM_SIM_SCGC4_EWM)

/*! @brief Set the EWM field to a new value. */
#define BW_SIM_SCGC4_EWM(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_EWM) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field I2C0[6] (RW)
 *
 * This bit controls the clock gate to the I 2 C0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC4_I2C0    (6U)          /*!< Bit position for SIM_SCGC4_I2C0. */
#define BM_SIM_SCGC4_I2C0    (0x00000040U) /*!< Bit mask for SIM_SCGC4_I2C0. */
#define BS_SIM_SCGC4_I2C0    (1U)          /*!< Bit field size in bits for SIM_SCGC4_I2C0. */

/*! @brief Read current value of the SIM_SCGC4_I2C0 field. */
#define BR_SIM_SCGC4_I2C0(x) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_I2C0))

/*! @brief Format value for bitfield SIM_SCGC4_I2C0. */
#define BF_SIM_SCGC4_I2C0(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC4_I2C0) & BM_SIM_SCGC4_I2C0)

/*! @brief Set the I2C0 field to a new value. */
#define BW_SIM_SCGC4_I2C0(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_I2C0) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field I2C1[7] (RW)
 *
 * This bit controls the clock gate to the I 2 C1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC4_I2C1    (7U)          /*!< Bit position for SIM_SCGC4_I2C1. */
#define BM_SIM_SCGC4_I2C1    (0x00000080U) /*!< Bit mask for SIM_SCGC4_I2C1. */
#define BS_SIM_SCGC4_I2C1    (1U)          /*!< Bit field size in bits for SIM_SCGC4_I2C1. */

/*! @brief Read current value of the SIM_SCGC4_I2C1 field. */
#define BR_SIM_SCGC4_I2C1(x) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_I2C1))

/*! @brief Format value for bitfield SIM_SCGC4_I2C1. */
#define BF_SIM_SCGC4_I2C1(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC4_I2C1) & BM_SIM_SCGC4_I2C1)

/*! @brief Set the I2C1 field to a new value. */
#define BW_SIM_SCGC4_I2C1(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_I2C1) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field UART0[10] (RW)
 *
 * This bit controls the clock gate to the UART0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC4_UART0   (10U)         /*!< Bit position for SIM_SCGC4_UART0. */
#define BM_SIM_SCGC4_UART0   (0x00000400U) /*!< Bit mask for SIM_SCGC4_UART0. */
#define BS_SIM_SCGC4_UART0   (1U)          /*!< Bit field size in bits for SIM_SCGC4_UART0. */

/*! @brief Read current value of the SIM_SCGC4_UART0 field. */
#define BR_SIM_SCGC4_UART0(x) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_UART0))

/*! @brief Format value for bitfield SIM_SCGC4_UART0. */
#define BF_SIM_SCGC4_UART0(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC4_UART0) & BM_SIM_SCGC4_UART0)

/*! @brief Set the UART0 field to a new value. */
#define BW_SIM_SCGC4_UART0(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_UART0) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field UART1[11] (RW)
 *
 * This bit controls the clock gate to the UART1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC4_UART1   (11U)         /*!< Bit position for SIM_SCGC4_UART1. */
#define BM_SIM_SCGC4_UART1   (0x00000800U) /*!< Bit mask for SIM_SCGC4_UART1. */
#define BS_SIM_SCGC4_UART1   (1U)          /*!< Bit field size in bits for SIM_SCGC4_UART1. */

/*! @brief Read current value of the SIM_SCGC4_UART1 field. */
#define BR_SIM_SCGC4_UART1(x) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_UART1))

/*! @brief Format value for bitfield SIM_SCGC4_UART1. */
#define BF_SIM_SCGC4_UART1(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC4_UART1) & BM_SIM_SCGC4_UART1)

/*! @brief Set the UART1 field to a new value. */
#define BW_SIM_SCGC4_UART1(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_UART1) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field UART2[12] (RW)
 *
 * This bit controls the clock gate to the UART2 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC4_UART2   (12U)         /*!< Bit position for SIM_SCGC4_UART2. */
#define BM_SIM_SCGC4_UART2   (0x00001000U) /*!< Bit mask for SIM_SCGC4_UART2. */
#define BS_SIM_SCGC4_UART2   (1U)          /*!< Bit field size in bits for SIM_SCGC4_UART2. */

/*! @brief Read current value of the SIM_SCGC4_UART2 field. */
#define BR_SIM_SCGC4_UART2(x) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_UART2))

/*! @brief Format value for bitfield SIM_SCGC4_UART2. */
#define BF_SIM_SCGC4_UART2(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC4_UART2) & BM_SIM_SCGC4_UART2)

/*! @brief Set the UART2 field to a new value. */
#define BW_SIM_SCGC4_UART2(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_UART2) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field USBOTG[18] (RW)
 *
 * This bit controls the clock gate to the USB module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC4_USBOTG  (18U)         /*!< Bit position for SIM_SCGC4_USBOTG. */
#define BM_SIM_SCGC4_USBOTG  (0x00040000U) /*!< Bit mask for SIM_SCGC4_USBOTG. */
#define BS_SIM_SCGC4_USBOTG  (1U)          /*!< Bit field size in bits for SIM_SCGC4_USBOTG. */

/*! @brief Read current value of the SIM_SCGC4_USBOTG field. */
#define BR_SIM_SCGC4_USBOTG(x) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_USBOTG))

/*! @brief Format value for bitfield SIM_SCGC4_USBOTG. */
#define BF_SIM_SCGC4_USBOTG(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC4_USBOTG) & BM_SIM_SCGC4_USBOTG)

/*! @brief Set the USBOTG field to a new value. */
#define BW_SIM_SCGC4_USBOTG(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_USBOTG) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field CMP[19] (RW)
 *
 * This bit controls the clock gate to the comparator module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC4_CMP     (19U)         /*!< Bit position for SIM_SCGC4_CMP. */
#define BM_SIM_SCGC4_CMP     (0x00080000U) /*!< Bit mask for SIM_SCGC4_CMP. */
#define BS_SIM_SCGC4_CMP     (1U)          /*!< Bit field size in bits for SIM_SCGC4_CMP. */

/*! @brief Read current value of the SIM_SCGC4_CMP field. */
#define BR_SIM_SCGC4_CMP(x)  (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_CMP))

/*! @brief Format value for bitfield SIM_SCGC4_CMP. */
#define BF_SIM_SCGC4_CMP(v)  ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC4_CMP) & BM_SIM_SCGC4_CMP)

/*! @brief Set the CMP field to a new value. */
#define BW_SIM_SCGC4_CMP(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_CMP) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC4, field VREF[20] (RW)
 *
 * This bit controls the clock gate to the VREF module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC4_VREF    (20U)         /*!< Bit position for SIM_SCGC4_VREF. */
#define BM_SIM_SCGC4_VREF    (0x00100000U) /*!< Bit mask for SIM_SCGC4_VREF. */
#define BS_SIM_SCGC4_VREF    (1U)          /*!< Bit field size in bits for SIM_SCGC4_VREF. */

/*! @brief Read current value of the SIM_SCGC4_VREF field. */
#define BR_SIM_SCGC4_VREF(x) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_VREF))

/*! @brief Format value for bitfield SIM_SCGC4_VREF. */
#define BF_SIM_SCGC4_VREF(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC4_VREF) & BM_SIM_SCGC4_VREF)

/*! @brief Set the VREF field to a new value. */
#define BW_SIM_SCGC4_VREF(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR(x), BP_SIM_SCGC4_VREF) = (v))
/*@}*/

/*******************************************************************************
 * HW_SIM_SCGC5 - System Clock Gating Control Register 5
 ******************************************************************************/

/*!
 * @brief HW_SIM_SCGC5 - System Clock Gating Control Register 5 (RW)
 *
 * Reset value: 0x00040182U
 */
typedef union _hw_sim_scgc5
{
    uint32_t U;
    struct _hw_sim_scgc5_bitfields
    {
        uint32_t LPTMR : 1;            /*!< [0] Low Power Timer Access Control */
        uint32_t RESERVED0 : 8;        /*!< [8:1]  */
        uint32_t PORTAb : 1;           /*!< [9] Port A Clock Gate Control */
        uint32_t PORTBb : 1;           /*!< [10] Port B Clock Gate Control */
        uint32_t PORTCb : 1;           /*!< [11] Port C Clock Gate Control */
        uint32_t PORTDb : 1;           /*!< [12] Port D Clock Gate Control */
        uint32_t PORTEb : 1;           /*!< [13] Port E Clock Gate Control */
        uint32_t RESERVED1 : 18;       /*!< [31:14]  */
    } B;
} hw_sim_scgc5_t;

/*!
 * @name Constants and macros for entire SIM_SCGC5 register
 */
/*@{*/
#define HW_SIM_SCGC5_ADDR(x)     ((x) + 0x1038U)

#define HW_SIM_SCGC5(x)          (*(__IO hw_sim_scgc5_t *) HW_SIM_SCGC5_ADDR(x))
#define HW_SIM_SCGC5_RD(x)       (HW_SIM_SCGC5(x).U)
#define HW_SIM_SCGC5_WR(x, v)    (HW_SIM_SCGC5(x).U = (v))
#define HW_SIM_SCGC5_SET(x, v)   (HW_SIM_SCGC5_WR(x, HW_SIM_SCGC5_RD(x) |  (v)))
#define HW_SIM_SCGC5_CLR(x, v)   (HW_SIM_SCGC5_WR(x, HW_SIM_SCGC5_RD(x) & ~(v)))
#define HW_SIM_SCGC5_TOG(x, v)   (HW_SIM_SCGC5_WR(x, HW_SIM_SCGC5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_SCGC5 bitfields
 */

/*!
 * @name Register SIM_SCGC5, field LPTMR[0] (RW)
 *
 * This bit controls software access to the Low Power Timer module.
 *
 * Values:
 * - 0 - Access disabled
 * - 1 - Access enabled
 */
/*@{*/
#define BP_SIM_SCGC5_LPTMR   (0U)          /*!< Bit position for SIM_SCGC5_LPTMR. */
#define BM_SIM_SCGC5_LPTMR   (0x00000001U) /*!< Bit mask for SIM_SCGC5_LPTMR. */
#define BS_SIM_SCGC5_LPTMR   (1U)          /*!< Bit field size in bits for SIM_SCGC5_LPTMR. */

/*! @brief Read current value of the SIM_SCGC5_LPTMR field. */
#define BR_SIM_SCGC5_LPTMR(x) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_LPTMR))

/*! @brief Format value for bitfield SIM_SCGC5_LPTMR. */
#define BF_SIM_SCGC5_LPTMR(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC5_LPTMR) & BM_SIM_SCGC5_LPTMR)

/*! @brief Set the LPTMR field to a new value. */
#define BW_SIM_SCGC5_LPTMR(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_LPTMR) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field PORTA[9] (RW)
 *
 * This bit controls the clock gate to the Port A module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC5_PORTA   (9U)          /*!< Bit position for SIM_SCGC5_PORTA. */
#define BM_SIM_SCGC5_PORTA   (0x00000200U) /*!< Bit mask for SIM_SCGC5_PORTA. */
#define BS_SIM_SCGC5_PORTA   (1U)          /*!< Bit field size in bits for SIM_SCGC5_PORTA. */

/*! @brief Read current value of the SIM_SCGC5_PORTA field. */
#define BR_SIM_SCGC5_PORTA(x) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_PORTA))

/*! @brief Format value for bitfield SIM_SCGC5_PORTA. */
#define BF_SIM_SCGC5_PORTA(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC5_PORTA) & BM_SIM_SCGC5_PORTA)

/*! @brief Set the PORTA field to a new value. */
#define BW_SIM_SCGC5_PORTA(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_PORTA) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field PORTB[10] (RW)
 *
 * This bit controls the clock gate to the Port B module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC5_PORTB   (10U)         /*!< Bit position for SIM_SCGC5_PORTB. */
#define BM_SIM_SCGC5_PORTB   (0x00000400U) /*!< Bit mask for SIM_SCGC5_PORTB. */
#define BS_SIM_SCGC5_PORTB   (1U)          /*!< Bit field size in bits for SIM_SCGC5_PORTB. */

/*! @brief Read current value of the SIM_SCGC5_PORTB field. */
#define BR_SIM_SCGC5_PORTB(x) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_PORTB))

/*! @brief Format value for bitfield SIM_SCGC5_PORTB. */
#define BF_SIM_SCGC5_PORTB(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC5_PORTB) & BM_SIM_SCGC5_PORTB)

/*! @brief Set the PORTB field to a new value. */
#define BW_SIM_SCGC5_PORTB(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_PORTB) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field PORTC[11] (RW)
 *
 * This bit controls the clock gate to the Port C module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC5_PORTC   (11U)         /*!< Bit position for SIM_SCGC5_PORTC. */
#define BM_SIM_SCGC5_PORTC   (0x00000800U) /*!< Bit mask for SIM_SCGC5_PORTC. */
#define BS_SIM_SCGC5_PORTC   (1U)          /*!< Bit field size in bits for SIM_SCGC5_PORTC. */

/*! @brief Read current value of the SIM_SCGC5_PORTC field. */
#define BR_SIM_SCGC5_PORTC(x) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_PORTC))

/*! @brief Format value for bitfield SIM_SCGC5_PORTC. */
#define BF_SIM_SCGC5_PORTC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC5_PORTC) & BM_SIM_SCGC5_PORTC)

/*! @brief Set the PORTC field to a new value. */
#define BW_SIM_SCGC5_PORTC(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_PORTC) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field PORTD[12] (RW)
 *
 * This bit controls the clock gate to the Port D module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC5_PORTD   (12U)         /*!< Bit position for SIM_SCGC5_PORTD. */
#define BM_SIM_SCGC5_PORTD   (0x00001000U) /*!< Bit mask for SIM_SCGC5_PORTD. */
#define BS_SIM_SCGC5_PORTD   (1U)          /*!< Bit field size in bits for SIM_SCGC5_PORTD. */

/*! @brief Read current value of the SIM_SCGC5_PORTD field. */
#define BR_SIM_SCGC5_PORTD(x) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_PORTD))

/*! @brief Format value for bitfield SIM_SCGC5_PORTD. */
#define BF_SIM_SCGC5_PORTD(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC5_PORTD) & BM_SIM_SCGC5_PORTD)

/*! @brief Set the PORTD field to a new value. */
#define BW_SIM_SCGC5_PORTD(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_PORTD) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC5, field PORTE[13] (RW)
 *
 * This bit controls the clock gate to the Port E module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC5_PORTE   (13U)         /*!< Bit position for SIM_SCGC5_PORTE. */
#define BM_SIM_SCGC5_PORTE   (0x00002000U) /*!< Bit mask for SIM_SCGC5_PORTE. */
#define BS_SIM_SCGC5_PORTE   (1U)          /*!< Bit field size in bits for SIM_SCGC5_PORTE. */

/*! @brief Read current value of the SIM_SCGC5_PORTE field. */
#define BR_SIM_SCGC5_PORTE(x) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_PORTE))

/*! @brief Format value for bitfield SIM_SCGC5_PORTE. */
#define BF_SIM_SCGC5_PORTE(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC5_PORTE) & BM_SIM_SCGC5_PORTE)

/*! @brief Set the PORTE field to a new value. */
#define BW_SIM_SCGC5_PORTE(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR(x), BP_SIM_SCGC5_PORTE) = (v))
/*@}*/

/*******************************************************************************
 * HW_SIM_SCGC6 - System Clock Gating Control Register 6
 ******************************************************************************/

/*!
 * @brief HW_SIM_SCGC6 - System Clock Gating Control Register 6 (RW)
 *
 * Reset value: 0x40000001U
 */
typedef union _hw_sim_scgc6
{
    uint32_t U;
    struct _hw_sim_scgc6_bitfields
    {
        uint32_t FTF : 1;              /*!< [0] Flash Memory Clock Gate Control */
        uint32_t DMAMUXb : 1;          /*!< [1] DMA Mux Clock Gate Control */
        uint32_t RESERVED0 : 4;        /*!< [5:2]  */
        uint32_t FTM3b : 1;            /*!< [6] FTM3 Clock Gate Control */
        uint32_t ADC1b : 1;            /*!< [7] ADC1 Clock Gate Control */
        uint32_t DAC1b : 1;            /*!< [8] DAC1 Clock Gate Control */
        uint32_t RNGA : 1;             /*!< [9] RNGA Clock Gate Control */
        uint32_t LPUART0b : 1;         /*!< [10] LPUART0 Clock Gate Control */
        uint32_t RESERVED1 : 1;        /*!< [11]  */
        uint32_t SPI0b : 1;            /*!< [12] SPI0 Clock Gate Control */
        uint32_t SPI1b : 1;            /*!< [13] SPI1 Clock Gate Control */
        uint32_t RESERVED2 : 1;        /*!< [14]  */
        uint32_t I2S : 1;              /*!< [15] I2S Clock Gate Control */
        uint32_t RESERVED3 : 2;        /*!< [17:16]  */
        uint32_t CRC : 1;              /*!< [18] CRC Clock Gate Control */
        uint32_t RESERVED4 : 3;        /*!< [21:19]  */
        uint32_t PDB : 1;              /*!< [22] PDB Clock Gate Control */
        uint32_t PITb : 1;             /*!< [23] PIT Clock Gate Control */
        uint32_t FTM0b : 1;            /*!< [24] FTM0 Clock Gate Control */
        uint32_t FTM1b : 1;            /*!< [25] FTM1 Clock Gate Control */
        uint32_t FTM2b : 1;            /*!< [26] FTM2 Clock Gate Control */
        uint32_t ADC0b : 1;            /*!< [27] ADC0 Clock Gate Control */
        uint32_t RESERVED5 : 1;        /*!< [28]  */
        uint32_t RTCb : 1;             /*!< [29] RTC Access Control */
        uint32_t RESERVED6 : 1;        /*!< [30]  */
        uint32_t DAC0b : 1;            /*!< [31] DAC0 Clock Gate Control */
    } B;
} hw_sim_scgc6_t;

/*!
 * @name Constants and macros for entire SIM_SCGC6 register
 */
/*@{*/
#define HW_SIM_SCGC6_ADDR(x)     ((x) + 0x103CU)

#define HW_SIM_SCGC6(x)          (*(__IO hw_sim_scgc6_t *) HW_SIM_SCGC6_ADDR(x))
#define HW_SIM_SCGC6_RD(x)       (HW_SIM_SCGC6(x).U)
#define HW_SIM_SCGC6_WR(x, v)    (HW_SIM_SCGC6(x).U = (v))
#define HW_SIM_SCGC6_SET(x, v)   (HW_SIM_SCGC6_WR(x, HW_SIM_SCGC6_RD(x) |  (v)))
#define HW_SIM_SCGC6_CLR(x, v)   (HW_SIM_SCGC6_WR(x, HW_SIM_SCGC6_RD(x) & ~(v)))
#define HW_SIM_SCGC6_TOG(x, v)   (HW_SIM_SCGC6_WR(x, HW_SIM_SCGC6_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_SCGC6 bitfields
 */

/*!
 * @name Register SIM_SCGC6, field FTF[0] (RW)
 *
 * This bit controls the clock gate to the flash memory. Flash reads are still
 * supported while the flash memory is clock gated, but entry into low power modes
 * and HSRUN mode is blocked.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_FTF     (0U)          /*!< Bit position for SIM_SCGC6_FTF. */
#define BM_SIM_SCGC6_FTF     (0x00000001U) /*!< Bit mask for SIM_SCGC6_FTF. */
#define BS_SIM_SCGC6_FTF     (1U)          /*!< Bit field size in bits for SIM_SCGC6_FTF. */

/*! @brief Read current value of the SIM_SCGC6_FTF field. */
#define BR_SIM_SCGC6_FTF(x)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_FTF))

/*! @brief Format value for bitfield SIM_SCGC6_FTF. */
#define BF_SIM_SCGC6_FTF(v)  ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_FTF) & BM_SIM_SCGC6_FTF)

/*! @brief Set the FTF field to a new value. */
#define BW_SIM_SCGC6_FTF(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_FTF) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field DMAMUX[1] (RW)
 *
 * This bit controls the clock gate to the DMA Mux module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_DMAMUX  (1U)          /*!< Bit position for SIM_SCGC6_DMAMUX. */
#define BM_SIM_SCGC6_DMAMUX  (0x00000002U) /*!< Bit mask for SIM_SCGC6_DMAMUX. */
#define BS_SIM_SCGC6_DMAMUX  (1U)          /*!< Bit field size in bits for SIM_SCGC6_DMAMUX. */

/*! @brief Read current value of the SIM_SCGC6_DMAMUX field. */
#define BR_SIM_SCGC6_DMAMUX(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_DMAMUX))

/*! @brief Format value for bitfield SIM_SCGC6_DMAMUX. */
#define BF_SIM_SCGC6_DMAMUX(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_DMAMUX) & BM_SIM_SCGC6_DMAMUX)

/*! @brief Set the DMAMUX field to a new value. */
#define BW_SIM_SCGC6_DMAMUX(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_DMAMUX) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field FTM3[6] (RW)
 *
 * This bit controls the clock gate to the FTM3 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_FTM3    (6U)          /*!< Bit position for SIM_SCGC6_FTM3. */
#define BM_SIM_SCGC6_FTM3    (0x00000040U) /*!< Bit mask for SIM_SCGC6_FTM3. */
#define BS_SIM_SCGC6_FTM3    (1U)          /*!< Bit field size in bits for SIM_SCGC6_FTM3. */

/*! @brief Read current value of the SIM_SCGC6_FTM3 field. */
#define BR_SIM_SCGC6_FTM3(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_FTM3))

/*! @brief Format value for bitfield SIM_SCGC6_FTM3. */
#define BF_SIM_SCGC6_FTM3(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_FTM3) & BM_SIM_SCGC6_FTM3)

/*! @brief Set the FTM3 field to a new value. */
#define BW_SIM_SCGC6_FTM3(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_FTM3) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field ADC1[7] (RW)
 *
 * This bit controls the clock gate to the ADC1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_ADC1    (7U)          /*!< Bit position for SIM_SCGC6_ADC1. */
#define BM_SIM_SCGC6_ADC1    (0x00000080U) /*!< Bit mask for SIM_SCGC6_ADC1. */
#define BS_SIM_SCGC6_ADC1    (1U)          /*!< Bit field size in bits for SIM_SCGC6_ADC1. */

/*! @brief Read current value of the SIM_SCGC6_ADC1 field. */
#define BR_SIM_SCGC6_ADC1(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_ADC1))

/*! @brief Format value for bitfield SIM_SCGC6_ADC1. */
#define BF_SIM_SCGC6_ADC1(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_ADC1) & BM_SIM_SCGC6_ADC1)

/*! @brief Set the ADC1 field to a new value. */
#define BW_SIM_SCGC6_ADC1(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_ADC1) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field DAC1[8] (RW)
 *
 * This bit controls the clock gate to the DAC1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_DAC1    (8U)          /*!< Bit position for SIM_SCGC6_DAC1. */
#define BM_SIM_SCGC6_DAC1    (0x00000100U) /*!< Bit mask for SIM_SCGC6_DAC1. */
#define BS_SIM_SCGC6_DAC1    (1U)          /*!< Bit field size in bits for SIM_SCGC6_DAC1. */

/*! @brief Read current value of the SIM_SCGC6_DAC1 field. */
#define BR_SIM_SCGC6_DAC1(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_DAC1))

/*! @brief Format value for bitfield SIM_SCGC6_DAC1. */
#define BF_SIM_SCGC6_DAC1(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_DAC1) & BM_SIM_SCGC6_DAC1)

/*! @brief Set the DAC1 field to a new value. */
#define BW_SIM_SCGC6_DAC1(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_DAC1) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field RNGA[9] (RW)
 *
 * This bit controls the clock gate to the RNGA module.
 */
/*@{*/
#define BP_SIM_SCGC6_RNGA    (9U)          /*!< Bit position for SIM_SCGC6_RNGA. */
#define BM_SIM_SCGC6_RNGA    (0x00000200U) /*!< Bit mask for SIM_SCGC6_RNGA. */
#define BS_SIM_SCGC6_RNGA    (1U)          /*!< Bit field size in bits for SIM_SCGC6_RNGA. */

/*! @brief Read current value of the SIM_SCGC6_RNGA field. */
#define BR_SIM_SCGC6_RNGA(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_RNGA))

/*! @brief Format value for bitfield SIM_SCGC6_RNGA. */
#define BF_SIM_SCGC6_RNGA(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_RNGA) & BM_SIM_SCGC6_RNGA)

/*! @brief Set the RNGA field to a new value. */
#define BW_SIM_SCGC6_RNGA(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_RNGA) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field LPUART0[10] (RW)
 *
 * This bit controls the clock gate to the LPUART0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_LPUART0 (10U)         /*!< Bit position for SIM_SCGC6_LPUART0. */
#define BM_SIM_SCGC6_LPUART0 (0x00000400U) /*!< Bit mask for SIM_SCGC6_LPUART0. */
#define BS_SIM_SCGC6_LPUART0 (1U)          /*!< Bit field size in bits for SIM_SCGC6_LPUART0. */

/*! @brief Read current value of the SIM_SCGC6_LPUART0 field. */
#define BR_SIM_SCGC6_LPUART0(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_LPUART0))

/*! @brief Format value for bitfield SIM_SCGC6_LPUART0. */
#define BF_SIM_SCGC6_LPUART0(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_LPUART0) & BM_SIM_SCGC6_LPUART0)

/*! @brief Set the LPUART0 field to a new value. */
#define BW_SIM_SCGC6_LPUART0(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_LPUART0) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field SPI0[12] (RW)
 *
 * This bit controls the clock gate to the SPI0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_SPI0    (12U)         /*!< Bit position for SIM_SCGC6_SPI0. */
#define BM_SIM_SCGC6_SPI0    (0x00001000U) /*!< Bit mask for SIM_SCGC6_SPI0. */
#define BS_SIM_SCGC6_SPI0    (1U)          /*!< Bit field size in bits for SIM_SCGC6_SPI0. */

/*! @brief Read current value of the SIM_SCGC6_SPI0 field. */
#define BR_SIM_SCGC6_SPI0(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_SPI0))

/*! @brief Format value for bitfield SIM_SCGC6_SPI0. */
#define BF_SIM_SCGC6_SPI0(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_SPI0) & BM_SIM_SCGC6_SPI0)

/*! @brief Set the SPI0 field to a new value. */
#define BW_SIM_SCGC6_SPI0(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_SPI0) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field SPI1[13] (RW)
 *
 * This bit controls the clock gate to the SPI1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_SPI1    (13U)         /*!< Bit position for SIM_SCGC6_SPI1. */
#define BM_SIM_SCGC6_SPI1    (0x00002000U) /*!< Bit mask for SIM_SCGC6_SPI1. */
#define BS_SIM_SCGC6_SPI1    (1U)          /*!< Bit field size in bits for SIM_SCGC6_SPI1. */

/*! @brief Read current value of the SIM_SCGC6_SPI1 field. */
#define BR_SIM_SCGC6_SPI1(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_SPI1))

/*! @brief Format value for bitfield SIM_SCGC6_SPI1. */
#define BF_SIM_SCGC6_SPI1(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_SPI1) & BM_SIM_SCGC6_SPI1)

/*! @brief Set the SPI1 field to a new value. */
#define BW_SIM_SCGC6_SPI1(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_SPI1) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field I2S[15] (RW)
 *
 * This bit controls the clock gate to the I 2 S module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_I2S     (15U)         /*!< Bit position for SIM_SCGC6_I2S. */
#define BM_SIM_SCGC6_I2S     (0x00008000U) /*!< Bit mask for SIM_SCGC6_I2S. */
#define BS_SIM_SCGC6_I2S     (1U)          /*!< Bit field size in bits for SIM_SCGC6_I2S. */

/*! @brief Read current value of the SIM_SCGC6_I2S field. */
#define BR_SIM_SCGC6_I2S(x)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_I2S))

/*! @brief Format value for bitfield SIM_SCGC6_I2S. */
#define BF_SIM_SCGC6_I2S(v)  ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_I2S) & BM_SIM_SCGC6_I2S)

/*! @brief Set the I2S field to a new value. */
#define BW_SIM_SCGC6_I2S(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_I2S) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field CRC[18] (RW)
 *
 * This bit controls the clock gate to the CRC module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_CRC     (18U)         /*!< Bit position for SIM_SCGC6_CRC. */
#define BM_SIM_SCGC6_CRC     (0x00040000U) /*!< Bit mask for SIM_SCGC6_CRC. */
#define BS_SIM_SCGC6_CRC     (1U)          /*!< Bit field size in bits for SIM_SCGC6_CRC. */

/*! @brief Read current value of the SIM_SCGC6_CRC field. */
#define BR_SIM_SCGC6_CRC(x)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_CRC))

/*! @brief Format value for bitfield SIM_SCGC6_CRC. */
#define BF_SIM_SCGC6_CRC(v)  ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_CRC) & BM_SIM_SCGC6_CRC)

/*! @brief Set the CRC field to a new value. */
#define BW_SIM_SCGC6_CRC(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_CRC) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field PDB[22] (RW)
 *
 * This bit controls the clock gate to the PDB module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_PDB     (22U)         /*!< Bit position for SIM_SCGC6_PDB. */
#define BM_SIM_SCGC6_PDB     (0x00400000U) /*!< Bit mask for SIM_SCGC6_PDB. */
#define BS_SIM_SCGC6_PDB     (1U)          /*!< Bit field size in bits for SIM_SCGC6_PDB. */

/*! @brief Read current value of the SIM_SCGC6_PDB field. */
#define BR_SIM_SCGC6_PDB(x)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_PDB))

/*! @brief Format value for bitfield SIM_SCGC6_PDB. */
#define BF_SIM_SCGC6_PDB(v)  ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_PDB) & BM_SIM_SCGC6_PDB)

/*! @brief Set the PDB field to a new value. */
#define BW_SIM_SCGC6_PDB(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_PDB) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field PIT[23] (RW)
 *
 * This bit controls the clock gate to the PIT module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_PIT     (23U)         /*!< Bit position for SIM_SCGC6_PIT. */
#define BM_SIM_SCGC6_PIT     (0x00800000U) /*!< Bit mask for SIM_SCGC6_PIT. */
#define BS_SIM_SCGC6_PIT     (1U)          /*!< Bit field size in bits for SIM_SCGC6_PIT. */

/*! @brief Read current value of the SIM_SCGC6_PIT field. */
#define BR_SIM_SCGC6_PIT(x)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_PIT))

/*! @brief Format value for bitfield SIM_SCGC6_PIT. */
#define BF_SIM_SCGC6_PIT(v)  ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_PIT) & BM_SIM_SCGC6_PIT)

/*! @brief Set the PIT field to a new value. */
#define BW_SIM_SCGC6_PIT(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_PIT) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field FTM0[24] (RW)
 *
 * This bit controls the clock gate to the FTM0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_FTM0    (24U)         /*!< Bit position for SIM_SCGC6_FTM0. */
#define BM_SIM_SCGC6_FTM0    (0x01000000U) /*!< Bit mask for SIM_SCGC6_FTM0. */
#define BS_SIM_SCGC6_FTM0    (1U)          /*!< Bit field size in bits for SIM_SCGC6_FTM0. */

/*! @brief Read current value of the SIM_SCGC6_FTM0 field. */
#define BR_SIM_SCGC6_FTM0(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_FTM0))

/*! @brief Format value for bitfield SIM_SCGC6_FTM0. */
#define BF_SIM_SCGC6_FTM0(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_FTM0) & BM_SIM_SCGC6_FTM0)

/*! @brief Set the FTM0 field to a new value. */
#define BW_SIM_SCGC6_FTM0(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_FTM0) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field FTM1[25] (RW)
 *
 * This bit controls the clock gate to the FTM1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_FTM1    (25U)         /*!< Bit position for SIM_SCGC6_FTM1. */
#define BM_SIM_SCGC6_FTM1    (0x02000000U) /*!< Bit mask for SIM_SCGC6_FTM1. */
#define BS_SIM_SCGC6_FTM1    (1U)          /*!< Bit field size in bits for SIM_SCGC6_FTM1. */

/*! @brief Read current value of the SIM_SCGC6_FTM1 field. */
#define BR_SIM_SCGC6_FTM1(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_FTM1))

/*! @brief Format value for bitfield SIM_SCGC6_FTM1. */
#define BF_SIM_SCGC6_FTM1(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_FTM1) & BM_SIM_SCGC6_FTM1)

/*! @brief Set the FTM1 field to a new value. */
#define BW_SIM_SCGC6_FTM1(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_FTM1) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field FTM2[26] (RW)
 *
 * This bit controls the clock gate to the FTM2 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_FTM2    (26U)         /*!< Bit position for SIM_SCGC6_FTM2. */
#define BM_SIM_SCGC6_FTM2    (0x04000000U) /*!< Bit mask for SIM_SCGC6_FTM2. */
#define BS_SIM_SCGC6_FTM2    (1U)          /*!< Bit field size in bits for SIM_SCGC6_FTM2. */

/*! @brief Read current value of the SIM_SCGC6_FTM2 field. */
#define BR_SIM_SCGC6_FTM2(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_FTM2))

/*! @brief Format value for bitfield SIM_SCGC6_FTM2. */
#define BF_SIM_SCGC6_FTM2(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_FTM2) & BM_SIM_SCGC6_FTM2)

/*! @brief Set the FTM2 field to a new value. */
#define BW_SIM_SCGC6_FTM2(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_FTM2) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field ADC0[27] (RW)
 *
 * This bit controls the clock gate to the ADC0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_ADC0    (27U)         /*!< Bit position for SIM_SCGC6_ADC0. */
#define BM_SIM_SCGC6_ADC0    (0x08000000U) /*!< Bit mask for SIM_SCGC6_ADC0. */
#define BS_SIM_SCGC6_ADC0    (1U)          /*!< Bit field size in bits for SIM_SCGC6_ADC0. */

/*! @brief Read current value of the SIM_SCGC6_ADC0 field. */
#define BR_SIM_SCGC6_ADC0(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_ADC0))

/*! @brief Format value for bitfield SIM_SCGC6_ADC0. */
#define BF_SIM_SCGC6_ADC0(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_ADC0) & BM_SIM_SCGC6_ADC0)

/*! @brief Set the ADC0 field to a new value. */
#define BW_SIM_SCGC6_ADC0(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_ADC0) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field RTC[29] (RW)
 *
 * This bit controls software access and interrupts to the RTC module.
 *
 * Values:
 * - 0 - Access and interrupts disabled
 * - 1 - Access and interrupts enabled
 */
/*@{*/
#define BP_SIM_SCGC6_RTC     (29U)         /*!< Bit position for SIM_SCGC6_RTC. */
#define BM_SIM_SCGC6_RTC     (0x20000000U) /*!< Bit mask for SIM_SCGC6_RTC. */
#define BS_SIM_SCGC6_RTC     (1U)          /*!< Bit field size in bits for SIM_SCGC6_RTC. */

/*! @brief Read current value of the SIM_SCGC6_RTC field. */
#define BR_SIM_SCGC6_RTC(x)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_RTC))

/*! @brief Format value for bitfield SIM_SCGC6_RTC. */
#define BF_SIM_SCGC6_RTC(v)  ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_RTC) & BM_SIM_SCGC6_RTC)

/*! @brief Set the RTC field to a new value. */
#define BW_SIM_SCGC6_RTC(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_RTC) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC6, field DAC0[31] (RW)
 *
 * This bit controls the clock gate to the DAC0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC6_DAC0    (31U)         /*!< Bit position for SIM_SCGC6_DAC0. */
#define BM_SIM_SCGC6_DAC0    (0x80000000U) /*!< Bit mask for SIM_SCGC6_DAC0. */
#define BS_SIM_SCGC6_DAC0    (1U)          /*!< Bit field size in bits for SIM_SCGC6_DAC0. */

/*! @brief Read current value of the SIM_SCGC6_DAC0 field. */
#define BR_SIM_SCGC6_DAC0(x) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_DAC0))

/*! @brief Format value for bitfield SIM_SCGC6_DAC0. */
#define BF_SIM_SCGC6_DAC0(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC6_DAC0) & BM_SIM_SCGC6_DAC0)

/*! @brief Set the DAC0 field to a new value. */
#define BW_SIM_SCGC6_DAC0(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR(x), BP_SIM_SCGC6_DAC0) = (v))
/*@}*/

/*******************************************************************************
 * HW_SIM_SCGC7 - System Clock Gating Control Register 7
 ******************************************************************************/

/*!
 * @brief HW_SIM_SCGC7 - System Clock Gating Control Register 7 (RW)
 *
 * Reset value: 0x00000002U
 */
typedef union _hw_sim_scgc7
{
    uint32_t U;
    struct _hw_sim_scgc7_bitfields
    {
        uint32_t FLEXBUS : 1;          /*!< [0] FlexBus Clock Gate Control */
        uint32_t DMA : 1;              /*!< [1] DMA Clock Gate Control */
        uint32_t RESERVED0 : 30;       /*!< [31:2]  */
    } B;
} hw_sim_scgc7_t;

/*!
 * @name Constants and macros for entire SIM_SCGC7 register
 */
/*@{*/
#define HW_SIM_SCGC7_ADDR(x)     ((x) + 0x1040U)

#define HW_SIM_SCGC7(x)          (*(__IO hw_sim_scgc7_t *) HW_SIM_SCGC7_ADDR(x))
#define HW_SIM_SCGC7_RD(x)       (HW_SIM_SCGC7(x).U)
#define HW_SIM_SCGC7_WR(x, v)    (HW_SIM_SCGC7(x).U = (v))
#define HW_SIM_SCGC7_SET(x, v)   (HW_SIM_SCGC7_WR(x, HW_SIM_SCGC7_RD(x) |  (v)))
#define HW_SIM_SCGC7_CLR(x, v)   (HW_SIM_SCGC7_WR(x, HW_SIM_SCGC7_RD(x) & ~(v)))
#define HW_SIM_SCGC7_TOG(x, v)   (HW_SIM_SCGC7_WR(x, HW_SIM_SCGC7_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_SCGC7 bitfields
 */

/*!
 * @name Register SIM_SCGC7, field FLEXBUS[0] (RW)
 *
 * This bit controls the clock gate to the FlexBus module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC7_FLEXBUS (0U)          /*!< Bit position for SIM_SCGC7_FLEXBUS. */
#define BM_SIM_SCGC7_FLEXBUS (0x00000001U) /*!< Bit mask for SIM_SCGC7_FLEXBUS. */
#define BS_SIM_SCGC7_FLEXBUS (1U)          /*!< Bit field size in bits for SIM_SCGC7_FLEXBUS. */

/*! @brief Read current value of the SIM_SCGC7_FLEXBUS field. */
#define BR_SIM_SCGC7_FLEXBUS(x) (BITBAND_ACCESS32(HW_SIM_SCGC7_ADDR(x), BP_SIM_SCGC7_FLEXBUS))

/*! @brief Format value for bitfield SIM_SCGC7_FLEXBUS. */
#define BF_SIM_SCGC7_FLEXBUS(v) ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC7_FLEXBUS) & BM_SIM_SCGC7_FLEXBUS)

/*! @brief Set the FLEXBUS field to a new value. */
#define BW_SIM_SCGC7_FLEXBUS(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC7_ADDR(x), BP_SIM_SCGC7_FLEXBUS) = (v))
/*@}*/

/*!
 * @name Register SIM_SCGC7, field DMA[1] (RW)
 *
 * This bit controls the clock gate to the DMA module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
/*@{*/
#define BP_SIM_SCGC7_DMA     (1U)          /*!< Bit position for SIM_SCGC7_DMA. */
#define BM_SIM_SCGC7_DMA     (0x00000002U) /*!< Bit mask for SIM_SCGC7_DMA. */
#define BS_SIM_SCGC7_DMA     (1U)          /*!< Bit field size in bits for SIM_SCGC7_DMA. */

/*! @brief Read current value of the SIM_SCGC7_DMA field. */
#define BR_SIM_SCGC7_DMA(x)  (BITBAND_ACCESS32(HW_SIM_SCGC7_ADDR(x), BP_SIM_SCGC7_DMA))

/*! @brief Format value for bitfield SIM_SCGC7_DMA. */
#define BF_SIM_SCGC7_DMA(v)  ((uint32_t)((uint32_t)(v) << BP_SIM_SCGC7_DMA) & BM_SIM_SCGC7_DMA)

/*! @brief Set the DMA field to a new value. */
#define BW_SIM_SCGC7_DMA(x, v) (BITBAND_ACCESS32(HW_SIM_SCGC7_ADDR(x), BP_SIM_SCGC7_DMA) = (v))
/*@}*/

/*******************************************************************************
 * HW_SIM_CLKDIV1 - System Clock Divider Register 1
 ******************************************************************************/

/*!
 * @brief HW_SIM_CLKDIV1 - System Clock Divider Register 1 (RW)
 *
 * Reset value: 0x00010000U
 *
 * When updating CLKDIV1, update all fields using the one write command.
 * Attempting to write an invalid clock ratio to the CLKDIV1 register will cause the
 * write to be ignored. The maximum divide ratio that can be programmed between
 * core/system clock and the other divided clocks is divide by 8. When OUTDIV1 equals
 * 0000 (divide by 1), the other dividers cannot be set higher than 0111 (divide
 * by 8). The CLKDIV1 register cannot be written to when the device is in VLPR
 * mode.
 */
typedef union _hw_sim_clkdiv1
{
    uint32_t U;
    struct _hw_sim_clkdiv1_bitfields
    {
        uint32_t RESERVED0 : 16;       /*!< [15:0]  */
        uint32_t OUTDIV4 : 4;          /*!< [19:16] Clock 4 output divider value */
        uint32_t OUTDIV3 : 4;          /*!< [23:20] Clock 3 output divider value */
        uint32_t OUTDIV2 : 4;          /*!< [27:24] Clock 2 output divider value */
        uint32_t OUTDIV1 : 4;          /*!< [31:28] Clock 1 output divider value */
    } B;
} hw_sim_clkdiv1_t;

/*!
 * @name Constants and macros for entire SIM_CLKDIV1 register
 */
/*@{*/
#define HW_SIM_CLKDIV1_ADDR(x)   ((x) + 0x1044U)

#define HW_SIM_CLKDIV1(x)        (*(__IO hw_sim_clkdiv1_t *) HW_SIM_CLKDIV1_ADDR(x))
#define HW_SIM_CLKDIV1_RD(x)     (HW_SIM_CLKDIV1(x).U)
#define HW_SIM_CLKDIV1_WR(x, v)  (HW_SIM_CLKDIV1(x).U = (v))
#define HW_SIM_CLKDIV1_SET(x, v) (HW_SIM_CLKDIV1_WR(x, HW_SIM_CLKDIV1_RD(x) |  (v)))
#define HW_SIM_CLKDIV1_CLR(x, v) (HW_SIM_CLKDIV1_WR(x, HW_SIM_CLKDIV1_RD(x) & ~(v)))
#define HW_SIM_CLKDIV1_TOG(x, v) (HW_SIM_CLKDIV1_WR(x, HW_SIM_CLKDIV1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_CLKDIV1 bitfields
 */

/*!
 * @name Register SIM_CLKDIV1, field OUTDIV4[19:16] (RW)
 *
 * This field sets the divide value for the flash clock from MCGOUTCLK. At the
 * end of reset, it is loaded with either 0001 or 1111 depending on
 * FTF_FOPT[LPBOOT]. The flash clock frequency must be an integer divide of the system clock
 * frequency.
 *
 * Values:
 * - 0000 - Divide-by-1.
 * - 0001 - Divide-by-2.
 * - 0010 - Divide-by-3.
 * - 0011 - Divide-by-4.
 * - 0100 - Divide-by-5.
 * - 0101 - Divide-by-6.
 * - 0110 - Divide-by-7.
 * - 0111 - Divide-by-8.
 * - 1000 - Divide-by-9.
 * - 1001 - Divide-by-10.
 * - 1010 - Divide-by-11.
 * - 1011 - Divide-by-12.
 * - 1100 - Divide-by-13.
 * - 1101 - Divide-by-14.
 * - 1110 - Divide-by-15.
 * - 1111 - Divide-by-16.
 */
/*@{*/
#define BP_SIM_CLKDIV1_OUTDIV4 (16U)       /*!< Bit position for SIM_CLKDIV1_OUTDIV4. */
#define BM_SIM_CLKDIV1_OUTDIV4 (0x000F0000U) /*!< Bit mask for SIM_CLKDIV1_OUTDIV4. */
#define BS_SIM_CLKDIV1_OUTDIV4 (4U)        /*!< Bit field size in bits for SIM_CLKDIV1_OUTDIV4. */

/*! @brief Read current value of the SIM_CLKDIV1_OUTDIV4 field. */
#define BR_SIM_CLKDIV1_OUTDIV4(x) (HW_SIM_CLKDIV1(x).B.OUTDIV4)

/*! @brief Format value for bitfield SIM_CLKDIV1_OUTDIV4. */
#define BF_SIM_CLKDIV1_OUTDIV4(v) ((uint32_t)((uint32_t)(v) << BP_SIM_CLKDIV1_OUTDIV4) & BM_SIM_CLKDIV1_OUTDIV4)

/*! @brief Set the OUTDIV4 field to a new value. */
#define BW_SIM_CLKDIV1_OUTDIV4(x, v) (HW_SIM_CLKDIV1_WR(x, (HW_SIM_CLKDIV1_RD(x) & ~BM_SIM_CLKDIV1_OUTDIV4) | BF_SIM_CLKDIV1_OUTDIV4(v)))
/*@}*/

/*!
 * @name Register SIM_CLKDIV1, field OUTDIV3[23:20] (RW)
 *
 * This field sets the divide value for the FlexBus clock (external pin FB_CLK)
 * from MCGOUTCLK. At the end of reset, it is loaded with either 0001 or 1111
 * depending on FTF_FOPT[LPBOOT]. The FlexBus clock frequency must be an integer
 * divide of the system clock frequency.
 *
 * Values:
 * - 0000 - Divide-by-1.
 * - 0001 - Divide-by-2.
 * - 0010 - Divide-by-3.
 * - 0011 - Divide-by-4.
 * - 0100 - Divide-by-5.
 * - 0101 - Divide-by-6.
 * - 0110 - Divide-by-7.
 * - 0111 - Divide-by-8.
 * - 1000 - Divide-by-9.
 * - 1001 - Divide-by-10.
 * - 1010 - Divide-by-11.
 * - 1011 - Divide-by-12.
 * - 1100 - Divide-by-13.
 * - 1101 - Divide-by-14.
 * - 1110 - Divide-by-15.
 * - 1111 - Divide-by-16.
 */
/*@{*/
#define BP_SIM_CLKDIV1_OUTDIV3 (20U)       /*!< Bit position for SIM_CLKDIV1_OUTDIV3. */
#define BM_SIM_CLKDIV1_OUTDIV3 (0x00F00000U) /*!< Bit mask for SIM_CLKDIV1_OUTDIV3. */
#define BS_SIM_CLKDIV1_OUTDIV3 (4U)        /*!< Bit field size in bits for SIM_CLKDIV1_OUTDIV3. */

/*! @brief Read current value of the SIM_CLKDIV1_OUTDIV3 field. */
#define BR_SIM_CLKDIV1_OUTDIV3(x) (HW_SIM_CLKDIV1(x).B.OUTDIV3)

/*! @brief Format value for bitfield SIM_CLKDIV1_OUTDIV3. */
#define BF_SIM_CLKDIV1_OUTDIV3(v) ((uint32_t)((uint32_t)(v) << BP_SIM_CLKDIV1_OUTDIV3) & BM_SIM_CLKDIV1_OUTDIV3)

/*! @brief Set the OUTDIV3 field to a new value. */
#define BW_SIM_CLKDIV1_OUTDIV3(x, v) (HW_SIM_CLKDIV1_WR(x, (HW_SIM_CLKDIV1_RD(x) & ~BM_SIM_CLKDIV1_OUTDIV3) | BF_SIM_CLKDIV1_OUTDIV3(v)))
/*@}*/

/*!
 * @name Register SIM_CLKDIV1, field OUTDIV2[27:24] (RW)
 *
 * This field sets the divide value for the bus clock from MCGOUTCLK. At the end
 * of reset, it is loaded with either 0000 or 0111 depending on
 * FTF_FOPT[LPBOOT]. The bus clock frequency must be an integer divide of the core/system clock
 * frequency.
 *
 * Values:
 * - 0000 - Divide-by-1.
 * - 0001 - Divide-by-2.
 * - 0010 - Divide-by-3.
 * - 0011 - Divide-by-4.
 * - 0100 - Divide-by-5.
 * - 0101 - Divide-by-6.
 * - 0110 - Divide-by-7.
 * - 0111 - Divide-by-8.
 * - 1000 - Divide-by-9.
 * - 1001 - Divide-by-10.
 * - 1010 - Divide-by-11.
 * - 1011 - Divide-by-12.
 * - 1100 - Divide-by-13.
 * - 1101 - Divide-by-14.
 * - 1110 - Divide-by-15.
 * - 1111 - Divide-by-16.
 */
/*@{*/
#define BP_SIM_CLKDIV1_OUTDIV2 (24U)       /*!< Bit position for SIM_CLKDIV1_OUTDIV2. */
#define BM_SIM_CLKDIV1_OUTDIV2 (0x0F000000U) /*!< Bit mask for SIM_CLKDIV1_OUTDIV2. */
#define BS_SIM_CLKDIV1_OUTDIV2 (4U)        /*!< Bit field size in bits for SIM_CLKDIV1_OUTDIV2. */

/*! @brief Read current value of the SIM_CLKDIV1_OUTDIV2 field. */
#define BR_SIM_CLKDIV1_OUTDIV2(x) (HW_SIM_CLKDIV1(x).B.OUTDIV2)

/*! @brief Format value for bitfield SIM_CLKDIV1_OUTDIV2. */
#define BF_SIM_CLKDIV1_OUTDIV2(v) ((uint32_t)((uint32_t)(v) << BP_SIM_CLKDIV1_OUTDIV2) & BM_SIM_CLKDIV1_OUTDIV2)

/*! @brief Set the OUTDIV2 field to a new value. */
#define BW_SIM_CLKDIV1_OUTDIV2(x, v) (HW_SIM_CLKDIV1_WR(x, (HW_SIM_CLKDIV1_RD(x) & ~BM_SIM_CLKDIV1_OUTDIV2) | BF_SIM_CLKDIV1_OUTDIV2(v)))
/*@}*/

/*!
 * @name Register SIM_CLKDIV1, field OUTDIV1[31:28] (RW)
 *
 * This field sets the divide value for the core/system clock from MCGOUTCLK. At
 * the end of reset, it is loaded with either 0000 or 0111 depending on
 * FTF_FOPT[LPBOOT].
 *
 * Values:
 * - 0000 - Divide-by-1.
 * - 0001 - Divide-by-2.
 * - 0010 - Divide-by-3.
 * - 0011 - Divide-by-4.
 * - 0100 - Divide-by-5.
 * - 0101 - Divide-by-6.
 * - 0110 - Divide-by-7.
 * - 0111 - Divide-by-8.
 * - 1000 - Divide-by-9.
 * - 1001 - Divide-by-10.
 * - 1010 - Divide-by-11.
 * - 1011 - Divide-by-12.
 * - 1100 - Divide-by-13.
 * - 1101 - Divide-by-14.
 * - 1110 - Divide-by-15.
 * - 1111 - Divide-by-16.
 */
/*@{*/
#define BP_SIM_CLKDIV1_OUTDIV1 (28U)       /*!< Bit position for SIM_CLKDIV1_OUTDIV1. */
#define BM_SIM_CLKDIV1_OUTDIV1 (0xF0000000U) /*!< Bit mask for SIM_CLKDIV1_OUTDIV1. */
#define BS_SIM_CLKDIV1_OUTDIV1 (4U)        /*!< Bit field size in bits for SIM_CLKDIV1_OUTDIV1. */

/*! @brief Read current value of the SIM_CLKDIV1_OUTDIV1 field. */
#define BR_SIM_CLKDIV1_OUTDIV1(x) (HW_SIM_CLKDIV1(x).B.OUTDIV1)

/*! @brief Format value for bitfield SIM_CLKDIV1_OUTDIV1. */
#define BF_SIM_CLKDIV1_OUTDIV1(v) ((uint32_t)((uint32_t)(v) << BP_SIM_CLKDIV1_OUTDIV1) & BM_SIM_CLKDIV1_OUTDIV1)

/*! @brief Set the OUTDIV1 field to a new value. */
#define BW_SIM_CLKDIV1_OUTDIV1(x, v) (HW_SIM_CLKDIV1_WR(x, (HW_SIM_CLKDIV1_RD(x) & ~BM_SIM_CLKDIV1_OUTDIV1) | BF_SIM_CLKDIV1_OUTDIV1(v)))
/*@}*/

/*******************************************************************************
 * HW_SIM_CLKDIV2 - System Clock Divider Register 2
 ******************************************************************************/

/*!
 * @brief HW_SIM_CLKDIV2 - System Clock Divider Register 2 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_clkdiv2
{
    uint32_t U;
    struct _hw_sim_clkdiv2_bitfields
    {
        uint32_t USBFRAC : 1;          /*!< [0] USB clock divider fraction */
        uint32_t USBDIV : 3;           /*!< [3:1] USB clock divider divisor */
        uint32_t RESERVED0 : 28;       /*!< [31:4]  */
    } B;
} hw_sim_clkdiv2_t;

/*!
 * @name Constants and macros for entire SIM_CLKDIV2 register
 */
/*@{*/
#define HW_SIM_CLKDIV2_ADDR(x)   ((x) + 0x1048U)

#define HW_SIM_CLKDIV2(x)        (*(__IO hw_sim_clkdiv2_t *) HW_SIM_CLKDIV2_ADDR(x))
#define HW_SIM_CLKDIV2_RD(x)     (HW_SIM_CLKDIV2(x).U)
#define HW_SIM_CLKDIV2_WR(x, v)  (HW_SIM_CLKDIV2(x).U = (v))
#define HW_SIM_CLKDIV2_SET(x, v) (HW_SIM_CLKDIV2_WR(x, HW_SIM_CLKDIV2_RD(x) |  (v)))
#define HW_SIM_CLKDIV2_CLR(x, v) (HW_SIM_CLKDIV2_WR(x, HW_SIM_CLKDIV2_RD(x) & ~(v)))
#define HW_SIM_CLKDIV2_TOG(x, v) (HW_SIM_CLKDIV2_WR(x, HW_SIM_CLKDIV2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_CLKDIV2 bitfields
 */

/*!
 * @name Register SIM_CLKDIV2, field USBFRAC[0] (RW)
 *
 * This field sets the fraction multiply value for the fractional clock divider
 * when the MCGFLLCLK/MCGPLLCLK clock is the USB clock source (SOPT2[USBSRC] =
 * 1). Divider output clock = Divider input clock * [ (USBFRAC+1) / (USBDIV+1) ]
 */
/*@{*/
#define BP_SIM_CLKDIV2_USBFRAC (0U)        /*!< Bit position for SIM_CLKDIV2_USBFRAC. */
#define BM_SIM_CLKDIV2_USBFRAC (0x00000001U) /*!< Bit mask for SIM_CLKDIV2_USBFRAC. */
#define BS_SIM_CLKDIV2_USBFRAC (1U)        /*!< Bit field size in bits for SIM_CLKDIV2_USBFRAC. */

/*! @brief Read current value of the SIM_CLKDIV2_USBFRAC field. */
#define BR_SIM_CLKDIV2_USBFRAC(x) (BITBAND_ACCESS32(HW_SIM_CLKDIV2_ADDR(x), BP_SIM_CLKDIV2_USBFRAC))

/*! @brief Format value for bitfield SIM_CLKDIV2_USBFRAC. */
#define BF_SIM_CLKDIV2_USBFRAC(v) ((uint32_t)((uint32_t)(v) << BP_SIM_CLKDIV2_USBFRAC) & BM_SIM_CLKDIV2_USBFRAC)

/*! @brief Set the USBFRAC field to a new value. */
#define BW_SIM_CLKDIV2_USBFRAC(x, v) (BITBAND_ACCESS32(HW_SIM_CLKDIV2_ADDR(x), BP_SIM_CLKDIV2_USBFRAC) = (v))
/*@}*/

/*!
 * @name Register SIM_CLKDIV2, field USBDIV[3:1] (RW)
 *
 * This field sets the divide value for the fractional clock divider when the
 * MCGFLLCLK/MCGPLLCLK clock is the USB clock source (SOPT2[USBSRC] = 1). Divider
 * output clock = Divider input clock * [ (USBFRAC+1) / (USBDIV+1) ]
 */
/*@{*/
#define BP_SIM_CLKDIV2_USBDIV (1U)         /*!< Bit position for SIM_CLKDIV2_USBDIV. */
#define BM_SIM_CLKDIV2_USBDIV (0x0000000EU) /*!< Bit mask for SIM_CLKDIV2_USBDIV. */
#define BS_SIM_CLKDIV2_USBDIV (3U)         /*!< Bit field size in bits for SIM_CLKDIV2_USBDIV. */

/*! @brief Read current value of the SIM_CLKDIV2_USBDIV field. */
#define BR_SIM_CLKDIV2_USBDIV(x) (HW_SIM_CLKDIV2(x).B.USBDIV)

/*! @brief Format value for bitfield SIM_CLKDIV2_USBDIV. */
#define BF_SIM_CLKDIV2_USBDIV(v) ((uint32_t)((uint32_t)(v) << BP_SIM_CLKDIV2_USBDIV) & BM_SIM_CLKDIV2_USBDIV)

/*! @brief Set the USBDIV field to a new value. */
#define BW_SIM_CLKDIV2_USBDIV(x, v) (HW_SIM_CLKDIV2_WR(x, (HW_SIM_CLKDIV2_RD(x) & ~BM_SIM_CLKDIV2_USBDIV) | BF_SIM_CLKDIV2_USBDIV(v)))
/*@}*/

/*******************************************************************************
 * HW_SIM_FCFG1 - Flash Configuration Register 1
 ******************************************************************************/

/*!
 * @brief HW_SIM_FCFG1 - Flash Configuration Register 1 (RW)
 *
 * Reset value: 0x0F0F0F00U
 *
 * The EESIZE and DEPART filelds are not applicable.
 */
typedef union _hw_sim_fcfg1
{
    uint32_t U;
    struct _hw_sim_fcfg1_bitfields
    {
        uint32_t FLASHDIS : 1;         /*!< [0] Flash Disable */
        uint32_t FLASHDOZE : 1;        /*!< [1] Flash Doze */
        uint32_t RESERVED0 : 22;       /*!< [23:2]  */
        uint32_t PFSIZE : 4;           /*!< [27:24] Program flash size */
        uint32_t RESERVED1 : 4;        /*!< [31:28]  */
    } B;
} hw_sim_fcfg1_t;

/*!
 * @name Constants and macros for entire SIM_FCFG1 register
 */
/*@{*/
#define HW_SIM_FCFG1_ADDR(x)     ((x) + 0x104CU)

#define HW_SIM_FCFG1(x)          (*(__IO hw_sim_fcfg1_t *) HW_SIM_FCFG1_ADDR(x))
#define HW_SIM_FCFG1_RD(x)       (HW_SIM_FCFG1(x).U)
#define HW_SIM_FCFG1_WR(x, v)    (HW_SIM_FCFG1(x).U = (v))
#define HW_SIM_FCFG1_SET(x, v)   (HW_SIM_FCFG1_WR(x, HW_SIM_FCFG1_RD(x) |  (v)))
#define HW_SIM_FCFG1_CLR(x, v)   (HW_SIM_FCFG1_WR(x, HW_SIM_FCFG1_RD(x) & ~(v)))
#define HW_SIM_FCFG1_TOG(x, v)   (HW_SIM_FCFG1_WR(x, HW_SIM_FCFG1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual SIM_FCFG1 bitfields
 */

/*!
 * @name Register SIM_FCFG1, field FLASHDIS[0] (RW)
 *
 * Flash accesses are disabled (and generate a bus error) and the Flash memory
 * is placed in a low power state. This bit should not be changed during VLP
 * modes. Relocate the interrupt vectors out of Flash memory before disabling the
 * Flash.
 *
 * Values:
 * - 0 - Flash is enabled
 * - 1 - Flash is disabled
 */
/*@{*/
#define BP_SIM_FCFG1_FLASHDIS (0U)         /*!< Bit position for SIM_FCFG1_FLASHDIS. */
#define BM_SIM_FCFG1_FLASHDIS (0x00000001U) /*!< Bit mask for SIM_FCFG1_FLASHDIS. */
#define BS_SIM_FCFG1_FLASHDIS (1U)         /*!< Bit field size in bits for SIM_FCFG1_FLASHDIS. */

/*! @brief Read current value of the SIM_FCFG1_FLASHDIS field. */
#define BR_SIM_FCFG1_FLASHDIS(x) (BITBAND_ACCESS32(HW_SIM_FCFG1_ADDR(x), BP_SIM_FCFG1_FLASHDIS))

/*! @brief Format value for bitfield SIM_FCFG1_FLASHDIS. */
#define BF_SIM_FCFG1_FLASHDIS(v) ((uint32_t)((uint32_t)(v) << BP_SIM_FCFG1_FLASHDIS) & BM_SIM_FCFG1_FLASHDIS)

/*! @brief Set the FLASHDIS field to a new value. */
#define BW_SIM_FCFG1_FLASHDIS(x, v) (BITBAND_ACCESS32(HW_SIM_FCFG1_ADDR(x), BP_SIM_FCFG1_FLASHDIS) = (v))
/*@}*/

/*!
 * @name Register SIM_FCFG1, field FLASHDOZE[1] (RW)
 *
 * When set, Flash memory is disabled for the duration of Wait mode. An attempt
 * by the DMA or other bus master to access the Flash when the Flash is disabled
 * will result in a bus error. This bit should be clear during VLP modes. The
 * Flash will be automatically enabled again at the end of Wait mode so interrupt
 * vectors do not need to be relocated out of Flash memory. The wakeup time from
 * Wait mode is extended when this bit is set.
 *
 * Values:
 * - 0 - Flash remains enabled during Wait mode
 * - 1 - Flash is disabled for the duration of Wait mode
 */
/*@{*/
#define BP_SIM_FCFG1_FLASHDOZE (1U)        /*!< Bit position for SIM_FCFG1_FLASHDOZE. */
#define BM_SIM_FCFG1_FLASHDOZE (0x00000002U) /*!< Bit mask for SIM_FCFG1_FLASHDOZE. */
#define BS_SIM_FCFG1_FLASHDOZE (1U)        /*!< Bit field size in bits for SIM_FCFG1_FLASHDOZE. */

/*! @brief Read current value of the SIM_FCFG1_FLASHDOZE field. */
#define BR_SIM_FCFG1_FLASHDOZE(x) (BITBAND_ACCESS32(HW_SIM_FCFG1_ADDR(x), BP_SIM_FCFG1_FLASHDOZE))

/*! @brief Format value for bitfield SIM_FCFG1_FLASHDOZE. */
#define BF_SIM_FCFG1_FLASHDOZE(v) ((uint32_t)((uint32_t)(v) << BP_SIM_FCFG1_FLASHDOZE) & BM_SIM_FCFG1_FLASHDOZE)

/*! @brief Set the FLASHDOZE field to a new value. */
#define BW_SIM_FCFG1_FLASHDOZE(x, v) (BITBAND_ACCESS32(HW_SIM_FCFG1_ADDR(x), BP_SIM_FCFG1_FLASHDOZE) = (v))
/*@}*/

/*!
 * @name Register SIM_FCFG1, field PFSIZE[27:24] (RO)
 *
 * This field specifies the amount of program flash memory available on the
 * device . Undefined values are reserved.
 *
 * Values:
 * - 0011 - 32 KB of program flash memory
 * - 0101 - 64 KB of program flash memory
 * - 0111 - 128 KB of program flash memory
 * - 1001 - 256 KB of program flash memory
 * - 1011 - 512 KB of program flash memory
 * - 1101 - 1024 KB of program flash memory
 * - 1111 - 512 KB of program flash memory
 */
/*@{*/
#define BP_SIM_FCFG1_PFSIZE  (24U)         /*!< Bit position for SIM_FCFG1_PFSIZE. */
#define BM_SIM_FCFG1_PFSIZE  (0x0F000000U) /*!< Bit mask for SIM_FCFG1_PFSIZE. */
#define BS_SIM_FCFG1_PFSIZE  (4U)          /*!< Bit field size in bits for SIM_FCFG1_PFSIZE. */

/*! @brief Read current value of the SIM_FCFG1_PFSIZE field. */
#define BR_SIM_FCFG1_PFSIZE(x) (HW_SIM_FCFG1(x).B.PFSIZE)
/*@}*/

/*******************************************************************************
 * HW_SIM_FCFG2 - Flash Configuration Register 2
 ******************************************************************************/

/*!
 * @brief HW_SIM_FCFG2 - Flash Configuration Register 2 (RO)
 *
 * Reset value: 0x7FFF0000U
 */
typedef union _hw_sim_fcfg2
{
    uint32_t U;
    struct _hw_sim_fcfg2_bitfields
    {
        uint32_t RESERVED0 : 16;       /*!< [15:0]  */
        uint32_t MAXADDR1 : 7;         /*!< [22:16] Max address block 1 */
        uint32_t RESERVED1 : 1;        /*!< [23]  */
        uint32_t MAXADDR0 : 7;         /*!< [30:24] Max address block 0 */
        uint32_t RESERVED2 : 1;        /*!< [31]  */
    } B;
} hw_sim_fcfg2_t;

/*!
 * @name Constants and macros for entire SIM_FCFG2 register
 */
/*@{*/
#define HW_SIM_FCFG2_ADDR(x)     ((x) + 0x1050U)

#define HW_SIM_FCFG2(x)          (*(__I hw_sim_fcfg2_t *) HW_SIM_FCFG2_ADDR(x))
#define HW_SIM_FCFG2_RD(x)       (HW_SIM_FCFG2(x).U)
/*@}*/

/*
 * Constants & macros for individual SIM_FCFG2 bitfields
 */

/*!
 * @name Register SIM_FCFG2, field MAXADDR1[22:16] (RO)
 *
 * This field equals zero if there is only one program flash block, otherwise it
 * equals the value of the MAXADDR0 field. For example, with MAXADDR0 = MAXADDR1
 * = 0x20 the first invalid address of flash block 1 is 0x4_0000 + 0x4_0000.
 * This would be the MAXADDR1 value for a device with 512 KB program flash memory
 * across two flash blocks and no FlexNVM.
 */
/*@{*/
#define BP_SIM_FCFG2_MAXADDR1 (16U)        /*!< Bit position for SIM_FCFG2_MAXADDR1. */
#define BM_SIM_FCFG2_MAXADDR1 (0x007F0000U) /*!< Bit mask for SIM_FCFG2_MAXADDR1. */
#define BS_SIM_FCFG2_MAXADDR1 (7U)         /*!< Bit field size in bits for SIM_FCFG2_MAXADDR1. */

/*! @brief Read current value of the SIM_FCFG2_MAXADDR1 field. */
#define BR_SIM_FCFG2_MAXADDR1(x) (HW_SIM_FCFG2(x).B.MAXADDR1)
/*@}*/

/*!
 * @name Register SIM_FCFG2, field MAXADDR0[30:24] (RO)
 *
 * This field concatenated with 13 trailing zeros indicates the first invalid
 * address of each program flash block. For example, if MAXADDR0 = 0x20 the first
 * invalid address of flash block 0 is 0x0004_0000. This would be the MAXADDR0
 * value for a device with 256 KB program flash in flash block 0.
 */
/*@{*/
#define BP_SIM_FCFG2_MAXADDR0 (24U)        /*!< Bit position for SIM_FCFG2_MAXADDR0. */
#define BM_SIM_FCFG2_MAXADDR0 (0x7F000000U) /*!< Bit mask for SIM_FCFG2_MAXADDR0. */
#define BS_SIM_FCFG2_MAXADDR0 (7U)         /*!< Bit field size in bits for SIM_FCFG2_MAXADDR0. */

/*! @brief Read current value of the SIM_FCFG2_MAXADDR0 field. */
#define BR_SIM_FCFG2_MAXADDR0(x) (HW_SIM_FCFG2(x).B.MAXADDR0)
/*@}*/

/*******************************************************************************
 * HW_SIM_UIDH - Unique Identification Register High
 ******************************************************************************/

/*!
 * @brief HW_SIM_UIDH - Unique Identification Register High (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_uidh
{
    uint32_t U;
    struct _hw_sim_uidh_bitfields
    {
        uint32_t UID : 32;             /*!< [31:0] Unique Identification */
    } B;
} hw_sim_uidh_t;

/*!
 * @name Constants and macros for entire SIM_UIDH register
 */
/*@{*/
#define HW_SIM_UIDH_ADDR(x)      ((x) + 0x1054U)

#define HW_SIM_UIDH(x)           (*(__I hw_sim_uidh_t *) HW_SIM_UIDH_ADDR(x))
#define HW_SIM_UIDH_RD(x)        (HW_SIM_UIDH(x).U)
/*@}*/

/*
 * Constants & macros for individual SIM_UIDH bitfields
 */

/*!
 * @name Register SIM_UIDH, field UID[31:0] (RO)
 *
 * Unique identification for the device.
 */
/*@{*/
#define BP_SIM_UIDH_UID      (0U)          /*!< Bit position for SIM_UIDH_UID. */
#define BM_SIM_UIDH_UID      (0xFFFFFFFFU) /*!< Bit mask for SIM_UIDH_UID. */
#define BS_SIM_UIDH_UID      (32U)         /*!< Bit field size in bits for SIM_UIDH_UID. */

/*! @brief Read current value of the SIM_UIDH_UID field. */
#define BR_SIM_UIDH_UID(x)   (HW_SIM_UIDH(x).U)
/*@}*/

/*******************************************************************************
 * HW_SIM_UIDMH - Unique Identification Register Mid-High
 ******************************************************************************/

/*!
 * @brief HW_SIM_UIDMH - Unique Identification Register Mid-High (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_uidmh
{
    uint32_t U;
    struct _hw_sim_uidmh_bitfields
    {
        uint32_t UID : 32;             /*!< [31:0] Unique Identification */
    } B;
} hw_sim_uidmh_t;

/*!
 * @name Constants and macros for entire SIM_UIDMH register
 */
/*@{*/
#define HW_SIM_UIDMH_ADDR(x)     ((x) + 0x1058U)

#define HW_SIM_UIDMH(x)          (*(__I hw_sim_uidmh_t *) HW_SIM_UIDMH_ADDR(x))
#define HW_SIM_UIDMH_RD(x)       (HW_SIM_UIDMH(x).U)
/*@}*/

/*
 * Constants & macros for individual SIM_UIDMH bitfields
 */

/*!
 * @name Register SIM_UIDMH, field UID[31:0] (RO)
 *
 * Unique identification for the device.
 */
/*@{*/
#define BP_SIM_UIDMH_UID     (0U)          /*!< Bit position for SIM_UIDMH_UID. */
#define BM_SIM_UIDMH_UID     (0xFFFFFFFFU) /*!< Bit mask for SIM_UIDMH_UID. */
#define BS_SIM_UIDMH_UID     (32U)         /*!< Bit field size in bits for SIM_UIDMH_UID. */

/*! @brief Read current value of the SIM_UIDMH_UID field. */
#define BR_SIM_UIDMH_UID(x)  (HW_SIM_UIDMH(x).U)
/*@}*/

/*******************************************************************************
 * HW_SIM_UIDML - Unique Identification Register Mid Low
 ******************************************************************************/

/*!
 * @brief HW_SIM_UIDML - Unique Identification Register Mid Low (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_uidml
{
    uint32_t U;
    struct _hw_sim_uidml_bitfields
    {
        uint32_t UID : 32;             /*!< [31:0] Unique Identification */
    } B;
} hw_sim_uidml_t;

/*!
 * @name Constants and macros for entire SIM_UIDML register
 */
/*@{*/
#define HW_SIM_UIDML_ADDR(x)     ((x) + 0x105CU)

#define HW_SIM_UIDML(x)          (*(__I hw_sim_uidml_t *) HW_SIM_UIDML_ADDR(x))
#define HW_SIM_UIDML_RD(x)       (HW_SIM_UIDML(x).U)
/*@}*/

/*
 * Constants & macros for individual SIM_UIDML bitfields
 */

/*!
 * @name Register SIM_UIDML, field UID[31:0] (RO)
 *
 * Unique identification for the device.
 */
/*@{*/
#define BP_SIM_UIDML_UID     (0U)          /*!< Bit position for SIM_UIDML_UID. */
#define BM_SIM_UIDML_UID     (0xFFFFFFFFU) /*!< Bit mask for SIM_UIDML_UID. */
#define BS_SIM_UIDML_UID     (32U)         /*!< Bit field size in bits for SIM_UIDML_UID. */

/*! @brief Read current value of the SIM_UIDML_UID field. */
#define BR_SIM_UIDML_UID(x)  (HW_SIM_UIDML(x).U)
/*@}*/

/*******************************************************************************
 * HW_SIM_UIDL - Unique Identification Register Low
 ******************************************************************************/

/*!
 * @brief HW_SIM_UIDL - Unique Identification Register Low (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_uidl
{
    uint32_t U;
    struct _hw_sim_uidl_bitfields
    {
        uint32_t UID : 32;             /*!< [31:0] Unique Identification */
    } B;
} hw_sim_uidl_t;

/*!
 * @name Constants and macros for entire SIM_UIDL register
 */
/*@{*/
#define HW_SIM_UIDL_ADDR(x)      ((x) + 0x1060U)

#define HW_SIM_UIDL(x)           (*(__I hw_sim_uidl_t *) HW_SIM_UIDL_ADDR(x))
#define HW_SIM_UIDL_RD(x)        (HW_SIM_UIDL(x).U)
/*@}*/

/*
 * Constants & macros for individual SIM_UIDL bitfields
 */

/*!
 * @name Register SIM_UIDL, field UID[31:0] (RO)
 *
 * Unique identification for the device.
 */
/*@{*/
#define BP_SIM_UIDL_UID      (0U)          /*!< Bit position for SIM_UIDL_UID. */
#define BM_SIM_UIDL_UID      (0xFFFFFFFFU) /*!< Bit mask for SIM_UIDL_UID. */
#define BS_SIM_UIDL_UID      (32U)         /*!< Bit field size in bits for SIM_UIDL_UID. */

/*! @brief Read current value of the SIM_UIDL_UID field. */
#define BR_SIM_UIDL_UID(x)   (HW_SIM_UIDL(x).U)
/*@}*/

/*******************************************************************************
 * hw_sim_t - module struct
 ******************************************************************************/
/*!
 * @brief All SIM module registers.
 */
#pragma pack(1)
typedef struct _hw_sim
{
    __IO hw_sim_sopt1_t SOPT1;             /*!< [0x0] System Options Register 1 */
    __IO hw_sim_sopt1cfg_t SOPT1CFG;       /*!< [0x4] SOPT1 Configuration Register */
    uint8_t _reserved0[4092];
    __IO hw_sim_sopt2_t SOPT2;             /*!< [0x1004] System Options Register 2 */
    uint8_t _reserved1[4];
    __IO hw_sim_sopt4_t SOPT4;             /*!< [0x100C] System Options Register 4 */
    __IO hw_sim_sopt5_t SOPT5;             /*!< [0x1010] System Options Register 5 */
    uint8_t _reserved2[4];
    __IO hw_sim_sopt7_t SOPT7;             /*!< [0x1018] System Options Register 7 */
    __IO hw_sim_sopt8_t SOPT8;             /*!< [0x101C] System Options Register 8 */
    uint8_t _reserved3[4];
    __I hw_sim_sdid_t SDID;                /*!< [0x1024] System Device Identification Register */
    uint8_t _reserved4[12];
    __IO hw_sim_scgc4_t SCGC4;             /*!< [0x1034] System Clock Gating Control Register 4 */
    __IO hw_sim_scgc5_t SCGC5;             /*!< [0x1038] System Clock Gating Control Register 5 */
    __IO hw_sim_scgc6_t SCGC6;             /*!< [0x103C] System Clock Gating Control Register 6 */
    __IO hw_sim_scgc7_t SCGC7;             /*!< [0x1040] System Clock Gating Control Register 7 */
    __IO hw_sim_clkdiv1_t CLKDIV1;         /*!< [0x1044] System Clock Divider Register 1 */
    __IO hw_sim_clkdiv2_t CLKDIV2;         /*!< [0x1048] System Clock Divider Register 2 */
    __IO hw_sim_fcfg1_t FCFG1;             /*!< [0x104C] Flash Configuration Register 1 */
    __I hw_sim_fcfg2_t FCFG2;              /*!< [0x1050] Flash Configuration Register 2 */
    __I hw_sim_uidh_t UIDH;                /*!< [0x1054] Unique Identification Register High */
    __I hw_sim_uidmh_t UIDMH;              /*!< [0x1058] Unique Identification Register Mid-High */
    __I hw_sim_uidml_t UIDML;              /*!< [0x105C] Unique Identification Register Mid Low */
    __I hw_sim_uidl_t UIDL;                /*!< [0x1060] Unique Identification Register Low */
} hw_sim_t;
#pragma pack()

/*! @brief Macro to access all SIM registers. */
/*! @param x SIM module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_SIM(SIM_BASE)</code>. */
#define HW_SIM(x)      (*(hw_sim_t *)(x))

#endif /* __HW_SIM_REGISTERS_H__ */
/* EOF */
