#include "mbed.h"  
#include <sstream>            
#include <GroveColourSensor.hpp>
#include <text_to_speech.h>
#include <text_to_speech_img.h>

#include <string>

Serial pc(USBTX, USBRX); // tx, rx
GroveColourSensor colorSensor(I2C_SDA1, I2C_SCL1);
SPI spi(p11, p12, p13);
DigitalOut cs(p26);



int main() {
    colorSensor.powerUp();
    // Attente démarrage capteur
    wait(1);
    unsigned colour;

    std::string out_string;
    std::stringstream ss;

    spi.format(8,3);
    spi.frequency(100000);
    
    // Analyse par le capteur du taux de vert, rouge, bleu
    for (colour = GroveColourSensor::GREEN; colour < GroveColourSensor::NUM_COLORS-1; colour++) {
         uint16_t colourValue = colorSensor.readColour(colour);
         ss << colourValue;
         out_string = ss.str();
         
         // Affichage du taux de couleur
         pc.printf(out_string.c_str());
         pc.printf("\n");
     }
     colorSensor.powerDown();    
     
     
     // Essai communication avec le TextToSpeech
     //tts_init();
     //tts_setup();
     //tts_power_default_config();
     //tts_audio_default_config();
     //tts_volume_set( 0 );
     //tts_default_config();
     //tts_speak("Hello world");
    
}
