#include "mbed.h"
#include "draw.h"
#include "stepmotor.h"
//#include<string>

#define CM_ENTER 0xF0
#define CM_PLAY 0xF6
#define CM_PAUSE 0xF7
#define CM_GIRO 0xF8
#define CM_TRASLADAR 0xF9
#define CM_STOP 0xFA
#define CM_NODRAW 0xFB
#define CM_DRAW 0XFC
#define CM_VERTEX2D 0xFD
#define CM_GUARDAR 0xFE
#define CM_EJECUTAR 0xFF

#define MEM_SIZE 100
#define MEM_TYPE uint32_t   //significa que de ahora en más donde diga MEM_TYPE será tipo uint32_t
#define PASOSxCUADRANTE 1000 //4096
uint8_t mem_head = 0;
uint8_t mem_tail = 0;
char temp;
bool full = 0;
int valor=1;
uint32_t cuadrantes = 0;
bool direccion = 0;

MEM_TYPE buffer[MEM_SIZE];
stepmotor smotor1(D9, D10, D11, D12);
stepmotor smotor2(D2, D6, D7, D8);
Serial command(PC_10, PC_11, 9600);
Serial letrero(PC_12, PD_2, 9600);

Thread hilo1;

void giroIzq()
{
    smotor1.step(1000, 1);
}

void stepforward()
{
    smotor1.step(cuadrantes * PASOSxCUADRANTE, !direccion);
    hilo1.join();
}

int dec2hex(char data)
{
    int dividendo = (int)data;
    int cociente = dividendo / 16;
    int residuo = dividendo % 16;
    dividendo = cociente * 10 + residuo;
    //cociente=dividendo/16;
    //residuo=dividendo%16;
    //letrero.printf("%X = %d\n",data,dividendo);
    return dividendo;
}

void giroDer()
{
    smotor1.step(1000, 0);
}

void girar(uint8_t sentido)
{
    letrero.printf(">>>> %d \n", sentido);
    uint32_t speed = 1500;
    smotor1.set_speed(speed);
    smotor2.set_speed(speed);
    if (sentido == 1)
    {
        letrero.printf("pa la derecha!!\n");
        hilo1.start(giroIzq);
        smotor2.step(1000, 1);
    }
    else
    {
        letrero.printf("pa la izquierda!\n");
        hilo1.start(giroDer);
        smotor2.step(1000, 0);
    }
    wait(2);
}

void mem_free()
{ //Estaba como uint32_t no como void
    mem_head = 0;
    full = 0;
}

bool mem_put(MEM_TYPE data)
{ //Escribir
    if (full)
        return 1;
    buffer[mem_head] = data; //carga en dato en el buffer
    mem_head += 1;
    if (mem_head == MEM_SIZE)
        full = 1;
    return 0;
}

bool mem_get(MEM_TYPE *data)
{ //Leer
    if (mem_head == 0)
        return 1;
    if (mem_head == mem_tail)
        return 1;
    *data = buffer[mem_tail];
    mem_tail += 1;
    return 0;
}

void Rx_interrupt()
{
    char raw_data;
    raw_data = command.getc();
    letrero.printf(">>>>");
    switch (raw_data)
    {
        case CM_PAUSE:
            valor=0;
            break;
        case CM_PLAY:
            valor=1;
            break;      
        default:
            break;
    }
    return;
}

//quitar el for y poner un do,while
//crear una variable global que sea la que le aumenta o no al j
//así en la función de interrupción se cambia esa variable de 0 a 1 dependiendo si se quiere sumar o no

void ejecutar()
{
    letrero.printf("inicio de ejecutar...\n");
    int j=0;
    do
    {
        letrero.attach(&Rx_interrupt, Serial::RxIrq);
        if (buffer[j] == CM_NODRAW)
        {
            nodraw();
        }
        if (buffer[j] == CM_DRAW)
        {
            draw();
        }
        if (buffer[j] == CM_STOP)
        {
            mem_free();
            return;
        }
        temp = buffer[j] >> 24 & 0xFF;
        if (temp == CM_VERTEX2D)
        {
            uint8_t datoX = buffer[j] >> 16 & 0xFF;
            uint8_t datoY = buffer[j] >> 8 & 0xFF;
            vertex2d(datoX, datoY);
        }
        if (temp == CM_TRASLADAR) //no mover si draw se encuentra activo
        {
            uint32_t speed = 1500;
            smotor1.set_speed(speed);
            smotor2.set_speed(speed);
            cuadrantes = buffer[j] >> 16 & 0xFF;
            direccion = buffer[j] >> 8 & 0xFF;
            hilo1.start(stepforward);
            smotor2.step(cuadrantes * PASOSxCUADRANTE, direccion);
            wait(1);
        }
    j+=valor;
    }while(j <= mem_head);
    letrero.printf("fin de ejecutar...\n");
    mem_free();
}

void guardar()
{
    letrero.printf("inicio de guardar...\n");
    MEM_TYPE val; //significa que la variable "val" es del tipo uint32_t
    char dato1, dato2;
    do
    {
        dato1 = command.getc();
        letrero.printf("%X\n",dato1);
        if (dato1 == CM_STOP)
        {
            dato2 = command.getc();
            if (dato2 == CM_ENTER)
            {
                val = dato1;
                mem_put(val);
                full = 1;
            }
        }
        if (dato1 == CM_NODRAW | dato1 == CM_DRAW)
        {
            dato2 = command.getc();
            if (dato2 == CM_ENTER)
            {
                val = dato1;
                mem_put(val);
            }
        }
        if (dato1 == CM_VERTEX2D)
        {
            dato2 = command.getc();
            if (dec2hex(dato2) <= 50)
            {
                val = CM_VERTEX2D;
                val = val << 8;
                val = val | dato2;
                dato2 = command.getc();
                if (dec2hex(dato2) <= 50)
                {
                    val = val << 8;
                    val = val | dato2;
                    dato2 = command.getc();
                    if (dato2 == CM_ENTER)
                    {
                        val = val << 8;
                        val = val | CM_ENTER;
                        mem_put(val);
                    }
                }
            }
        }
        if (dato1 == CM_TRASLADAR)
        {
            dato2 = command.getc();
            if (dato2 <= 0xEF)
            {
                val = CM_TRASLADAR;
                val = val << 8;
                val = val | dato2;
                dato2 = command.getc();
                if (dato2 <= 1)
                {
                    val = val << 8;
                    val = val | dato2;
                    dato2 = command.getc();
                    if (dato2 == CM_ENTER)
                    {
                        val = val << 8;
                        val = val | CM_ENTER;
                        mem_put(val);
                    }
                }
            }
        }
    } while (!full);
    letrero.printf("fin de guardar...\n");
}

int main()
{
    //command.baud(9600);
    init_servo();
    //home(); //llama a no_draw y va a 0,0

    char read_cc;
    while (1)
    {
        read_cc = command.getc();
        switch (read_cc)
        {
        case CM_GUARDAR:
            if (read_cc = command.getc() == CM_ENTER)
            {
                guardar();
            }
            break; //FE
        case CM_EJECUTAR:
            if (read_cc = command.getc() == CM_ENTER)
            {
                ejecutar();
            }
            break; //FF
        case CM_GIRO:
            uint8_t sentido = command.getc();
            if (sentido <= 1)
            {
                read_cc = command.getc();
                if (read_cc = command.getc() == CM_ENTER)
                {
                    girar(sentido);
                }
            }
            break; //F8
        default:
            letrero.printf("Paila \n");
            break;
        }
    }
}
/*
FE F0 FD 12 34 F0 FB F0 FD 0A 0A F0 FD 28 0A F0 FD 28 28 F0 FD 0A 28 F0 F9 27 00 F0 FC F0 FA F0 FF F0
FE F0 FD 12 34 F0 FC F0 FD 10 10 F0 FD 40 10 F0 FD 40 40 F0 FD 10 40 F0 FB F0 F9 05 00 F0 FA F0 FF F0
FE F0 FD 10 10 F0 FC F0 FD 40 10 F0 FD 40 40 F0 FD 10 40 F0 FD 10 10 F0 FB F0 FA F0 FF F0 //cuadrado
FE F0 FD 10 10 F0 FC F0 FD 40 10 F0 FD 25 40 F0 FD 10 10 F0 FB F0 FA F0 FF F0 //triángulo
FE F0 F9 02 00 F0 F9 02 01 F0 F9 01 01 F0 F9 01 00 F0 FA F0 FF F0 //prueba trasladar
    https://os.mbed.com/users/fabeltranm/
*/
/*
#include "mbed.h"

void print_char(char c = '*')
{
    printf("%c", c);
    fflush(stdout);
}

Thread thread;

DigitalOut led1(LED1);

void print_thread()
{
    while (true) {
        wait(1);
        print_char();
    }
}

int main()
{
    printf("\n\n*** RTOS basic example ***\n");

    thread.start(print_thread);

    while (true) {
        led1 = !led1;
        wait(0.5);
    }
}
*/