/*
 * $Id: Debug.c 26 2011-06-09 10:24:02Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-09 12:24:02 +0200 (jeu., 09 juin 2011) $
 * $Rev: 26 $
 * 
 * 
 * 
 * 
 * 
 */
 
#include "Debug.h"


Debug_LevelMask_t    debug_LevelMask = DEBUG_LEVEL_WARNING | DEBUG_LEVEL_ERROR | DEBUG_LEVEL_PANIC;
Debug_ModuleMask_t    debug_ModuleMask = DEBUG_MODULE_ALL;


void Debug_SetMasks(Debug_ModuleMask_t moduleMask, Debug_LevelMask_t levelMask)
{
    debug_LevelMask = levelMask;
    debug_ModuleMask = moduleMask;
}

const char *Debug_GetText(uint32_t level)
{
    char *result;

    switch(level)
    {
        case DEBUG_LEVEL_INFO:
            result = "INFO";
            break;
            
        case DEBUG_LEVEL_WARNING:
            result = "WARNING";
            break;
        
        case DEBUG_LEVEL_ERROR:
            result = "ERROR";
            break;
        
        case DEBUG_LEVEL_PANIC:
            result = "PANIC";
            break;
        
        case DEBUG_LEVEL_VERBOSE0:
            result = "VERBOSE0";
            break;
        
        case DEBUG_LEVEL_VERBOSE1:
            result = "VERBOSE1";
            break;
        
        case DEBUG_LEVEL_VERBOSE2:
            result = "VERBOSE2";
            break;
        
        default:
            result = "<unknown>";
            break;
    }
    
    return result;
}


void Debug_DumpBufferHex(uint8_t *buffer, int32_t length)
{
    int32_t        i, address, index, tmpIndex;
    
    index = 0;
    address = 0;
    while(index < length)
    {
        /* Print buffer relative address */
        DEBUG_RAW_NOCRLF(("%03X  ", address));
    
        /* Print hex bytes */
        for (i = 0; i < DEBUG_BUFFER_DUMP_LINE_LEN; i++)
        {
            tmpIndex = index + i;
            if (tmpIndex < length)
            {
                DEBUG_RAW_NOCRLF(("%02X ", buffer[tmpIndex]));
            }
            else
            {
                DEBUG_RAW_NOCRLF(("   "));
            }
        }
    
        DEBUG_RAW_NOCRLF((" -  "));
    
        /* Print ascii chars */
        for (i = 0; i < DEBUG_BUFFER_DUMP_LINE_LEN; i++)
        {
            tmpIndex = index + i;
            if (tmpIndex < length)
            {
                DEBUG_RAW_NOCRLF(("%c", buffer[tmpIndex] >= 32 ? buffer[tmpIndex] : '.'));
            }
        }

        index += DEBUG_BUFFER_DUMP_LINE_LEN;
        address += DEBUG_BUFFER_DUMP_LINE_LEN;
        
        DEBUG_RAW_NOCRLF(("\r\n"));
    }
    
}

