/*
 * $Id: mbedNet.h 29 2011-06-11 14:53:08Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-11 16:53:08 +0200 (sam., 11 juin 2011) $
 * $Rev: 29 $
 *
 *
 *
 *
 *
 */

#ifndef __MBEDNET_H__
#define    __MBEDNET_H__


#include <stdint.h>


enum Bool
{
    False = 0,
    True = !False,
};
typedef enum Bool Bool_t;


#define        DEBUG_ON        1

#define        NET_DEFAULT_TTL                    128            /* Default TTL */
#define        NET_ENCAPSULATION_MAX_DEPTH        5            /* Maximum protocol encapsulation depth */
#define        NET_PERIODIC_FUNCTION_MAX_COUNT    5            /* Maximum number of timers */
#define        NETIF_MAX_COUNT                    2            /* Maximum number of registrable interfaces  */
#define        ETHERNET_PROTOCOL_MAX_COUNT        3            /* Maximum number of registrable protocols over ethernet */
#define        IPV4_PROTOCOL_MAX_COUNT            4            /* Maximum number of registrable protocols over IPv4 */
#define        ARP_CACHE_MAX_ENTRIES            4            /* Maximum number of entries in the ARP cache */
#define        ARP_FUNCTION_PERIOD                10            /* Period in seconds of the ARP periodic function */
#define        ARP_MAX_ENTRY_AGE                60            /* Max age of a dynamic entry in seconds */
#define        NET_API_PER_PROTOCOL_MAX_COUNT    3            /* Maximum number of API per protocol */
#define        QUEUE_MAX_ENTRY_COUNT            16            /* Maximum entries per queue */
#define        SOCKET_MAX_COUNT                10            /* Maximum number of sockets in the system */
#define        SOCKET_DATAQUEUE_ENTRY_COUNT    4            /* Maximum data block entries per socket */
#define        MBEDNET_HAVE_RTOS                0            /* 1 = have RTOS, 0 = no RTOS */


#define        ntohs(a)        (((((uint16_t)a) >> 8) & 0x00FF) | ((((uint16_t)a) << 8) & 0xFF00))
#define        htons(a)        ntohs(a)


enum mbedNetResult
{
    mbedNetResult_Success = 0,
    mbedNetResult_NotEnoughMemory,
    mbedNetResult_TooManyInterfaces,
    mbedNetResult_InvalidInterface,
    mbedNetResult_InterfaceAlreadyUp,
    mbedNetResult_InterfaceAlreadyDown,
    mbedNetResult_TooManyPeriodicFunctions,
    mbedNetResult_TooManyDrivers,
    mbedNetResult_InvalidDriver,
    mbedNetResult_InvalidParameter,
    mbedNetResult_TooManyRegisteredProtocols,
    mbedNetResult_NoProtocolRegistrationFunction,
    mbedNetResult_NoAPIRegistrationFunction,
    mbedNetResult_TooManyOpenSockets,
    mbedNetResult_InvalidSocketHandle,
    mbedNetResult_SocketAlreadyClosed,
    mbedNetResult_WouldBlock,
    mbedNetResult_QueueEmpty,
    mbedNetResult_QueueFull,
    mbedNetResult_NotIplemented,
    mbedNetResult_BufferTooSmall,
    mbedNetResult_NoRouteToHost,
    mbedNetResult_WaitARPResolution,
    mbedNetResult_DestinationAddressRequired,
    mbedNetResult_TooMuchData,
    mbedNetResult_Count,
};
typedef enum mbedNetResult mbedNetResult_t;


#define    MA0    address[0]
#define    MA1    address[1]
#define    MA2    address[2]
#define    MA3    address[3]
#define    MA4    address[4]
#define    MA5    address[5]
struct Ethernet_Addr
{
    uint8_t        address[6];
};
typedef struct Ethernet_Addr     Ethernet_Addr_t;

extern const Ethernet_Addr_t    ethernet_Addr_Broadcast;
extern const Ethernet_Addr_t    ethernet_Addr_Null;


#define    IP0        bytes.ip0
#define    IP1        bytes.ip1
#define    IP2        bytes.ip2
#define    IP3        bytes.ip3

#pragma push
#pragma pack(1)
union IPv4_Addr
{
    struct {
        uint32_t    ip0:8;
        uint32_t    ip1:8;
        uint32_t    ip2:8;
        uint32_t    ip3:8;
    } bytes;
    uint32_t    addr;
};
#pragma pop

typedef union IPv4_Addr IPv4_Addr_t;

extern const IPv4_Addr_t         ipv4_Addr_Broadcast;
extern const IPv4_Addr_t         ipv4_Addr_Any;
#define    IPADDR_ANY                ipv4_Addr_Any.addr
#define    IPADDR_BROADCAST        ipv4_Addr_Broadcast.addr


#if MBEDNET_HAVE_RTOS

#error "Please define mutex and semaphore macros"

#else    /* MBEDNET_HAVE_RTOS */

typedef int32_t    RTOS_Mutex_t;

#define    RTOS_MUTEX_CREATE()            0
#define    RTOS_MUTEX_LOCK(id)            id++
#define    RTOS_MUTEX_UNLOCK(id)        id--

typedef int32_t    RTOS_Sem_t;

#define    RTOS_SEM_CREATE(i, m)        0
#define    RTOS_SEM_P(id)                id++
#define    RTOS_SEM_V(id)                id--

#endif    /* MBEDNET_HAVE_RTOS */

extern mbedNetResult_t    mbedNet_LastError;


#endif /* __MBEDNET_H__ */
