/*
 * $Id: UDPv4.c 29 2011-06-11 14:53:08Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-11 16:53:08 +0200 (sam., 11 juin 2011) $
 * $Rev: 29 $
 * 
 * 
 * 
 * 
 * 
 */
 
#include "UDPv4.h"
#include "NetIF.h"
#include "Debug.h"
#include <string.h>

#define    DEBUG_CURRENT_MODULE_NAME    "UDPv4"
#define    DEBUG_CURRENT_MODULE_ID        DEBUG_MODULE_UDPV4


static void Init(void);
static void Handler(NetIF_t *netIF, NetPacket_t *packet);
static int32_t RegisterAPI(Net_API_t *api);


Protocol_Handler_t    udpv4 = 
{
    PROTOCOL_INDEX_NOT_INITIALIZED,         /* Always PROTOCOL_INDEX_NOT_INITIALIZED at initialization */
    Protocol_ID_UDPv4,                         /* Protocol ID */
    IPV4_PROTO_UDPV4,                         /* Protocol number */
    Init,                                     /* Protocol initialisation function */
    Handler,                                /* Protocol handler */
    NULL,                                     /* Protocol registration function */
    RegisterAPI,                            /* API registration function */
};


static Net_API_t    *netAPITable[NET_API_PER_PROTOCOL_MAX_COUNT];
static int32_t        netAPICount = 0;


static void Init(void)
{
    DEBUG_MODULE(DEBUG_LEVEL_INFO, ("Initializing UDPv4 layer"));
    memset(netAPITable, 0, sizeof(netAPITable));
    netAPICount = 0;
}


static void Handler(NetIF_t *netIF, NetPacket_t *packet)
{
    IPv4_Header_t    *ipv4Header;
    int32_t            depth, index;
    
    for (index = 0; index < netAPICount; index++)
    {
        netAPITable[index]->Hook(netIF, Protocol_ID_UDPv4, packet);
    }
        
    depth = packet->depth;
    ipv4Header = (IPv4_Header_t *)packet->headerPtrTable[depth];
    
    DEBUG_BLOCK(DEBUG_LEVEL_VERBOSE1)
    {
        UDPv4_DumpHeader(NULL, ipv4Header);
    }
}


static int32_t RegisterAPI(Net_API_t *netAPI)
{
    DEBUG_MODULE(DEBUG_LEVEL_INFO, ("Registering %s API", api_IDNames[netAPI->apiID]));
    netAPI->InitAPI();
    netAPITable[netAPICount] = netAPI;
    netAPICount++;
    return -1;
}


void UDPv4_DumpHeader(const char *prefix, IPv4_Header_t *ipv4Header)
{
    UDPv4_Header_t    *udpv4Header = (UDPv4_Header_t *)(ipv4Header + 1);

    DEBUG_RAW(("%sUDPv4 %d.%d.%d.%d:%d --> %d.%d.%d.%d:%d  length:%d crc:%04X" ,
        prefix != NULL ? prefix : "",
        ipv4Header->source.IP0,
        ipv4Header->source.IP1,
        ipv4Header->source.IP2,
        ipv4Header->source.IP3,
        ntohs(udpv4Header->sourcePort),
        ipv4Header->dest.IP0,
        ipv4Header->dest.IP1,
        ipv4Header->dest.IP2,
        ipv4Header->dest.IP3,
        ntohs(udpv4Header->destPort),
        ntohs(udpv4Header->length),
        ntohs(udpv4Header->crc)
    ));
    
}

