/*
 * $Id: ICMPv4.h 23 2011-06-06 06:03:23Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-06 08:03:23 +0200 (lun., 06 juin 2011) $
 * $Rev: 23 $
 * 
 * 
 * 
 * 
 * 
 */
 
#ifndef __ICMPV4_H__
#define    __ICMPV4_H__


#include "NetIF.h"
#include "IPv4.h"


#define    ICMPV4_TYPE_ECHO_REPLY        0
#define    ICMPV4_TYPE_ECHO_REQUEST    8


typedef uint8_t        ICMPv4_Type_t;
typedef uint8_t        ICMPv4_Code_t;


#pragma push
#pragma pack(1)
struct ICMPv4_Header
{
    uint8_t        type;
    uint8_t        code;
    uint16_t    crc;
    union 
    {
        uint32_t    restOfHeader;
        struct
        {
            uint16_t    id,
                        sequence;
        } ping;
    } rest;
};
#pragma pop
typedef struct ICMPv4_Header ICMPv4_Header_t;


extern Protocol_Handler_t    icmpv4;


uint16_t	ICMPv4_ComputeCRC(ICMPv4_Header_t *packet, int32_t length);
Bool_t		ICMPv4_CheckCRC(ICMPv4_Header_t *packet, int32_t length);
void		ICMPv4_DumpHeader(const char *prefix, IPv4_Header_t *ipv4Header);

#endif /* __ICMPV4_H__ */
