/*
 * $Id: Debug.h 24 2011-06-07 15:51:50Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-07 17:51:50 +0200 (mar., 07 juin 2011) $
 * $Rev: 24 $
 * 
 * 
 * 
 * 
 * 
 */
 
#ifndef __DEBUG_H__
#define    __DEBUG_H__

#include "mbedNet.h"
#include <stdio.h>
#include <stdint.h>

#define    DEBUG_BUFFER_DUMP_LINE_LEN        16


#define    DEBUG_LEVEL_INFO        0x00000001ul
#define    DEBUG_LEVEL_WARNING        0x00000002ul
#define    DEBUG_LEVEL_ERROR        0x00000004ul
#define    DEBUG_LEVEL_PANIC        0x00000008ul
#define    DEBUG_LEVEL_VERBOSE0    0x00000010ul
#define    DEBUG_LEVEL_VERBOSE1    0x00000020ul
#define    DEBUG_LEVEL_VERBOSE2    0x00000040ul
#define    DEBUG_LEVEL_ALL            0xFFFFFFFFul

typedef uint32_t Debug_LevelMask_t;


#define    DEBUG_MODULE_MBEDNETIF    0x00000001ul
#define    DEBUG_MODULE_NETIF        0x00000002ul
#define    DEBUG_MODULE_ARP        0x00000004ul
#define    DEBUG_MODULE_ETHERNET    0x00000008ul
#define    DEBUG_MODULE_IPV4        0x00000010ul
#define    DEBUG_MODULE_ICMPV4        0x00000020ul
#define    DEBUG_MODULE_UDPV4        0x00000040ul
#define    DEBUG_MODULE_TCPV4        0x00000080ul
#define    DEBUG_MODULE_SOCKETS    0x00000100ul
#define    DEBUG_MODULE_QUEUE        0x00000200ul
#define    DEBUG_MODULE_ALL        0xFFFFFFFFul


#ifndef DEBUG_ON

#define    DEBUG_SOURCE(level, x)
#define    DEBUG_MODULE(level, x)
#define    DEBUG(level, x)        
#define    DEBUG_NOCRLF(level, x)
#define    DEBUG_CLEAR()        
#define    DEBUG_RAW(x)        
#define    DEBUG_RAW_NOCRLF(x)    
#define    DEBUG_BLOCK(x)

#else    /* DEBUG_ON */

#define    DEBUG_CONDITION(level)    (((DEBUG_CURRENT_MODULE_ID & debug_ModuleMask) != 0) && ((level & debug_LevelMask)) != 0)

#define    DEBUG_SOURCE(level, x)    if DEBUG_CONDITION(level) \
                                { \
                                    printf("%10s: [%10s] %s:%d %s():", \
                                    DEBUG_CURRENT_MODULE_NAME, \
                                    Debug_GetText(level), \
                                    __FILE__, __LINE__, __FUNCTION__); \
                                    printf x; printf("\r\n"); \
                                }
                                    
#define    DEBUG_MODULE(level, x)    if DEBUG_CONDITION(level) { printf("[%-10s] %10s: ", Debug_GetText(level), DEBUG_CURRENT_MODULE_NAME); printf x; printf("\r\n"); }
#define    DEBUG(level, x)            if DEBUG_CONDITION(level) { printf x; printf("\r\n") }
#define    DEBUG_NOCRLF(level, x)    if DEBUG_CONDITION(level) { printf x; }
#define DEBUG_CLEAR()            printf("%c", 12)
#define    DEBUG_RAW(x)            printf x; printf("\r\n")
#define    DEBUG_RAW_NOCRLF(x)        printf x


#define    DEBUG_BLOCK(level)    if DEBUG_CONDITION(level)


#endif    /* DEBUG_ON */


typedef uint32_t Debug_ModuleMask_t;


extern Debug_LevelMask_t    debug_LevelMask;
extern Debug_ModuleMask_t    debug_ModuleMask;



const char *Debug_GetText(uint32_t level);
void Debug_DumpBufferHex(uint8_t *buffer, int32_t length);
void Debug_SetMasks(Debug_ModuleMask_t moduleMask, Debug_LevelMask_t levelMask);

#endif  /* __DEBUG_H__ */
