/*
 * $Id: TCPv4.h 23 2011-06-06 06:03:23Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-06 08:03:23 +0200 (lun., 06 juin 2011) $
 * $Rev: 23 $
 * 
 * 
 * 
 * 
 * 
 */
 
#ifndef __TCPV4_H__
#define    __TCPV4_H__

#include "NetIF.h"
#include "IPv4.h"

#pragma push
#pragma pack(1)
struct TCPv4_Header
{
    uint16_t    sourcePort,
                destPort;
    uint32_t    sequence,
                ack;
                
    uint8_t        offset:4;
    uint8_t        reserved1:4;
    
    uint8_t        FIN:1,
                SYN:1,
                RST:1,
                PSH:1,
                ACK:1,
                URG:1,
                reserved2:2;
    uint16_t    window,
                crc,
                pointer;
                
};
#pragma pop
typedef struct TCPv4_Header TCPv4_Header_t;


extern Protocol_Handler_t tcpv4;


void TCPv4_DumpHeader(const char *prefix, IPv4_Header_t *ipv4Header);


#endif /* __UDPV4_H__ */

