/*
 * $Id: TCPv4.c 29 2011-06-11 14:53:08Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-11 16:53:08 +0200 (sam., 11 juin 2011) $
 * $Rev: 29 $
 * 
 * 
 * 
 * 
 * 
 */
 
#include "TCPv4.h"
#include "Debug.h"


#define	DEBUG_CURRENT_MODULE_NAME	"TCPv4"
#define	DEBUG_CURRENT_MODULE_ID		DEBUG_MODULE_TCPV4


static void Init(void);
static void Handler(NetIF_t *netIF, NetPacket_t *packet);
static int32_t RegisterAPI(Net_API_t *api);


Protocol_Handler_t	tcpv4 = 
{ 
	PROTOCOL_INDEX_NOT_INITIALIZED, 	/* Always PROTOCOL_INDEX_NOT_INITIALIZED at initialization */
	Protocol_ID_TCPv4, 					/* Protocol ID */
	IPV4_PROTO_TCPV4, 					/* Protocol number */
	Init, 								/* Protocol initialisation function */
	Handler, 							/* Protocol handler */
	NULL, 								/* Protocol registration function */
	RegisterAPI,						/* API registration function */
};


static void Init(void)
{
	DEBUG_MODULE(DEBUG_LEVEL_INFO, ("Initializing TCPv4 layer"));
}


static void Handler(NetIF_t *netIF, NetPacket_t *packet)
{
	//TCPv4_Header_t	*tcpv4Header;
	IPv4_Header_t	*ipv4Header;
	int32_t			depth;
	
	depth = packet->depth;
	//tcpv4Header = (TCPv4_Header_t *)packet->data;
	ipv4Header = (IPv4_Header_t *)packet->headerPtrTable[depth];
	
	TCPv4_DumpHeader(NULL, ipv4Header);
	Debug_DumpBufferHex((uint8_t *)ipv4Header, 52);
}


static int32_t RegisterAPI(Net_API_t *api)
{
	return -1;
}


void TCPv4_DumpHeader(const char *prefix, IPv4_Header_t *ipv4Header)
{
	TCPv4_Header_t	*tcpv4Header = (TCPv4_Header_t *)(ipv4Header + 1);

	DEBUG_RAW(("%sTCPv4 %d.%d.%d.%d:%d --> %d.%d.%d.%d:%d seq:%ld ack:%ld off:%d flags:%c%c%c%c%c%c window:%d crc:%04X ptr:%d",
		prefix != NULL ? prefix : "",
		ipv4Header->source.IP0,
		ipv4Header->source.IP1,
		ipv4Header->source.IP2,
		ipv4Header->source.IP3,
		ntohs(tcpv4Header->sourcePort),
		ipv4Header->dest.IP0,
		ipv4Header->dest.IP1,
		ipv4Header->dest.IP2,
		ipv4Header->dest.IP3,
		ntohs(tcpv4Header->destPort),
		ntohs(tcpv4Header->sequence),
		ntohs(tcpv4Header->ack),
		tcpv4Header->offset,
		
		tcpv4Header->URG ? 'U' : '-',
		tcpv4Header->ACK ? 'A' : '-',
		tcpv4Header->PSH ? 'P' : '-',
		tcpv4Header->RST ? 'R' : '-',
		tcpv4Header->SYN ? 'S' : '-',
		tcpv4Header->FIN ? 'F' : '-',
		
		ntohs(tcpv4Header->window),
		ntohs(tcpv4Header->crc),
		ntohs(tcpv4Header->pointer)
		
	));
}

