/*
 * $Id: NetIF.h 29 2011-06-11 14:53:08Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-11 16:53:08 +0200 (sam., 11 juin 2011) $
 * $Rev: 29 $
 * 
 * 
 * 
 * 
 * 
 */
 
#ifndef	__NETIF_H__
#define	__NETIF_H__

#include "mbedNet.h"


struct IPv4_Header;
typedef struct IPv4_Header IPv4_Header_t;
struct NetIF;
typedef struct NetIF NetIF_t;
struct Protocol_Handler;
typedef struct Protocol_Handler Protocol_Handler_t;
typedef int32_t (*enet_drv_init_t)(NetIF_t *);
typedef int32_t (*enet_drv_read_t)(uint8_t **, int32_t *);
typedef int32_t (*enet_drv_write_t)(uint8_t *, int32_t);
typedef void (*enet_drv_enable_t)(void);
typedef void (*enet_drv_disable_t)(void);
typedef uint8_t *(*enet_drv_get_tx_buffer_t)(void);


enum Protocol_ID
{
    Protocol_ID_Ethernet = 0,
    Protocol_ID_ARP,
    Protocol_ID_IPv4,
    Protocol_ID_ICMPv4,
    Protocol_ID_UDPv4,
    Protocol_ID_TCPv4,
    Protocol_ID_Count,
};
typedef enum Protocol_ID Protocol_ID_t;


struct NetPacket
{
    int8_t            depth;
    uint8_t            *headerPtrTable[NET_ENCAPSULATION_MAX_DEPTH];
    uint16_t        headerLenTable[NET_ENCAPSULATION_MAX_DEPTH];
    Protocol_ID_t    protocolTable[NET_ENCAPSULATION_MAX_DEPTH];
    uint8_t            *data;
    int32_t            length;
};
typedef struct NetPacket NetPacket_t;


enum API_ID
{
    API_ID_Sockets,
    API_ID_Count,
};
typedef enum API_ID API_ID_t;


struct Net_API
{
    API_ID_t        apiID;
    void             (*InitAPI)(void);
    int32_t         (*Hook)(NetIF_t *netIF, Protocol_ID_t protocolID, NetPacket_t *packet);
};
typedef struct Net_API Net_API_t;


typedef int32_t (*Protocol_RegisterFunction_t)(Protocol_Handler_t *);
typedef void (*Protocol_HandlerFunction_t)(NetIF_t *, NetPacket_t *);
typedef void (*Protocol_InitFunction_t)(void);
typedef int32_t (*API_RegisterFunction_t)(Net_API_t *);
typedef void (*PeriodicFunction_t)(void);
typedef int16_t FunctionPeriod_t;


typedef int32_t    NetIF_DriverIndex_t;
struct NetIF_Driver
{
    char                        *name;
    enet_drv_init_t             Init;
    enet_drv_read_t             Read;
    enet_drv_write_t            Write;
	enet_drv_enable_t			Enable;
	enet_drv_disable_t			Disable;
    enet_drv_get_tx_buffer_t    GetTxBuffer;
    Protocol_Handler_t          *protocolHandler;
    uint16_t                    mtu;
};
typedef struct NetIF_Driver NetIF_Driver_t;


typedef int32_t                    Protocol_Index_t;
#define    PROTOCOL_INDEX_NOT_INITIALIZED    -1

typedef uint32_t                Protocol_Number_t;
#define    PROTOCOL_NUMBER_NONE            0

struct Protocol_Handler
{
    Protocol_Index_t            index;
    Protocol_ID_t                protocolID;
    Protocol_Number_t            protocolNumber;
    Protocol_InitFunction_t        Init;
    Protocol_HandlerFunction_t    HandlePacket;
    Protocol_RegisterFunction_t    RegisterProtocol;
    API_RegisterFunction_t        RegisterAPI;
};


typedef int32_t    NetIF_Index_t;
struct NetIF
{
    NetIF_Index_t                  index;
    const char                     *name;
    IPv4_Addr_t                    ipv4Address;
    IPv4_Addr_t                    ipv4Netmask;
    IPv4_Addr_t                    ipv4Network;
    IPv4_Addr_t                    ipv4Gateway;
    IPv4_Addr_t                    ipv4Broadcast;
    NetIF_Driver_t                 *driver;
    void                           *driverParameter;
	Bool_t							up;
};


extern const char                 *api_IDNames[API_ID_Count];
extern const char                 *protocol_IDNames[Protocol_ID_Count];


NetIF_t    *NetIF_RegisterInterface(IPv4_Addr_t *address, IPv4_Addr_t *netmask, IPv4_Addr_t *gateway, NetIF_Driver_t *driver, void *driverParameter);
int32_t    NetIF_RegisterPeriodicFunction(char *name, PeriodicFunction_t function, FunctionPeriod_t period);
int32_t    NetIF_ProcessTimers(int32_t elapsedTime);
int32_t    NetIF_SendIPv4Packet(IPv4_Header_t *ipv4Header);
int32_t    NetIF_Up(NetIF_t *netIF);
int32_t    NetIF_Down(NetIF_t *netIF);
void       NetIF_ProtoPop(NetPacket_t *packet);
void       NetIF_ProtoPush(NetPacket_t *packet, int32_t headerSize, Protocol_ID_t protocol);

#endif /* __NETIF_H__ */
