/*
 * $Id: IPv4.h 27 2011-06-09 12:55:57Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-09 14:55:57 +0200 (jeu., 09 juin 2011) $
 * $Rev: 27 $
 * 
 * 
 * 
 * 
 * 
 */
 
#ifndef __IPV4_H__
#define __IPV4_H__

#include "NetIF.h"


#define    IPV4_PROTO_ICMPV4        1
#define    IPV4_PROTO_TCPV4        6
#define    IPV4_PROTO_UDPV4        17


#define    IPV4_VERSION            4
#define    IPV4_FLAG_DF            0x02
#define    IPV4_FLAG_MF            0x04

typedef uint16_t                IPv4_Proto_t;


#pragma push
#pragma pack(1)
struct IPv4_Header
{
    uint8_t        ihl                :4;
    uint8_t        version            :4;
    uint8_t        tos;
    uint16_t    totalLength;
    uint16_t    id;
    uint16_t    fragmentFlags;
    uint8_t        ttl;
    uint8_t        protocol;
    uint16_t    crc;
    IPv4_Addr_t    source,
                dest;
};
#pragma pop
typedef struct IPv4_Header IPv4_Header_t;


extern Protocol_Handler_t ipv4;


void        IPv4_DumpIPv4Header(const char *prefix, IPv4_Header_t *ipv4Packet);
uint16_t    IPv4_ComputeCRC(IPv4_Header_t *ipv4Header);


#endif /* __IPV4_H__ */

