/*
 * $Id: Queue.c 29 2011-06-11 14:53:08Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-11 16:53:08 +0200 (sam., 11 juin 2011) $
 * $Rev: 29 $
 * 
 * 
 * 
 * 
 * 
 */
 
#include "CQueue.h"
#include "Debug.h"
#include <stdlib.h>
#include <string.h>


#define    DEBUG_CURRENT_MODULE_NAME    "Queue"
#define    DEBUG_CURRENT_MODULE_ID        DEBUG_MODULE_QUEUE


CQueue_t *CQueue_Alloc(int16_t size)
{
    CQueue_t        *queue;
    
    queue = (CQueue_t *)malloc(sizeof(CQueue_t));
    if (queue == NULL)
    {
        DEBUG_MODULE(DEBUG_LEVEL_WARNING, ("Not enough memory"));
        mbedNet_LastError = mbedNetResult_NotEnoughMemory;
        goto Exit;
    }
    memset(queue, 0, sizeof(CQueue_t));
    
    queue->size = size + 1;
    
    DEBUG_MODULE(DEBUG_LEVEL_INFO, ("%d-%d Allocated queue of %d items", queue->popIndex, queue->pushIndex, size));
    
Exit:
    return queue;
}


int32_t CQueue_Push(CQueue_t *queue, void *entry)
{
    int32_t        result = 0;
    int16_t        index;
    
    if (queue->popIndex == ((queue->pushIndex + 1) % queue->size))
    {
        DEBUG_MODULE(DEBUG_LEVEL_INFO, ("%d-%d Queue is full", queue->popIndex, queue->pushIndex));
        result = -1;
        mbedNet_LastError = mbedNetResult_QueueFull;
        goto Exit;
    }
    
    index = queue->pushIndex;
    queue->entries[index] = entry;
    index++;
    if (index == queue->size) index = 0;
    queue->pushIndex = index;
    
    DEBUG_MODULE(DEBUG_LEVEL_INFO, ("%d-%d Pushing one entry from queue", queue->popIndex, queue->pushIndex));
    
Exit:
    return result;
}


int32_t CQueue_Pop(CQueue_t *queue, void **entry)
{
    int32_t        result = 0;
    int16_t        index;
    
    if (queue->popIndex == queue->pushIndex)
    {
        DEBUG_MODULE(DEBUG_LEVEL_INFO, ("%d-%d Queue is empty", queue->popIndex, queue->pushIndex));
        result = -1;
        mbedNet_LastError = mbedNetResult_QueueEmpty;
        goto Exit;
    }
    

    index = queue->popIndex;
    *entry = queue->entries[index];
    index++;
    if (index == queue->size) index = 0;
    queue->popIndex = index;

    DEBUG_MODULE(DEBUG_LEVEL_INFO, ("%d-%d Popping one entry from queue", queue->popIndex, queue->pushIndex));
        
Exit:
    return result;
}


int32_t CQueue_Peek(CQueue_t *queue, void **entry)
{
    int32_t        result = 0;
    int16_t        index;
    
    if (queue->popIndex == queue->pushIndex)
    {
        DEBUG_MODULE(DEBUG_LEVEL_INFO, ("%d-%d Queue is empty", queue->popIndex, queue->pushIndex));
        result = -1;
        mbedNet_LastError = mbedNetResult_QueueEmpty;
        goto Exit;
    }
    
    index = queue->popIndex;
    *entry = queue->entries[index];

    DEBUG_MODULE(DEBUG_LEVEL_INFO, ("%d-%d Peeking first entry from queue", queue->popIndex, queue->pushIndex));
        
Exit:
    return result;
}


int32_t CQueue_Free(CQueue_t *queue)
{
    int32_t        result = 0;
    
    DEBUG_MODULE(DEBUG_LEVEL_INFO, ("%d-%d Free queue", queue->popIndex, queue->pushIndex));
    free(queue);
    
    return result;
}


Bool_t CQueue_IsEmpty(const CQueue_t *queue)
{
    return (queue->popIndex == queue->pushIndex) ? True : False;
}


Bool_t CQueue_IsFull(const CQueue_t *queue)
{
    return (queue->popIndex == ((queue->pushIndex + 1) % queue->size)) ? True : False;
}

