/*
 * $Id: Sockets.h 27 2011-06-09 12:55:57Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-09 14:55:57 +0200 (jeu., 09 juin 2011) $
 * $Rev: 27 $
 * 
 * 
 * 
 * 
 * 
 */
 
#ifndef __SOCKETS_H__
#define    __SOCKETS_H__


#include <stdint.h>
#include "NetIF.h"


typedef int32_t    Socket_t;

enum Socket_Family
{
    AF_INET = 0,
    AF_INET6,
    Socket_Family_Count,
};
typedef enum Socket_Family Socket_Family_t;


enum Socket_Protocol
{
    SOCK_DGRAM = 0,
    SOCK_STREAM,
    SOCK_RAW,
    Socket_Protocol_Count,
};
typedef enum Socket_Protocol Socket_Protocol_t;


#pragma push
#pragma pack(1)
struct Socket_Addr
{
    Socket_Family_t        family;
    uint16_t            len;
};
#pragma pop
typedef struct Socket_Addr Socket_Addr_t;


#pragma push
#pragma pack(1)
struct Socket_AddrIn
{
    Socket_Family_t        family;
    uint16_t            len;
    IPv4_Addr_t            address;
    uint16_t            port;
};
#pragma pop
typedef struct Socket_AddrIn Socket_AddrIn_t;


extern Net_API_t    sockets;


Socket_t    Sockets_Open(Socket_Family_t family, Socket_Protocol_t protocol, int32_t options);
int32_t    Sockets_Bind(Socket_t socket, Socket_Addr_t *addr, int32_t addrLen);
int32_t    Sockets_Send(Socket_t socket, uint8_t *data, int32_t length, int32_t flags);
int32_t    Sockets_SendTo(Socket_t socket, uint8_t *data, int32_t length, int32_t flags, const Socket_Addr_t *remoteAddr, int32_t addrLen);
int32_t    Sockets_Recv(Socket_t socket, uint8_t *data, int32_t length, int32_t flags);
int32_t    Sockets_RecvFrom(Socket_t socket, uint8_t *data, int32_t length, int32_t flags, Socket_Addr_t *remoteAddr, int32_t *addrLen);
int32_t    Sockets_Close(Socket_t socket);


#endif /* __SOCKET_H__ */
