/*
 * $Id: Queue.h 26 2011-06-09 10:24:02Z benoit $
 * $Author: benoit $
 * $Date: 2011-06-09 12:24:02 +0200 (jeu., 09 juin 2011) $
 * $Rev: 26 $
 * 
 * 
 * 
 * 
 * 
 */
 
#ifndef __CQUEUE_H__
#define    __CQUEUE_H__


#include <stdint.h>
#include "mbedNet.h"

struct CQueue
{
    uint8_t            pushIndex, 
                    popIndex;
    void            *entries[QUEUE_MAX_ENTRY_COUNT + 1];
    int16_t            size;
};
typedef struct CQueue CQueue_t;


CQueue_t    *CQueue_Alloc(int16_t size);
int32_t     CQueue_Push(CQueue_t *queue, void *entry);
int32_t     CQueue_Pop(CQueue_t *queue, void **entry);
int32_t     CQueue_Peek(CQueue_t *queue, void **entry);
int32_t     CQueue_Free(CQueue_t *queue);
Bool_t      CQueue_IsEmpty(const CQueue_t *queue);
Bool_t      CQueue_IsFull(const CQueue_t *queue);


#endif /* __QUEUE_H__ */

