/*$Id:
 * ARP.h 29 2011-06-11 14:53:08Z benoit $ $AUTHOR: BENOIT $ $Date: 2011-06-11
 * 16:53:08 +0200 (sam., 11 juin 2011) $ $Rev: 29 $
 */
#ifndef __ARP_H__
#define __ARP_H__

#include "IPv4.h"
#include "Ethernet.h"

#define ARP_HW_TYPE_ENET		0x0001

#define ARP_OPERATION_REQUEST	0x0001
#define ARP_OPERATION_REPLY		0x0002

typedef uint16_t	ARP_Type_t;
typedef uint16_t	ARP_Protocol_t;
typedef uint16_t	ARP_Operation_t;

#pragma push
#pragma pack(1)
struct ARP_Header
{
	ARP_Type_t		type;
	ARP_Protocol_t	protocol;
	uint8_t			hardAddrLen;
	uint8_t			protoAddrLen;
	ARP_Operation_t operation;
};
#pragma pop
typedef struct ARP_Header	ARP_Header_t;

#pragma push
#pragma pack(1)
struct ARP_IPv4Data
{
	Ethernet_Addr_t hwSource;
	IPv4_Addr_t		ipSource;
	Ethernet_Addr_t hwDest;
	IPv4_Addr_t		ipDest;
};
#pragma pop
typedef struct ARP_IPv4Data ARP_IPv4Data_t;

extern Protocol_Handler_t	arp;

int32_t						ARP_ResolveIPv4Address(NetIF_t *netIF, IPv4_Addr_t address, Ethernet_Addr_t *ethernetAddr);
int32_t						ARP_AddStaticEntry(NetIF_t *netIF, IPv4_Addr_t address, const Ethernet_Addr_t *ethernetAddr);
int32_t						ARP_RemoveEntry(const NetIF_t *netIF, IPv4_Addr_t address);
void						ARP_FlushCache(Bool_t flushStaticEntries);
void						ARP_Timer(void);
void						ARP_DisplayCache(void);
void						ARP_DumpHeader(const char *prefix, ARP_Header_t *arpHeader);
#endif /* __ARP_H__ */
