#include "mbed.h"
#include "modbus.h"
#include <math.h>
#include <stdio.h>

Ticker t;
DigitalOut myled(LED1);
InterruptIn mbtn(USER_BUTTON); 
RawSerial pc(USBTX, USBRX);
int a;
int b,c,d;
int casep = 0;
int16_t nub = 0;
int16_t time1;
int16_t time2;
void count()
{ nub = nub +1;
}
void press() {
    if((nub-c)>2){
        d = nub;
        time2 = d-c;
        a = nub;
        }
}
void release() {
    if((nub-b)>2){
        b = nub;
        time1 = b-a;
        c = nub ;
    }
}

void serial_callback()
{
    uint8_t frame[6];
    char ch = pc.getc();
    if (modbus_parser(ch, frame)) {
        switch(frame[3]){
            case 0: casep = 1; break; //Please enter :000300000003FA\r\n to show pushing time
            case 1: casep = 2; break; //Please enter :000300010003F9\r\n to show releasing time
            case 2: casep = 3; break; //Please enter :000300020003F8\r\n to show both pushing and releasing time

        }
    }
}

int main() {
    mbtn.fall(&press);
    mbtn.rise(&release);
    
    t.attach(&count, 0.1);
    while(1) {
        pc.attach(serial_callback);
        switch(casep){
            case 0: break;
            case 1: pc.printf("The releasing time taken was %.1f seconds\n\n",time2/10.0); break;
            case 2: pc.printf("The pushing time taken was %.1f seconds\n\n",time1/10.0); break;
            case 3: pc.printf("The pushing time taken was %.1f seconds\nThe release time taken was %.1f seconds\n\n",time1/10.0,time2/10.0); break;
            default: break; 
            }
        casep = 0;
    }
}