/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: End device commissioning parameters

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __LORA_COMMISSIONING_H__
#define __LORA_COMMISSIONING_H__

/*!
 * When set to 1 the application uses the Over-the-Air activation procedure
 * When set to 0 the application uses the Personalization activation procedure
 */
#define OVER_THE_AIR_ACTIVATION                     0

/*!
 * Indicates if the end-device is to be connected to a private or public network
 */
#define LORAWAN_PUBLIC_NETWORK                      true

/*!
 * IEEE Organizationally Unique Identifier ( OUI ) (big endian)
 * \remark This is unique to a company or organization
 */
#define IEEE_OUI                                    0x40, 0x55, 0x40 

/*!
 * Mote device IEEE EUI (big endian)
 *
 * \remark In this application, if the last 4 bytes are all 0, then the 32 bit
 *         address is automatically generated using a pseudo random generator
 *         seeded with a value derived from BoardUniqueId value
 *         If provided by user, e.g. { IEEE_OUI, 0x00, 0x00, 0x00, 0xFF, 0x01 },
 *         then this value is used by the application
 */
#define LORAWAN_DEVICE_EUI                          { IEEE_OUI, 0x55, 0x40, 0x55, 0x40, 0x56 } 

/*!
 * Application IEEE EUI (big endian)
 */
#define LORAWAN_APPLICATION_EUI                     { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C }

/*!
 * AES encryption/decryption cipher application key
 */
#define LORAWAN_APPLICATION_KEY                     { 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff }

/*!
 * Device address on the network (big endian)
 *
 * \remark In this application, if the value is 0, then the address is
 *         automatically generated using a pseudo random generator seeded with
 *         a value derived from BoardUniqueId value if provided by user, 
 *         e.g. 0x78563412, then this value is used by the application
 */
#define LORAWAN_DEVICE_ADDRESS                      ( uint32_t )0x40554056

/*!
 * AES encryption/decryption cipher network session key
 */
#define LORAWAN_NWKSKEY                             { 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF }

/*!
 * AES encryption/decryption cipher application session key
 */
#define LORAWAN_APPSKEY                             { 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF }

#endif // __LORA_COMMISSIONING_H__
