#ifndef _SPI_H_
#define _SPI_H_
    //////Included Files//////
    #include "mbed.h"
    #include <stm32f4xx.h>
    //////////////////////////
    
    ///////Definitions////////
    #define DD 25                   //Display Delay us
    #define CD 2000                 //Command Delay us
    
    // Chip Select => 111(7) = Nothing, 110(6) = General, 101(5) = LCD, 011(3) = ADC//
    #define CS_RESET 7   // RESET (No chip selected)
    #define CS_GENERAL 6   // GENERAL
    #define CS_LCD 5   // LCD
    #define CS_ADC 3   // ADC
    
    //////////////////////////
    
    ////////Functions/////////
    //Function Prototypes, will just output a string to display, see later//
    void SPI_INIT(void);
    
    void    spi_write_data(short destination, unsigned int data);
    int32_t spi_read_data(short destination);
    int32_t spi_read_write_data(short destination, unsigned int data);
    //////////////////////////
#endif
